/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class BiconnectedComponents {
    private int[] depth;
    private final Graph g;
    private final Edge[] stack;
    private int nstack = 0;
    private final List<List<Edge>> components = new ArrayList<List<Edge>>(2);
    private final BitSet cyclic = new BitSet();
    private final BitSet simple = new BitSet();
    int count = 0;
    int numfrags = 0;

    BiconnectedComponents(Graph g) {
        this(g, true);
    }

    BiconnectedComponents(Graph g, boolean storeComponents) {
        this.depth = new int[g.order()];
        this.g = g;
        this.stack = new Edge[g.size()];
        if (storeComponents) {
            int u = 0;
            while (this.count < g.order()) {
                if (this.depth[u] == 0) {
                    this.visitWithComp(u, null);
                    ++this.numfrags;
                }
                ++u;
            }
        } else {
            int u = 0;
            while (this.count < g.order()) {
                if (this.depth[u] == 0) {
                    this.visit(u, null);
                    ++this.numfrags;
                }
                ++u;
            }
        }
    }

    private int visit(int u, Edge from) {
        this.depth[u] = ++this.count;
        int d = this.g.degree(u);
        int lo = this.count + 1;
        while (--d >= 0) {
            Edge e = this.g.edgeAt(u, d);
            if (e == from) continue;
            int v = e.other(u);
            if (this.depth[v] == 0) {
                int res = this.visit(v, e);
                if (res >= lo) continue;
                lo = res;
                continue;
            }
            if (this.depth[v] >= lo) continue;
            lo = this.depth[v];
        }
        if (lo <= this.depth[u]) {
            this.cyclic.set(u);
        }
        return lo;
    }

    private int visitWithComp(int u, Edge from) {
        this.depth[u] = ++this.count;
        int j = this.g.degree(u);
        int lo = this.count + 1;
        while (--j >= 0) {
            Edge e = this.g.edgeAt(u, j);
            if (e == from) continue;
            int v = e.other(u);
            if (this.depth[v] == 0) {
                this.stack[this.nstack] = e;
                ++this.nstack;
                int tmp = this.visitWithComp(v, e);
                if (tmp == this.depth[u]) {
                    this.storeWithComp(e);
                } else if (tmp > this.depth[u]) {
                    --this.nstack;
                }
                if (tmp >= lo) continue;
                lo = tmp;
                continue;
            }
            if (this.depth[v] >= this.depth[u]) continue;
            this.stack[this.nstack] = e;
            ++this.nstack;
            if (this.depth[v] >= lo) continue;
            lo = this.depth[v];
        }
        return lo;
    }

    private void storeWithComp(Edge e) {
        Edge f;
        ArrayList<Edge> component = new ArrayList<Edge>(6);
        BitSet tmp = new BitSet();
        int numEdges = 0;
        boolean spiro = false;
        do {
            f = this.stack[--this.nstack];
            int v = f.either();
            int w = f.other(v);
            if (this.cyclic.get(v) || this.cyclic.get(w)) {
                spiro = true;
            }
            tmp.set(v);
            tmp.set(w);
            component.add(f);
            ++numEdges;
        } while (f != e);
        this.cyclic.or(tmp);
        if (!spiro && tmp.cardinality() == numEdges) {
            this.simple.or(tmp);
        }
        this.components.add(Collections.unmodifiableList(component));
    }

    public List<List<Edge>> components() {
        return Collections.unmodifiableList(this.components);
    }

    BitSet cyclic() {
        return this.cyclic;
    }

    public boolean connected() {
        return this.numfrags < 2;
    }
}

