/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.servlet.GeneratedJavaScriptHandler;
import org.directwebremoting.util.LocalUtil;

public abstract class BaseInterfaceHandler
extends GeneratedJavaScriptHandler {
    protected ModuleManager moduleManager = null;
    protected ConverterManager converterManager;
    protected String generateDtoClasses;
    private static final Log log = LogFactory.getLog(BaseInterfaceHandler.class);

    @Override
    protected String generateTemplate(String contextPath, String servletPath, String pathInfo) throws IOException {
        String scriptName = pathInfo;
        if (!scriptName.startsWith(this.getBaseInterfacePath()) || !scriptName.endsWith(".js")) {
            return null;
        }
        scriptName = scriptName.substring(this.getBaseInterfacePath().length());
        if (!LocalUtil.isValidScriptName(scriptName = scriptName.substring(0, scriptName.length() - ".js".length()))) {
            log.debug((Object)("Throwing at request for script with name: '" + scriptName + "'"));
            throw new SecurityException("Illegal script name.");
        }
        if (scriptName.contains("/")) {
            Pattern p = Pattern.compile(scriptName.replaceAll("/", "[/\\.]"));
            String match = null;
            for (String moduleName : this.moduleManager.getModuleNames(false)) {
                if (!p.matcher(moduleName).matches()) continue;
                if (match == null) {
                    match = moduleName;
                    continue;
                }
                throw new IllegalArgumentException("Script name '" + scriptName + "' matches several modules.");
            }
            if (match != null) {
                scriptName = match;
            }
        }
        return this.generateInterfaceScript(contextPath, servletPath, scriptName);
    }

    protected abstract String getBaseInterfacePath();

    public abstract String generateInterfaceScript(String var1, String var2, String var3);

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setGenerateDtoClasses(String generateDtoClasses) {
        this.generateDtoClasses = generateDtoClasses;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getBaseInterfacePath() + ")";
    }
}

