/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;

final class MaxTargetSliceSupplier {
    MaxTargetSliceSupplier() {
    }

    static IndexSearcher.LeafSlice[] getSlices(List<LeafReaderContext> leaves, int targetMaxSlice) {
        if (targetMaxSlice <= 0) {
            throw new IllegalArgumentException("MaxTargetSliceSupplier called with unexpected slice count of " + targetMaxSlice);
        }
        int targetSliceCount = Math.min(targetMaxSlice, leaves.size());
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        sortedLeaves.sort(Collections.reverseOrder(Comparator.comparingInt(l -> l.reader().maxDoc())));
        ArrayList groupedLeaves = new ArrayList(targetSliceCount);
        for (int i = 0; i < targetSliceCount; ++i) {
            groupedLeaves.add(new ArrayList());
        }
        PriorityQueue<Group> groupQueue = new PriorityQueue<Group>();
        for (int i = 0; i < targetSliceCount; ++i) {
            groupQueue.offer(new Group(i));
        }
        for (int i = 0; i < sortedLeaves.size(); ++i) {
            Group minGroup = (Group)groupQueue.poll();
            ((List)groupedLeaves.get(minGroup.index)).add(IndexSearcher.LeafReaderContextPartition.createForEntireSegment((LeafReaderContext)((LeafReaderContext)sortedLeaves.get(i))));
            minGroup.sum += ((LeafReaderContext)sortedLeaves.get(i)).reader().maxDoc();
            groupQueue.offer(minGroup);
        }
        return (IndexSearcher.LeafSlice[])groupedLeaves.stream().map(IndexSearcher.LeafSlice::new).toArray(IndexSearcher.LeafSlice[]::new);
    }

    static class Group
    implements Comparable<Group> {
        final int index;
        int sum;

        public Group(int index) {
            this.index = index;
            this.sum = 0;
        }

        @Override
        public int compareTo(Group other) {
            return Integer.compare(this.sum, other.sum);
        }
    }
}

