/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ManagedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSerialConsoleAccessStatusResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetSerialConsoleAccessStatusResponse> {
    private static final SdkField<Boolean> SERIAL_CONSOLE_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SerialConsoleAccessEnabled").getter(GetSerialConsoleAccessStatusResponse.getter(GetSerialConsoleAccessStatusResponse::serialConsoleAccessEnabled)).setter(GetSerialConsoleAccessStatusResponse.setter(Builder::serialConsoleAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialConsoleAccessEnabled").unmarshallLocationName("serialConsoleAccessEnabled").build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(GetSerialConsoleAccessStatusResponse.getter(GetSerialConsoleAccessStatusResponse::managedByAsString)).setter(GetSerialConsoleAccessStatusResponse.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").unmarshallLocationName("managedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERIAL_CONSOLE_ACCESS_ENABLED_FIELD, MANAGED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSerialConsoleAccessStatusResponse.memberNameToFieldInitializer();
    private final Boolean serialConsoleAccessEnabled;
    private final String managedBy;

    private GetSerialConsoleAccessStatusResponse(BuilderImpl builder) {
        super(builder);
        this.serialConsoleAccessEnabled = builder.serialConsoleAccessEnabled;
        this.managedBy = builder.managedBy;
    }

    public final Boolean serialConsoleAccessEnabled() {
        return this.serialConsoleAccessEnabled;
    }

    public final ManagedBy managedBy() {
        return ManagedBy.fromValue(this.managedBy);
    }

    public final String managedByAsString() {
        return this.managedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serialConsoleAccessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSerialConsoleAccessStatusResponse)) {
            return false;
        }
        GetSerialConsoleAccessStatusResponse other = (GetSerialConsoleAccessStatusResponse)((Object)obj);
        return Objects.equals(this.serialConsoleAccessEnabled(), other.serialConsoleAccessEnabled()) && Objects.equals(this.managedByAsString(), other.managedByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSerialConsoleAccessStatusResponse").add("SerialConsoleAccessEnabled", (Object)this.serialConsoleAccessEnabled()).add("ManagedBy", (Object)this.managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SerialConsoleAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.serialConsoleAccessEnabled()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SerialConsoleAccessEnabled", SERIAL_CONSOLE_ACCESS_ENABLED_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSerialConsoleAccessStatusResponse, T> g) {
        return obj -> g.apply((GetSerialConsoleAccessStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean serialConsoleAccessEnabled;
        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSerialConsoleAccessStatusResponse model) {
            super(model);
            this.serialConsoleAccessEnabled(model.serialConsoleAccessEnabled);
            this.managedBy(model.managedBy);
        }

        public final Boolean getSerialConsoleAccessEnabled() {
            return this.serialConsoleAccessEnabled;
        }

        public final void setSerialConsoleAccessEnabled(Boolean serialConsoleAccessEnabled) {
            this.serialConsoleAccessEnabled = serialConsoleAccessEnabled;
        }

        @Override
        public final Builder serialConsoleAccessEnabled(Boolean serialConsoleAccessEnabled) {
            this.serialConsoleAccessEnabled = serialConsoleAccessEnabled;
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(ManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetSerialConsoleAccessStatusResponse build() {
            return new GetSerialConsoleAccessStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSerialConsoleAccessStatusResponse> {
        public Builder serialConsoleAccessEnabled(Boolean var1);

        public Builder managedBy(String var1);

        public Builder managedBy(ManagedBy var1);
    }
}

