/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ResourceStat
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResourceStat> {
    private final long cpuTimeInNanos;
    private final long memoryInBytes;
    public static final JsonpDeserializer<ResourceStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResourceStat::setupResourceStatDeserializer);

    private ResourceStat(Builder builder) {
        this.cpuTimeInNanos = ApiTypeHelper.requireNonNull(builder.cpuTimeInNanos, this, "cpuTimeInNanos");
        this.memoryInBytes = ApiTypeHelper.requireNonNull(builder.memoryInBytes, this, "memoryInBytes");
    }

    public static ResourceStat of(Function<Builder, ObjectBuilder<ResourceStat>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long cpuTimeInNanos() {
        return this.cpuTimeInNanos;
    }

    public final long memoryInBytes() {
        return this.memoryInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu_time_in_nanos");
        generator.write(this.cpuTimeInNanos);
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResourceStatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpuTimeInNanos, JsonpDeserializer.longDeserializer(), "cpu_time_in_nanos");
        op.add(Builder::memoryInBytes, JsonpDeserializer.longDeserializer(), "memory_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.cpuTimeInNanos);
        result = 31 * result + Long.hashCode(this.memoryInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceStat other = (ResourceStat)o;
        return this.cpuTimeInNanos == other.cpuTimeInNanos && this.memoryInBytes == other.memoryInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ResourceStat> {
        private Long cpuTimeInNanos;
        private Long memoryInBytes;

        public Builder() {
        }

        private Builder(ResourceStat o) {
            this.cpuTimeInNanos = o.cpuTimeInNanos;
            this.memoryInBytes = o.memoryInBytes;
        }

        private Builder(Builder o) {
            this.cpuTimeInNanos = o.cpuTimeInNanos;
            this.memoryInBytes = o.memoryInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cpuTimeInNanos(long value) {
            this.cpuTimeInNanos = value;
            return this;
        }

        @Nonnull
        public final Builder memoryInBytes(long value) {
            this.memoryInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public ResourceStat build() {
            this._checkSingleUse();
            return new ResourceStat(this);
        }
    }
}

