/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImplWithEntityAndAnonCaching;

public abstract class OWLSubPropertyAxiomImpl<P extends OWLPropertyExpression>
extends OWLPropertyAxiomImplWithEntityAndAnonCaching
implements OWLSubPropertyAxiom<P> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final P subProperty;
    @Nonnull
    private final P superProperty;

    public OWLSubPropertyAxiomImpl(@Nonnull P subProperty, @Nonnull P superProperty, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subProperty = (OWLPropertyExpression)OWLAPIPreconditions.checkNotNull(subProperty, "subProperty cannot be null");
        this.superProperty = (OWLPropertyExpression)OWLAPIPreconditions.checkNotNull(superProperty, "superProperty cannot be null");
    }

    @Override
    public P getSubProperty() {
        return this.subProperty;
    }

    @Override
    public P getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLSubPropertyAxiom)) {
            return false;
        }
        OWLSubPropertyAxiom other = (OWLSubPropertyAxiom)obj;
        return other.getSubProperty().equals(this.subProperty) && other.getSuperProperty().equals(this.superProperty);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubPropertyAxiom other = (OWLSubPropertyAxiom)object;
        int diff = this.subProperty.compareTo(other.getSubProperty());
        if (diff != 0) {
            return diff;
        }
        return this.superProperty.compareTo(other.getSuperProperty());
    }
}

