/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;

public class PDType3Font
extends PDSimpleFont {
    private static final Log LOG = LogFactory.getLog(PDType3Font.class);
    private float type3Height = 0.0f;

    public PDType3Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE3);
    }

    public PDType3Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    @Override
    public void drawString(String string, int[] codePoints, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        LOG.info("Rendering of type3 fonts isn't supported in PDFBox 1.8.x. It will be available in the 2.0 version!");
    }

    public void setFontMatrix(PDMatrix matrix) {
        this.font.setItem(COSName.FONT_MATRIX, (COSObjectable)matrix);
    }

    @Override
    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float height = super.getFontHeight(c, offset, length);
        if (height == 0.0f) {
            if (this.type3Height != 0.0f) {
                return this.type3Height;
            }
            COSBase bboxBase = this.font.getDictionaryObject(COSName.FONT_BBOX);
            if (bboxBase instanceof COSArray) {
                COSArray bboxArray = (COSArray)bboxBase;
                COSBase o1 = bboxArray.getObject(1);
                COSBase o3 = bboxArray.getObject(3);
                if (bboxArray.size() == 4 && o1 instanceof COSNumber && o3 instanceof COSNumber) {
                    height = ((COSNumber)o3).floatValue() - ((COSNumber)o1).floatValue();
                    this.type3Height = height / 2.0f;
                    return this.type3Height;
                }
            }
        }
        return height;
    }
}

