/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.adobe.epubcheck.util.Messages;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.idpf.epubcheck.util.css.CssContentHandler;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssGrammar;
import org.idpf.epubcheck.util.css.CssScanner;
import org.idpf.epubcheck.util.css.CssSource;
import org.idpf.epubcheck.util.css.CssToken;
import org.idpf.epubcheck.util.css.CssTokenList;

public final class CssParser {
    private final boolean debug = false;
    private final Messages messages;
    private final CssGrammar.CssSelectorConstructFactory cssSelectorFactory;

    public CssParser() {
        this(Locale.getDefault());
    }

    public CssParser(Locale locale) {
        this.messages = Messages.getInstance(locale, CssParser.class);
        this.cssSelectorFactory = new CssGrammar.CssSelectorConstructFactory(locale);
    }

    public void parse(CssSource source, CssErrorHandler err, CssContentHandler doc) throws IOException, CssExceptions.CssException {
        this.parse(source.newReader(), source.getSystemID(), err, doc);
    }

    public void parse(Reader reader, String systemID, CssErrorHandler err, CssContentHandler doc) throws IOException, CssExceptions.CssException {
        CssTokenList.CssTokenIterator iter = this.scan(reader, systemID, err);
        doc.startDocument();
        while (iter.hasNext(CssTokenList.Filters.FILTER_S_CMNT_CDO_CDC)) {
            CssToken tk = iter.next(CssTokenList.Filters.FILTER_S_CMNT_CDO_CDC);
            try {
                if (tk.type == CssToken.Type.ATKEYWORD) {
                    this.handleAtRule(tk, iter, doc, err);
                    continue;
                }
                this.handleRuleSet(tk, iter, doc, err);
            }
            catch (CssTokenList.PrematureEOFException te) {
                break;
            }
        }
        doc.endDocument();
    }

    public void parseStyleAttribute(Reader reader, String systemID, CssErrorHandler err, CssContentHandler doc) throws IOException, CssExceptions.CssException {
        CssTokenList.CssTokenIterator iter = this.scan(reader, systemID, err);
        doc.startDocument();
        while (iter.hasNext()) {
            CssToken tk = iter.next();
            if (CssToken.Matchers.MATCH_SEMI.apply((Object)tk)) continue;
            try {
                CssGrammar.CssDeclaration decl = this.handleDeclaration(tk, iter, doc, err, true);
                if (decl != null) {
                    doc.declaration(decl);
                    continue;
                }
                return;
            }
            catch (CssTokenList.PrematureEOFException te) {
                break;
            }
        }
        doc.endDocument();
    }

    private CssTokenList.CssTokenIterator scan(Reader reader, String systemID, CssErrorHandler err) throws IOException, CssExceptions.CssException {
        final CssTokenList tokens = new CssTokenList();
        new CssScanner(reader, systemID, err, new CssToken.CssTokenConsumer(){

            @Override
            public void add(CssToken token) {
                tokens.add(token);
            }
        }, this.messages.getLocale()).scan();
        return tokens.iterator(CssTokenList.Filters.FILTER_S_CMNT);
    }

    private void handleRuleSet(CssToken start, CssTokenList.CssTokenIterator iter, CssContentHandler doc, CssErrorHandler err) throws CssExceptions.CssException {
        char errChar = '{';
        try {
            List<CssGrammar.CssSelector> selectors = this.cssSelectorFactory.createSelectorList(start, iter, err);
            errChar = '}';
            if (selectors == null) {
                iter.next(CssToken.Matchers.MATCH_CLOSEBRACE);
                return;
            }
            if (CssToken.Matchers.MATCH_CLOSEPAREN.apply((Object)iter.last)) {
                err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_UNEXPECTED_TOKEN, iter.last.location, this.messages.getLocale(), iter.last.chars));
                iter.next(CssToken.Matchers.MATCH_CLOSEBRACE);
                return;
            }
            doc.selectors(selectors);
            this.handleDeclarationBlock(iter.next(), iter, doc, err);
            doc.endSelectors(selectors);
        }
        catch (NoSuchElementException nse) {
            err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_PREMATURE_EOF, iter.last.location, this.messages.getLocale(), "'" + errChar + "'"));
            throw new CssTokenList.PrematureEOFException();
        }
    }

    private void handleDeclarationBlock(CssToken start, CssTokenList.CssTokenIterator iter, CssContentHandler doc, CssErrorHandler err) throws CssExceptions.CssException {
        while (!CssToken.Matchers.MATCH_CLOSEBRACE.apply((Object)start)) {
            CssGrammar.CssDeclaration decl = this.handleDeclaration(start, iter, doc, err, false);
            try {
                if (decl != null) {
                    doc.declaration(decl);
                    if (CssToken.Matchers.MATCH_CLOSEBRACE.apply((Object)iter.last)) {
                        return;
                    }
                    if (CssToken.Matchers.MATCH_SEMI.apply((Object)iter.last) && CssToken.Matchers.MATCH_CLOSEBRACE.apply((Object)iter.peek())) {
                        iter.next();
                        return;
                    }
                    start = iter.next();
                    continue;
                }
                start = iter.next(CssToken.Matchers.MATCH_SEMI_CLOSEBRACE);
                if (!CssToken.Matchers.MATCH_SEMI.apply((Object)start)) continue;
                start = iter.next();
            }
            catch (NoSuchElementException nse) {
                err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_PREMATURE_EOF, iter.last.location, this.messages.getLocale(), "';' " + this.messages.get("or") + " '}'"));
                throw new CssTokenList.PrematureEOFException();
            }
        }
        return;
    }

    private CssGrammar.CssDeclaration handleDeclaration(CssToken name, CssTokenList.CssTokenIterator iter, CssContentHandler doc, CssErrorHandler err, boolean isStyleAttribute) throws CssExceptions.CssException {
        if (name.type != CssToken.Type.IDENT) {
            err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, name.location, this.messages.getLocale(), name.getChars(), this.messages.get("a_property_name")));
            return null;
        }
        CssGrammar.CssDeclaration declaration = new CssGrammar.CssDeclaration(name.getChars(), name.location);
        try {
            if (!CssToken.Matchers.MATCH_COLON.apply((Object)iter.next())) {
                err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, name.location, this.messages.getLocale(), iter.last.getChars(), ":"));
                return null;
            }
        }
        catch (NoSuchElementException nse) {
            err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_PREMATURE_EOF, iter.last.location, this.messages.getLocale(), ":"));
            throw new CssTokenList.PrematureEOFException();
        }
        try {
            do {
                CssToken value;
                if (CssToken.Matchers.MATCH_SEMI_CLOSEBRACE.apply((Object)(value = iter.next()))) {
                    if (declaration.components.size() < 1 && !((String)declaration.name.or((Object)"")).startsWith("--")) {
                        err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_EXPECTING_TOKEN, iter.last.location, this.messages.getLocale(), Character.valueOf(value.getChar()), this.messages.get("a_property_value")));
                        return null;
                    }
                    return declaration;
                }
                if (this.handlePropertyValue(declaration, value, iter, isStyleAttribute)) continue;
                err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_UNEXPECTED_TOKEN, iter.last.location, this.messages.getLocale(), iter.last.getChars()));
                return null;
            } while (!isStyleAttribute || iter.hasNext());
            return declaration;
        }
        catch (NoSuchElementException nse) {
            err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_PREMATURE_EOF, iter.last.location, this.messages.getLocale(), "';' " + this.messages.get("or") + " '}'"));
            throw new CssTokenList.PrematureEOFException();
        }
    }

    private boolean handlePropertyValue(CssGrammar.CssDeclaration declaration, CssToken start, CssTokenList.CssTokenIterator iter, boolean isStyleAttribute) {
        while (true) {
            if (start.type == CssToken.Type.IMPORTANT) {
                declaration.important = true;
            } else {
                CssGrammar.CssConstruct cc = CssGrammar.CssConstructFactory.create(start, iter, CssToken.Matchers.MATCH_SEMI_CLOSEBRACE, ContextRestrictions.PROPERTY_VALUE);
                if (cc == null) {
                    return false;
                }
                declaration.components.add(cc);
            }
            if (isStyleAttribute && !iter.hasNext() || CssToken.Matchers.MATCH_SEMI.apply((Object)iter.peek()) || !isStyleAttribute && CssToken.Matchers.MATCH_CLOSEBRACE.apply((Object)iter.peek())) {
                return declaration.components.size() > 0;
            }
            start = iter.next();
        }
    }

    private void handleAtRule(CssToken start, CssTokenList.CssTokenIterator iter, CssContentHandler doc, CssErrorHandler err) throws CssExceptions.CssException {
        CssGrammar.CssAtRule atRule = new CssGrammar.CssAtRule(start.getChars(), start.location);
        try {
            while (true) {
                CssToken tk;
                if (CssToken.Matchers.MATCH_SEMI_OPENBRACE.apply((Object)(tk = iter.next()))) {
                    atRule.hasBlock = tk.getChar() == '{';
                    break;
                }
                CssGrammar.CssConstruct param = this.handleAtRuleParam(tk, iter, doc, err);
                if (param == null) {
                    err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_UNEXPECTED_TOKEN, iter.last.location, this.messages.getLocale(), iter.last.chars));
                    int stack = 0;
                    while (true) {
                        CssToken tok;
                        if (CssToken.Matchers.MATCH_SEMI.apply((Object)(tok = iter.next())) && stack == 0) {
                            return;
                        }
                        if (CssToken.Matchers.MATCH_OPENBRACE.apply((Object)tok)) {
                            ++stack;
                            continue;
                        }
                        if (!CssToken.Matchers.MATCH_CLOSEBRACE.apply((Object)tok)) continue;
                        if (stack == 1) break;
                        --stack;
                    }
                    return;
                }
                atRule.components.add(param);
            }
        }
        catch (NoSuchElementException nse) {
            doc.startAtRule(atRule);
            err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_PREMATURE_EOF, iter.last.location, this.messages.getLocale(), "';' " + this.messages.get("or") + " '{'"));
            doc.endAtRule((String)atRule.getName().get());
            throw new CssTokenList.PrematureEOFException();
        }
        doc.startAtRule(atRule);
        if (atRule.hasBlock) {
            try {
                if (this.hasRuleSet(atRule, iter)) {
                    while (!CssToken.Matchers.MATCH_CLOSEBRACE.apply((Object)iter.next())) {
                        if (iter.last.type == CssToken.Type.ATKEYWORD) {
                            this.handleAtRule(iter.last, iter, doc, err);
                            continue;
                        }
                        this.handleRuleSet(iter.last, iter, doc, err);
                    }
                } else {
                    this.handleDeclarationBlock(iter.next(), iter, doc, err);
                }
            }
            catch (NoSuchElementException nse) {
                err.error(new CssExceptions.CssGrammarException(CssExceptions.CssErrorCode.GRAMMAR_PREMATURE_EOF, iter.last.location, this.messages.getLocale(), "'}'"));
                doc.endAtRule((String)atRule.name.get());
                throw new CssTokenList.PrematureEOFException();
            }
        }
        doc.endAtRule((String)atRule.name.get());
    }

    private CssGrammar.CssConstruct handleAtRuleParam(CssToken start, CssTokenList.CssTokenIterator iter, CssContentHandler doc, CssErrorHandler err) {
        return CssGrammar.CssConstructFactory.create(start, iter, CssToken.Matchers.MATCH_SEMI_OPENBRACE, ContextRestrictions.ATRULE_PARAM);
    }

    private boolean hasRuleSet(CssGrammar.CssAtRule atRule, CssTokenList.CssTokenIterator iter) {
        List<CssToken> list = iter.list;
        for (int i = iter.index() + 1; i < list.size(); ++i) {
            CssToken tk = list.get(i);
            if (CssToken.Matchers.MATCH_OPENBRACE.apply((Object)tk)) {
                return true;
            }
            if (!CssToken.Matchers.MATCH_SEMI_CLOSEBRACE.apply((Object)tk)) continue;
            return false;
        }
        return false;
    }

    static final class ContextRestrictions {
        static final Predicate<CssGrammar.CssConstruct> FUNCTION = new Predicate<CssGrammar.CssConstruct>(){

            public boolean apply(CssGrammar.CssConstruct cc) {
                Preconditions.checkNotNull((Object)cc);
                return cc.type != CssGrammar.CssConstruct.Type.ATRULE;
            }
        };
        static final Predicate<CssGrammar.CssConstruct> ATRULE_PARAM = new Predicate<CssGrammar.CssConstruct>(){

            public boolean apply(CssGrammar.CssConstruct cc) {
                Preconditions.checkNotNull((Object)cc);
                return true;
            }
        };
        static final Predicate<CssGrammar.CssConstruct> PROPERTY_VALUE = new Predicate<CssGrammar.CssConstruct>(){

            public boolean apply(CssGrammar.CssConstruct cc) {
                Preconditions.checkNotNull((Object)cc);
                return cc.type != CssGrammar.CssConstruct.Type.ATRULE;
            }
        };
        static final Predicate<CssGrammar.CssConstruct> ATTRIBUTE_SELECTOR_VALUE = new Predicate<CssGrammar.CssConstruct>(){

            public boolean apply(CssGrammar.CssConstruct cc) {
                Preconditions.checkNotNull((Object)cc);
                return cc.type == CssGrammar.CssConstruct.Type.KEYWORD || cc.type == CssGrammar.CssConstruct.Type.STRING;
            }
        };
        static final Predicate<CssGrammar.CssConstruct> PSEUDO_FUNCTIONAL = new Predicate<CssGrammar.CssConstruct>(){

            public boolean apply(CssGrammar.CssConstruct cc) {
                Preconditions.checkNotNull((Object)cc);
                return cc.type == CssGrammar.CssConstruct.Type.KEYWORD || cc.type == CssGrammar.CssConstruct.Type.STRING || cc.type == CssGrammar.CssConstruct.Type.QUANTITY || cc.type == CssGrammar.CssConstruct.Type.SYMBOL && cc.toCssString().equals("+") || cc.type == CssGrammar.CssConstruct.Type.SYMBOL && cc.toCssString().equals("-");
            }
        };

        ContextRestrictions() {
        }
    }
}

