/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.AbstractTabDisplayer;
import org.netbeans.core.multitabs.impl.CloseButtonHandler;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.core.multitabs.impl.TabLayoutManager;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.multitabs.impl.TabTableModel;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.openide.windows.TopComponent;

public class MultiRowTabDisplayer
extends AbstractTabDisplayer
implements ListSelectionListener,
ComplexListDataListener {
    final ArrayList<SingleRowTabTable> rowTables = new ArrayList(10);
    TabLayoutManager layoutManager;
    final JPanel rowPanel;
    CloseButtonHandler closeHandler;
    private final int tabsLocation;
    private boolean ignoreSelectionEvents;

    public MultiRowTabDisplayer(TabDataModel tabModel, int tabsLocation) {
        super(tabModel, tabsLocation);
        this.tabsLocation = tabsLocation;
        this.rowPanel = new RowPanel();
        this.rowPanel.addMouseWheelListener(this);
        this.scrollPane.setViewportView(this.rowPanel);
        this.layoutManager = TabLayoutManager.create(this.rowTables, this.scrollPane, tabModel);
    }

    void initRows() {
        int rowCount = Settings.getDefault().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.addRowTable();
        }
    }

    protected void addRowTable() {
        SingleRowTabTable table = new SingleRowTabTable(this.tabModel);
        table.getSelectionModel().setSelectionInterval(0, 0);
        table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        table.addMouseWheelListener(this);
        table.getSelectionModel().addListSelectionListener(this);
        table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        table.addMouseListener(this.controller);
        table.addMouseListener(this.closeHandler);
        table.addMouseMotionListener(this.closeHandler);
        this.rowTables.add(table);
        if (this.rowTables.size() == 1) {
            table.setBorder(TabTableUI.createTabBorder(table, this.tabsLocation));
        }
        this.rowPanel.add((Component)table, new GridBagConstraints(0, this.rowTables.size() - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Rectangle getTabBounds(int tabIndex) {
        return this.layoutManager.getTabBounds(tabIndex);
    }

    @Override
    public TabData getTabAt(Point p) {
        return this.layoutManager.getTabAt(p);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        TabTable table = this.getTableFrom(e);
        if (null != table) {
            this.changeSelection(table);
        }
    }

    private TabTable getTableFrom(ListSelectionEvent e) {
        Object src = e.getSource();
        for (TabTable tabTable : this.rowTables) {
            if (tabTable.getSelectionModel() != src && tabTable.getColumnModel().getSelectionModel() != src) continue;
            return tabTable;
        }
        return null;
    }

    private void changeSelection(TabTable source) {
        if (this.ignoreSelectionEvents) {
            return;
        }
        this.ignoreSelectionEvents = true;
        int newSelIndex = -1;
        int selRow = source.getSelectedRow();
        int selCol = source.getSelectedColumn();
        if (selRow >= 0 && selCol >= 0) {
            TabData td = (TabData)source.getValueAt(selRow, selCol);
            if (td != null) {
                newSelIndex = this.tabModel.indexOf(td);
                Rectangle rect = source.getCellRect(selRow, selCol, true);
                source.scrollRectToVisible(rect);
                this.controller.setSelectedIndex(newSelIndex);
            }
            for (TabTable tabTable : this.rowTables) {
                if (tabTable == source) continue;
                tabTable.clearSelection();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int selIndex = MultiRowTabDisplayer.this.controller.getSelectedIndex();
                    if (selIndex < 0) {
                        selIndex = 0;
                    }
                    MultiRowTabDisplayer.this.setSelectedIndex(selIndex);
                }
            });
        }
        this.ignoreSelectionEvents = false;
    }

    @Override
    public void setSelectedIndex(int tabIndex) {
        this.ignoreSelectionEvents = true;
        for (SingleRowTabTable table : this.rowTables) {
            if (table.hasTabIndex(tabIndex)) {
                TabTableModel model = (TabTableModel)table.getModel();
                int selRow = model.toRowIndex(tabIndex);
                int selCol = model.toColumnIndex(tabIndex);
                if (selCol < 0 || selRow < 0) continue;
                table.getSelectionModel().setSelectionInterval(selRow, selRow);
                table.getColumnModel().getSelectionModel().setSelectionInterval(selCol, selCol);
                Rectangle rect = table.getCellRect(selRow, selCol, true);
                table.scrollRectToVisible(rect);
                continue;
            }
            table.clearSelection();
        }
        this.ignoreSelectionEvents = false;
    }

    @Override
    public void attach(Controller controller) {
        super.attach(controller);
        this.closeHandler = new CloseButtonHandler(this, controller);
        this.initRows();
    }

    @Override
    public int dropIndexOfPoint(Point location) {
        int res = -1;
        TabData tab = this.getTabAt(location);
        if (null != tab && (res = this.getModel().indexOf(tab)) == this.getModel().size() - 1) {
            Rectangle rect = this.getTabBounds(res);
            if (location.x > rect.x + rect.width / 2) {
                ++res;
            }
        }
        return res;
    }

    @Override
    public Rectangle dropIndication(TopComponent draggedTC, Point location) {
        Rectangle rect;
        int tabIndex = this.dropIndexOfPoint(location);
        if (tabIndex < 0) {
            return null;
        }
        if (tabIndex == this.getModel().size()) {
            --tabIndex;
        }
        if (null != (rect = this.getTabBounds(tabIndex))) {
            rect.x = tabIndex == this.getModel().size() - 1 && location.x > rect.x + rect.width / 2 ? (rect.x += rect.width / 4) : (rect.x -= rect.width / 4);
        }
        return rect;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tabModel.addComplexListDataListener((ComplexListDataListener)this);
        this.layoutManager.doLayout();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.tabModel.removeComplexListDataListener((ComplexListDataListener)this);
    }

    public void indicesAdded(ComplexListDataEvent e) {
        this.layoutManager.invalidate();
    }

    public void indicesRemoved(ComplexListDataEvent e) {
        this.layoutManager.invalidate();
    }

    public void indicesChanged(ComplexListDataEvent e) {
        this.layoutManager.invalidate();
    }

    public void intervalAdded(ListDataEvent e) {
        this.layoutManager.invalidate();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.layoutManager.invalidate();
    }

    public void contentsChanged(ListDataEvent e) {
        this.layoutManager.invalidate();
    }

    private class RowPanel
    extends JPanel
    implements Scrollable {
        public RowPanel() {
            super(new GridBagLayout());
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int res = Integer.MAX_VALUE;
            for (TabTable tabTable : MultiRowTabDisplayer.this.rowTables) {
                if (tabTable.getColumnCount() == 0) continue;
                res = Math.min(Math.abs(tabTable.getScrollableUnitIncrement(visibleRect, orientation, direction)), res);
            }
            return res * direction;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            int res = Integer.MAX_VALUE;
            for (TabTable tabTable : MultiRowTabDisplayer.this.rowTables) {
                if (tabTable.getColumnCount() == 0) continue;
                res = Math.min(Math.abs(tabTable.getScrollableBlockIncrement(visibleRect, orientation, direction)), res);
            }
            return res * direction;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

