/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.anon;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import sun.invoke.anon.AnonymousClassLoader;
import sun.invoke.anon.ConstantPoolPatch;
import sun.invoke.anon.ConstantPoolVisitor;
import sun.invoke.anon.InvalidConstantPoolFormatException;

public class ConstantPoolParser {
    final byte[] classFile;
    final byte[] tags;
    final char[] firstHeader;
    int endOffset;
    char[] secondHeader;
    private char[] charArray = new char[80];

    public ConstantPoolParser(byte[] classFile) throws InvalidConstantPoolFormatException {
        this.classFile = classFile;
        this.firstHeader = ConstantPoolParser.parseHeader(classFile);
        this.tags = new byte[this.firstHeader[4]];
    }

    public ConstantPoolParser(Class<?> templateClass) throws IOException, InvalidConstantPoolFormatException {
        this(AnonymousClassLoader.readClassFile(templateClass));
    }

    public ConstantPoolPatch createPatch() {
        return new ConstantPoolPatch(this);
    }

    public byte getTag(int index) {
        this.getEndOffset();
        return this.tags[index];
    }

    public int getLength() {
        return this.firstHeader[4];
    }

    public int getStartOffset() {
        return this.firstHeader.length * 2;
    }

    public int getEndOffset() {
        if (this.endOffset == 0) {
            throw new IllegalStateException("class file has not yet been parsed");
        }
        return this.endOffset;
    }

    public int getThisClassIndex() {
        this.getEndOffset();
        return this.secondHeader[1];
    }

    public int getTailLength() {
        return this.classFile.length - this.getEndOffset();
    }

    public void writeHead(OutputStream out) throws IOException {
        out.write(this.classFile, 0, this.getEndOffset());
    }

    void writePatchedHead(OutputStream out, Object[] patchArray) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void writeTail(OutputStream out) throws IOException {
        out.write(this.classFile, this.getEndOffset(), this.getTailLength());
    }

    private static char[] parseHeader(byte[] classFile) throws InvalidConstantPoolFormatException {
        char[] result = new char[5];
        ByteBuffer buffer = ByteBuffer.wrap(classFile);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (char)ConstantPoolParser.getUnsignedShort(buffer);
        }
        int magic = result[0] << 16 | result[1] << 0;
        if (magic != -889275714) {
            throw new InvalidConstantPoolFormatException("invalid magic number " + magic);
        }
        char len = result[4];
        if (len < '\u0001') {
            throw new InvalidConstantPoolFormatException("constant pool length < 1");
        }
        return result;
    }

    public void parse(ConstantPoolVisitor visitor) throws InvalidConstantPoolFormatException {
        ByteBuffer buffer = ByteBuffer.wrap(this.classFile);
        buffer.position(this.getStartOffset());
        Object[] values = new Object[this.getLength()];
        try {
            this.parseConstantPool(buffer, values, visitor);
        }
        catch (BufferUnderflowException e) {
            throw new InvalidConstantPoolFormatException(e);
        }
        if (this.endOffset == 0) {
            this.endOffset = buffer.position();
            this.secondHeader = new char[4];
            for (int i = 0; i < this.secondHeader.length; ++i) {
                this.secondHeader[i] = (char)ConstantPoolParser.getUnsignedShort(buffer);
            }
        }
        this.resolveConstantPool(values, visitor);
    }

    private char[] getCharArray(int utfLength) {
        if (utfLength <= this.charArray.length) {
            return this.charArray;
        }
        this.charArray = new char[utfLength];
        return this.charArray;
    }

    private void parseConstantPool(ByteBuffer buffer, Object[] values, ConstantPoolVisitor visitor) throws InvalidConstantPoolFormatException {
        int i = 1;
        block9: while (i < this.tags.length) {
            byte tag = (byte)ConstantPoolParser.getUnsignedByte(buffer);
            assert (this.tags[i] == 0 || this.tags[i] == tag);
            this.tags[i] = tag;
            switch (tag) {
                case 1: {
                    int utfLen = ConstantPoolParser.getUnsignedShort(buffer);
                    String value = ConstantPoolParser.getUTF8(buffer, utfLen, this.getCharArray(utfLen));
                    visitor.visitUTF8(i, (byte)1, value);
                    this.tags[i] = tag;
                    values[i++] = value;
                    continue block9;
                }
                case 3: {
                    visitor.visitConstantValue(i, tag, buffer.getInt());
                    ++i;
                    continue block9;
                }
                case 4: {
                    visitor.visitConstantValue(i, tag, Float.valueOf(buffer.getFloat()));
                    ++i;
                    continue block9;
                }
                case 5: {
                    visitor.visitConstantValue(i, tag, buffer.getLong());
                    i += 2;
                    continue block9;
                }
                case 6: {
                    visitor.visitConstantValue(i, tag, buffer.getDouble());
                    i += 2;
                    continue block9;
                }
                case 7: 
                case 8: {
                    this.tags[i] = tag;
                    values[i++] = new int[]{ConstantPoolParser.getUnsignedShort(buffer)};
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.tags[i] = tag;
                    values[i++] = new int[]{ConstantPoolParser.getUnsignedShort(buffer), ConstantPoolParser.getUnsignedShort(buffer)};
                    continue block9;
                }
            }
            throw new AssertionError((Object)("invalid constant " + tag));
        }
    }

    private void resolveConstantPool(Object[] values, ConstantPoolVisitor visitor) {
        int beg = 1;
        int end = values.length - 1;
        while (beg <= end) {
            int beg2 = end;
            int end2 = beg - 1;
            block7: for (int i = beg; i <= end; ++i) {
                Object value = values[i];
                if (!(value instanceof int[])) continue;
                int[] array = (int[])value;
                byte tag = this.tags[i];
                switch (tag) {
                    case 8: {
                        String stringBody = (String)values[array[0]];
                        visitor.visitConstantString(i, tag, stringBody, array[0]);
                        values[i] = null;
                        continue block7;
                    }
                    case 7: {
                        Object className = (String)values[array[0]];
                        className = ((String)className).replace('/', '.');
                        visitor.visitConstantString(i, tag, (String)className, array[0]);
                        values[i] = className;
                        continue block7;
                    }
                    case 12: {
                        String memberName = (String)values[array[0]];
                        String signature = (String)values[array[1]];
                        visitor.visitDescriptor(i, tag, memberName, signature, array[0], array[1]);
                        values[i] = new String[]{memberName, signature};
                        continue block7;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        Object className = values[array[0]];
                        Object nameAndType = values[array[1]];
                        if (!(className instanceof String) || !(nameAndType instanceof String[])) {
                            if (beg2 > i) {
                                beg2 = i;
                            }
                            if (end2 >= i) continue block7;
                            end2 = i;
                            continue block7;
                        }
                        String[] nameAndTypeArray = (String[])nameAndType;
                        visitor.visitMemberRef(i, tag, (String)className, nameAndTypeArray[0], nameAndTypeArray[1], array[0], array[1]);
                        values[i] = null;
                        continue block7;
                    }
                    default: {
                        continue block7;
                    }
                }
            }
            beg = beg2;
            end = end2;
        }
    }

    private static int getUnsignedByte(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    private static int getUnsignedShort(ByteBuffer buffer) {
        int b1 = ConstantPoolParser.getUnsignedByte(buffer);
        int b2 = ConstantPoolParser.getUnsignedByte(buffer);
        return (b1 << 8) + (b2 << 0);
    }

    private static String getUTF8(ByteBuffer buffer, int utfLen, char[] charArray) throws InvalidConstantPoolFormatException {
        int utfLimit = buffer.position() + utfLen;
        int index = 0;
        while (buffer.position() < utfLimit) {
            int c = buffer.get() & 0xFF;
            if (c > 127) {
                buffer.position(buffer.position() - 1);
                return ConstantPoolParser.getUTF8Extended(buffer, utfLimit, charArray, index);
            }
            charArray[index++] = (char)c;
        }
        return new String(charArray, 0, index);
    }

    private static String getUTF8Extended(ByteBuffer buffer, int utfLimit, char[] charArray, int index) throws InvalidConstantPoolFormatException {
        block5: while (buffer.position() < utfLimit) {
            int c = buffer.get() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    charArray[index++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte c2 = buffer.get();
                    if ((c2 & 0xC0) != 128) {
                        throw new InvalidConstantPoolFormatException("malformed input around byte " + buffer.position());
                    }
                    charArray[index++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte c2 = buffer.get();
                    byte c3 = buffer.get();
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new InvalidConstantPoolFormatException("malformed input around byte " + buffer.position());
                    }
                    charArray[index++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new InvalidConstantPoolFormatException("malformed input around byte " + buffer.position());
        }
        return new String(charArray, 0, index);
    }
}

