/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.net;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.net.TcpServer;
import com.github.kokorin.jaffree.util.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpServer
extends TcpServer {
    private final SeekableByteChannel channel;
    private final byte[] buffer;
    private static final byte[] NEW_LINE = "\r\n".getBytes();
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpServer.class);

    protected FtpServer(ServerSocket controlServerSocket, SeekableByteChannel channel, int bufferSize) {
        super(controlServerSocket);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        this.channel = channel;
        this.buffer = new byte[bufferSize];
    }

    @Override
    protected void serve(Socket controlServerSocket) throws IOException {
        LOGGER.debug("Serving FTP control connection {}", (Object)this.getAddressAndPort());
        try (ServerSocket dataServerSocket = FtpServer.allocateSocket();
             BufferedReader controlReader = new BufferedReader(new InputStreamReader(controlServerSocket.getInputStream()));
             OutputStream controlOutput = controlServerSocket.getOutputStream();){
            this.operate(controlReader, controlOutput, dataServerSocket);
        }
        catch (IOException e) {
            LOGGER.debug("Connection closed: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new JaffreeException("Failed to serve FTP", e);
        }
    }

    protected void operate(BufferedReader controlReader, OutputStream controlOutput, ServerSocket dataServerSocket) throws IOException {
        String line;
        this.doGreet(controlOutput);
        boolean quit = false;
        block28: while (!quit && (line = controlReader.readLine()) != null) {
            LOGGER.debug("Received command: {}", (Object)line);
            String[] commandAndArgs = line.split(" ", 2);
            String command = commandAndArgs[0].toUpperCase();
            String args = null;
            if (commandAndArgs.length == 2) {
                args = commandAndArgs[1];
            }
            switch (command) {
                case "USER": {
                    this.doUser(controlOutput, args);
                    continue block28;
                }
                case "TYPE": {
                    this.doType(controlOutput, args);
                    continue block28;
                }
                case "PWD": {
                    this.doPwd(controlOutput);
                    continue block28;
                }
                case "REST": {
                    this.doRest(controlOutput, args);
                    continue block28;
                }
                case "SIZE": {
                    this.doSize(controlOutput, args);
                    continue block28;
                }
                case "PASV": {
                    this.doPasv(controlOutput, dataServerSocket);
                    continue block28;
                }
                case "RETR": {
                    this.doRetr(controlOutput, dataServerSocket);
                    continue block28;
                }
                case "STOR": {
                    this.doStor(controlOutput, dataServerSocket, args);
                    continue block28;
                }
                case "ABOR": {
                    this.doAbor(controlOutput);
                    continue block28;
                }
                case "FEAT": {
                    this.doFeat(controlOutput);
                    continue block28;
                }
                case "EPSV": {
                    this.doNotImplemented(controlOutput);
                    continue block28;
                }
                case "QUIT": {
                    quit = true;
                    continue block28;
                }
            }
            LOGGER.warn("Command {} not supported", (Object)command);
            this.doNotImplemented(controlOutput);
        }
    }

    protected void doGreet(OutputStream output) throws IOException {
        this.println(output, "220 Service ready for new user.");
    }

    protected void doUser(OutputStream output, String args) throws IOException {
        this.println(output, "230 User logged in, proceed.");
    }

    private void doType(OutputStream output, String args) throws IOException {
        if (!"I".equals(args)) {
            this.println(output, "504 Command not implemented for that parameter.");
            return;
        }
        this.println(output, "200 OK");
    }

    private void doPwd(OutputStream output) throws IOException {
        this.println(output, "257 \"\"");
    }

    private void doRest(OutputStream output, String args) throws IOException {
        Long position = null;
        try {
            position = Long.parseLong(args);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse position: {}", (Object)args);
        }
        if (position == null) {
            this.println(output, "450 Requested file action not taken.");
            return;
        }
        this.channel.position(position);
        this.println(output, "350 Requested file action pending further information.");
    }

    private void doSize(OutputStream output, String args) throws IOException {
        long size = this.channel.size();
        this.println(output, "213 " + size);
    }

    private void doPasv(OutputStream output, ServerSocket dataServerSocket) throws IOException {
        String address = dataServerSocket.getInetAddress().getHostAddress().replaceAll("\\.", ",");
        int port = dataServerSocket.getLocalPort();
        int portHi = port >> 8;
        int portLow = port & 0xFF;
        this.println(output, "227 Entering Passive Mode (" + address + "," + portHi + "," + portLow + ").");
        this.channel.position(0L);
    }

    private void doRetr(OutputStream output, ServerSocket dataServerSocket) throws IOException {
        this.println(output, "150 File status okay; about to open data connection.");
        try (Socket dataSocket = dataServerSocket.accept();
             OutputStream dataOutput = dataSocket.getOutputStream();){
            LOGGER.debug("Data connection established, position: {} socket: {}", (Object)this.channel.position(), (Object)dataSocket);
            long copied = IOUtil.copy(Channels.newInputStream(this.channel), dataOutput, this.buffer);
            LOGGER.debug("Copied {} bytes to data socket", (Object)copied);
            dataOutput.flush();
            this.println(output, "226 Operation successful");
        }
        catch (SocketException e) {
            LOGGER.debug("Data connection error ignored (RETR): {}", (Object)e.getMessage());
            this.println(output, "426 TCP connection broken");
        }
    }

    private void doStor(OutputStream output, ServerSocket dataServerSocket, String path) throws IOException {
        this.println(output, "150 File status okay; about to open data connection.");
        try (Socket dataSocket = dataServerSocket.accept();
             InputStream dataInput = dataSocket.getInputStream();){
            LOGGER.debug("Data connection established, position: {} socket: {}", (Object)this.channel.position(), (Object)dataSocket);
            long copied = IOUtil.copy(dataInput, Channels.newOutputStream(this.channel), this.buffer);
            LOGGER.debug("Copied {} bytes from data socket", (Object)copied);
            this.println(output, "226 Operation successful");
        }
        catch (SocketException e) {
            LOGGER.info("Data connection error ignored (STOR): {}", (Object)e.getMessage());
            this.println(output, "426 TCP connection broken");
        }
    }

    private void doAbor(OutputStream output) throws IOException {
        this.println(output, "226 Closing data connection.");
    }

    private void doFeat(OutputStream output) throws IOException {
        this.println(output, "211 No features.");
    }

    protected void doNotImplemented(OutputStream output) throws IOException {
        this.println(output, "502 Command not implemented.");
    }

    private void println(OutputStream output, String line) throws IOException {
        LOGGER.debug("Responding: {}", (Object)line);
        output.write(line.getBytes());
        output.write(NEW_LINE);
        output.flush();
    }

    public static FtpServer onRandomPorts(SeekableByteChannel channel) {
        return FtpServer.onRandomPorts(channel, 1000000);
    }

    public static FtpServer onRandomPorts(SeekableByteChannel channel, int bufferSize) {
        return new FtpServer(FtpServer.allocateSocket(), channel, bufferSize);
    }
}

