/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Year;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiParameter;

public class JavaAPIGenerator
extends AbstractAPIGenerator {
    private static final String TARGET_PACKAGE = "org/zaproxy/clientapi/gen";
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-java/subprojects/zap-clientapi/src/main/java/org/zaproxy/clientapi/gen";
    private static final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright " + Year.now() + " the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public JavaAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public JavaAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public JavaAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    @Deprecated
    public void generateJavaFiles(List<ApiImplementor> implementors) throws IOException {
        this.generateAPIFiles(implementors);
    }

    private void generateJavaElement(ApiElement element, String component, String type, Writer out) throws IOException {
        String name;
        block23: {
            String descTag = element.getDescriptionTag();
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("\t/**\n");
                out.write("\t * " + desc + "\n");
                if (this.isOptional()) {
                    out.write("\t * <p>\n");
                    out.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                if (element.isDeprecated()) {
                    out.write("\t * @deprecated");
                    String deprecationDesc = element.getDeprecatedDescription();
                    if (deprecationDesc != null && !deprecationDesc.isEmpty()) {
                        out.write(" " + deprecationDesc);
                    }
                    out.write("\n");
                }
                out.write("\t */\n");
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block23;
                out.write("\t/**\n");
                out.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                out.write("\t */\n");
            }
        }
        if (element.isDeprecated()) {
            out.write("\t@Deprecated\n");
        }
        if (type.equals("other")) {
            out.write("\tpublic byte[] " + JavaAPIGenerator.createMethodName(element.getName()) + "(");
        } else {
            out.write("\tpublic ApiResponse " + JavaAPIGenerator.createMethodName(element.getName()) + "(");
        }
        boolean hasParams = false;
        for (ApiParameter parameter : element.getParameters()) {
            if (!hasParams) {
                hasParams = true;
            } else {
                out.write(", ");
            }
            name = parameter.getName();
            if (name.equalsIgnoreCase("boolean")) {
                out.write("boolean bool");
                continue;
            }
            if (name.equalsIgnoreCase("integer")) {
                out.write("int i");
                continue;
            }
            out.write("String " + name.toLowerCase(Locale.ROOT));
        }
        out.write(") throws ClientApiException {\n");
        if (hasParams) {
            out.write("\t\tMap<String, String> map = new HashMap<>();\n");
            for (ApiParameter parameter : element.getParameters()) {
                name = parameter.getName();
                if (!parameter.isRequired()) {
                    out.write("\t\tif (");
                    out.write(name.toLowerCase(Locale.ROOT));
                    out.write(" != null) {\n\t");
                }
                out.write("\t\tmap.put(\"" + name + "\", ");
                if (name.equalsIgnoreCase("boolean")) {
                    out.write("Boolean.toString(bool)");
                } else if (name.equalsIgnoreCase("integer")) {
                    out.write("Integer.toString(i)");
                } else {
                    out.write(name.toLowerCase(Locale.ROOT));
                }
                out.write(");\n");
                if (parameter.isRequired()) continue;
                out.write("\t\t}\n");
            }
        }
        out.write("\t\treturn api.callApi");
        if (type.equals("other")) {
            out.write("Other");
        }
        out.write("(\"" + component + "\", \"" + type + "\", \"" + element.getName() + "\"");
        if (hasParams) {
            out.write(", map);\n");
        } else {
            out.write(", null);\n");
        }
        out.write("\t}\n\n");
    }

    private static String createMethodName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return JavaAPIGenerator.removeAllFullStopCharacters(name);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = imp.getPrefix().substring(0, 1).toUpperCase() + imp.getPrefix().substring(1);
        Path file = this.getDirectory().resolve(className + ".java");
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(HEADER);
            out.write("package org.zaproxy.clientapi.gen;\n\n");
            out.write("import java.util.HashMap;\n");
            out.write("import java.util.Map;\n");
            out.write("import org.zaproxy.clientapi.core.ApiResponse;\n");
            out.write("import org.zaproxy.clientapi.core.ClientApi;\n");
            out.write("import org.zaproxy.clientapi.core.ClientApiException;\n");
            out.write("\n");
            out.write("\n");
            out.write("/**\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" */\n");
            out.write("@SuppressWarnings(\"javadoc\")\n");
            out.write("public class " + className);
            boolean extendsClass = false;
            if (Files.exists(file.resolveSibling(Paths.get("deprecated", className + "Deprecated.java")), new LinkOption[0])) {
                out.write(" extends org.zaproxy.clientapi.gen.deprecated." + className + "Deprecated");
                extendsClass = true;
            }
            out.write(" {\n\n");
            out.write("\tprivate final ClientApi api;\n\n");
            out.write("\tpublic " + className + "(ClientApi api) {\n");
            if (extendsClass) {
                out.write("\t\tsuper(api);\n");
            }
            out.write("\t\tthis.api = api;\n");
            out.write("\t}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateJavaElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateJavaElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateJavaElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("}\n");
        }
    }

    public static void main(String[] args) throws Exception {
        if (!Files.exists(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]), new LinkOption[0])) {
            System.err.println("The directory does not exist: " + Paths.get(DEFAULT_OUTPUT_DIR, new String[0]).toAbsolutePath());
            System.exit(1);
        }
        JavaAPIGenerator wapi = new JavaAPIGenerator();
        wapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

