/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.option;

import java.net.PasswordAuthentication;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.ConnectionParam;
import org.zaproxy.zap.network.SocksProxy;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;

public class SocksProxyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox useSocksCheckBox;
    private final ZapTextField hostTextField;
    private final ZapPortNumberSpinner portNumberSpinner;
    private final JRadioButton version4RadioButton;
    private final JRadioButton version5RadioButton;
    private final JCheckBox useSocksDnsCheckBox;
    private final ZapTextField usernameTextField;
    private final JPasswordField passwordField;

    public SocksProxyPanel() {
        this.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.socks.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        this.hostTextField = new ZapTextField();
        this.hostTextField.setText(ConnectionParam.DEFAULT_SOCKS_PROXY.getHost());
        JLabel hostLabel = new JLabel(Constant.messages.getString("conn.options.socks.host"));
        hostLabel.setLabelFor(this.hostTextField);
        this.portNumberSpinner = new ZapPortNumberSpinner(ConnectionParam.DEFAULT_SOCKS_PROXY.getPort());
        JLabel portLabel = new JLabel(Constant.messages.getString("conn.options.socks.port"));
        portLabel.setLabelFor(this.portNumberSpinner);
        JLabel versionLabel = new JLabel(Constant.messages.getString("conn.options.socks.version"));
        this.version4RadioButton = new JRadioButton("4a");
        this.version5RadioButton = new JRadioButton("5");
        ButtonGroup versionButtonGroup = new ButtonGroup();
        versionButtonGroup.add(this.version4RadioButton);
        versionButtonGroup.add(this.version5RadioButton);
        this.version4RadioButton.setSelected(true);
        this.useSocksDnsCheckBox = new JCheckBox(Constant.messages.getString("conn.options.socks.dns"));
        this.useSocksDnsCheckBox.setToolTipText(Constant.messages.getString("conn.options.socks.dns.tooltip"));
        this.useSocksDnsCheckBox.setSelected(true);
        this.usernameTextField = new ZapTextField();
        JLabel usernameLabel = new JLabel(Constant.messages.getString("conn.options.socks.username"));
        usernameLabel.setLabelFor(this.usernameTextField);
        this.passwordField = new JPasswordField();
        JLabel passwordLabel = new JLabel(Constant.messages.getString("conn.options.socks.password"));
        passwordLabel.setLabelFor(this.passwordField);
        this.useSocksCheckBox = new JCheckBox(Constant.messages.getString("conn.options.socks.enabled"), true);
        this.useSocksCheckBox.addItemListener(e -> {
            boolean state = e.getStateChange() == 1;
            this.hostTextField.setEnabled(state);
            this.portNumberSpinner.setEnabled(state);
            this.version4RadioButton.setEnabled(state);
            this.version5RadioButton.setEnabled(state);
            this.useSocksDnsCheckBox.setEnabled(state && this.version5RadioButton.isSelected());
            this.usernameTextField.setEnabled(state);
            this.passwordField.setEnabled(state);
        });
        this.useSocksCheckBox.setSelected(false);
        this.version5RadioButton.addItemListener(e -> this.useSocksDnsCheckBox.setEnabled(e.getStateChange() == 1 && this.useSocksCheckBox.isSelected()));
        this.setSelectedVersion(ConnectionParam.DEFAULT_SOCKS_PROXY.getVersion());
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.useSocksCheckBox).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(hostLabel).addComponent(portLabel).addComponent(versionLabel).addComponent(usernameLabel).addComponent(passwordLabel)).addGroup(layout.createParallelGroup().addComponent(this.hostTextField).addComponent(this.portNumberSpinner).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.version4RadioButton).addComponent(this.version5RadioButton)).addComponent(this.useSocksDnsCheckBox)).addComponent(this.usernameTextField).addComponent(this.passwordField))));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.useSocksCheckBox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(hostLabel).addComponent(this.hostTextField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(portLabel).addComponent(this.portNumberSpinner)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(versionLabel).addComponent(this.version4RadioButton).addComponent(this.version5RadioButton)).addComponent(this.useSocksDnsCheckBox).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(usernameLabel).addComponent(this.usernameTextField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(passwordLabel).addComponent(this.passwordField)));
    }

    private void setSelectedVersion(SocksProxy.Version version) {
        switch (version) {
            case SOCKS4a: {
                this.version4RadioButton.setSelected(true);
                break;
            }
            default: {
                this.version5RadioButton.setSelected(true);
            }
        }
    }

    private SocksProxy.Version getSelectedVersion() {
        if (this.version4RadioButton.isSelected()) {
            return SocksProxy.Version.SOCKS4a;
        }
        return SocksProxy.Version.SOCKS5;
    }

    public void initParam(ConnectionParam options) {
        this.useSocksCheckBox.setSelected(options.isUseSocksProxy());
        SocksProxy socksProxy = options.getSocksProxy();
        this.hostTextField.setText(socksProxy.getHost());
        this.hostTextField.discardAllEdits();
        this.portNumberSpinner.setValue(socksProxy.getPort());
        this.setSelectedVersion(socksProxy.getVersion());
        this.useSocksDnsCheckBox.setSelected(socksProxy.isUseDns());
        PasswordAuthentication passwordAuthentication = options.getSocksProxyPasswordAuth();
        this.usernameTextField.setText(passwordAuthentication.getUserName());
        this.usernameTextField.discardAllEdits();
        this.passwordField.setText(new String(passwordAuthentication.getPassword()));
    }

    public void validateParam() throws Exception {
        if (this.hostTextField.getText().isEmpty()) {
            this.hostTextField.requestFocus();
            throw new Exception(Constant.messages.getString("conn.options.socks.host.empty"));
        }
    }

    public void saveParam(ConnectionParam options) {
        options.setUseSocksProxy(this.useSocksCheckBox.isSelected());
        SocksProxy oldSocksProxy = options.getSocksProxy();
        if (!oldSocksProxy.getHost().equals(this.hostTextField.getText()) || oldSocksProxy.getPort() != this.portNumberSpinner.getValue().intValue() || oldSocksProxy.getVersion() != this.getSelectedVersion() || oldSocksProxy.isUseDns() != this.useSocksDnsCheckBox.isSelected()) {
            options.setSocksProxy(new SocksProxy(this.hostTextField.getText(), this.portNumberSpinner.getValue(), this.getSelectedVersion(), this.useSocksDnsCheckBox.isSelected()));
        }
        PasswordAuthentication passwordAuthentication = options.getSocksProxyPasswordAuth();
        char[] password = this.passwordField.getPassword();
        if (!passwordAuthentication.getUserName().equals(this.usernameTextField.getText()) || !Arrays.equals(passwordAuthentication.getPassword(), password)) {
            options.setSocksProxyPasswordAuth(new PasswordAuthentication(this.usernameTextField.getText(), password));
        }
    }
}

