﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/finspace/Finspace_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace finspace {
namespace Model {

/**
 * <p>A structure that stores metadata for a kdb user.</p><p><h3>See Also:</h3>
 * <a href="http://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/KxUser">AWS
 * API Reference</a></p>
 */
class KxUser {
 public:
  AWS_FINSPACE_API KxUser() = default;
  AWS_FINSPACE_API KxUser(Aws::Utils::Json::JsonView jsonValue);
  AWS_FINSPACE_API KxUser& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FINSPACE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) that identifies the user. For more
   * information about ARNs and how to use ARNs in policies, see <a
   * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
   * Identifiers</a> in the <i>IAM User Guide</i>. </p>
   */
  inline const Aws::String& GetUserArn() const { return m_userArn; }
  inline bool UserArnHasBeenSet() const { return m_userArnHasBeenSet; }
  template <typename UserArnT = Aws::String>
  void SetUserArn(UserArnT&& value) {
    m_userArnHasBeenSet = true;
    m_userArn = std::forward<UserArnT>(value);
  }
  template <typename UserArnT = Aws::String>
  KxUser& WithUserArn(UserArnT&& value) {
    SetUserArn(std::forward<UserArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for the user.</p>
   */
  inline const Aws::String& GetUserName() const { return m_userName; }
  inline bool UserNameHasBeenSet() const { return m_userNameHasBeenSet; }
  template <typename UserNameT = Aws::String>
  void SetUserName(UserNameT&& value) {
    m_userNameHasBeenSet = true;
    m_userName = std::forward<UserNameT>(value);
  }
  template <typename UserNameT = Aws::String>
  KxUser& WithUserName(UserNameT&& value) {
    SetUserName(std::forward<UserNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IAM role ARN that is associated with the user.</p>
   */
  inline const Aws::String& GetIamRole() const { return m_iamRole; }
  inline bool IamRoleHasBeenSet() const { return m_iamRoleHasBeenSet; }
  template <typename IamRoleT = Aws::String>
  void SetIamRole(IamRoleT&& value) {
    m_iamRoleHasBeenSet = true;
    m_iamRole = std::forward<IamRoleT>(value);
  }
  template <typename IamRoleT = Aws::String>
  KxUser& WithIamRole(IamRoleT&& value) {
    SetIamRole(std::forward<IamRoleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp at which the kdb user was created. </p>
   */
  inline const Aws::Utils::DateTime& GetCreateTimestamp() const { return m_createTimestamp; }
  inline bool CreateTimestampHasBeenSet() const { return m_createTimestampHasBeenSet; }
  template <typename CreateTimestampT = Aws::Utils::DateTime>
  void SetCreateTimestamp(CreateTimestampT&& value) {
    m_createTimestampHasBeenSet = true;
    m_createTimestamp = std::forward<CreateTimestampT>(value);
  }
  template <typename CreateTimestampT = Aws::Utils::DateTime>
  KxUser& WithCreateTimestamp(CreateTimestampT&& value) {
    SetCreateTimestamp(std::forward<CreateTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp at which the kdb user was updated. </p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTimestamp() const { return m_updateTimestamp; }
  inline bool UpdateTimestampHasBeenSet() const { return m_updateTimestampHasBeenSet; }
  template <typename UpdateTimestampT = Aws::Utils::DateTime>
  void SetUpdateTimestamp(UpdateTimestampT&& value) {
    m_updateTimestampHasBeenSet = true;
    m_updateTimestamp = std::forward<UpdateTimestampT>(value);
  }
  template <typename UpdateTimestampT = Aws::Utils::DateTime>
  KxUser& WithUpdateTimestamp(UpdateTimestampT&& value) {
    SetUpdateTimestamp(std::forward<UpdateTimestampT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_userArn;

  Aws::String m_userName;

  Aws::String m_iamRole;

  Aws::Utils::DateTime m_createTimestamp{};

  Aws::Utils::DateTime m_updateTimestamp{};
  bool m_userArnHasBeenSet = false;
  bool m_userNameHasBeenSet = false;
  bool m_iamRoleHasBeenSet = false;
  bool m_createTimestampHasBeenSet = false;
  bool m_updateTimestampHasBeenSet = false;
};

}  // namespace Model
}  // namespace finspace
}  // namespace Aws
