/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import javax.annotation.Nonnull;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.util.Preconditions;

public class BuilderInstruction21ih
extends BuilderInstruction
implements Instruction21ih {
    public static final Format FORMAT = Format.Format21ih;
    protected final int registerA;
    protected final int literal;

    public BuilderInstruction21ih(@Nonnull Opcode opcode, int registerA, int literal) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(registerA);
        this.literal = Preconditions.checkIntegerHatLiteral(literal);
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getNarrowLiteral() {
        return this.literal;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public short getHatLiteral() {
        return (short)(this.literal >>> 16);
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

