/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RangeMappedByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import java.io.IOException;

public class Ext4BlockMapHelper {
    private static final int INDIRECT_BLOCK_INDEX = 12;
    private static final int DOUBLE_INDIRECT_BLOCK_INDEX = 13;
    private static final int TRIPLE_INDIRECT_BLOCK_INDEX = 14;
    private static final int INODE_BLOCKMAP_COUNT = 15;

    public static ByteProvider getByteProvider(byte[] rawIBlockBytes, ByteProvider provider, long expectedLength, int blockSize, FSRL fsrl) throws IOException {
        BinaryReader iBlockReader = new BinaryReader((ByteProvider)new ByteArrayProvider(rawIBlockBytes), true);
        int[] blockNumbers = iBlockReader.readNextIntArray(15);
        RangeMappedByteProvider bp = new RangeMappedByteProvider(provider, fsrl);
        Ext4BlockMapHelper.addFromArray(blockNumbers, 0, 12, 0, bp, blockSize, expectedLength, provider);
        Ext4BlockMapHelper.addFromArray(blockNumbers, 12, 13, 1, bp, blockSize, expectedLength, provider);
        Ext4BlockMapHelper.addFromArray(blockNumbers, 13, 14, 2, bp, blockSize, expectedLength, provider);
        Ext4BlockMapHelper.addFromArray(blockNumbers, 14, 15, 3, bp, blockSize, expectedLength, provider);
        return bp;
    }

    private static void addFromArray(int[] blockNums, int start, int end, int indirectLevel, RangeMappedByteProvider ebp, int blockSize, long expectedLength, ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, true);
        for (int i = start; i < end && ebp.length() < expectedLength; ++i) {
            if (indirectLevel > 0) {
                int[] subBlockNumbers = reader.readIntArray((long)(blockNums[i] * blockSize), blockSize / 4);
                Ext4BlockMapHelper.addFromArray(subBlockNumbers, 0, subBlockNumbers.length, indirectLevel - 1, ebp, blockSize, expectedLength, provider);
                continue;
            }
            int bytesFromBlock = (int)Math.min((long)blockSize, expectedLength - ebp.length());
            long blockNum = Integer.toUnsignedLong(blockNums[i]);
            ebp.addRange(blockNum == 0L ? -1L : blockNum * (long)blockSize, (long)bytesFromBlock);
        }
    }
}

