/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import generic.jar.ResourceFile;
import ghidra.program.model.lang.BasicLanguageDescription;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Processor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SleighLanguageDescription
extends BasicLanguageDescription {
    private ResourceFile defsFile;
    private ResourceFile specFile = null;
    private ResourceFile slaFile = null;
    private ResourceFile manualIndexFile = null;
    private Map<String, Integer> truncatedSpaceMap;

    public SleighLanguageDescription(LanguageID id, String description, Processor processor, Endian endian, Endian instructionEndian, int size, String variant, int version, int minorVersion, boolean deprecated, Map<String, Integer> spaceTruncations, List<CompilerSpecDescription> compilerSpecDescriptions, Map<String, List<String>> externalNames) {
        super(id, processor, endian, instructionEndian, size, variant, description, version, minorVersion, deprecated, compilerSpecDescriptions, externalNames);
        this.truncatedSpaceMap = spaceTruncations;
    }

    public Set<String> getTruncatedSpaceNames() {
        if (this.truncatedSpaceMap == null) {
            return Collections.EMPTY_SET;
        }
        return this.truncatedSpaceMap.keySet();
    }

    public int getTruncatedSpaceSize(String spaceName) throws NoSuchElementException {
        if (this.truncatedSpaceMap == null) {
            throw new NoSuchElementException();
        }
        return this.truncatedSpaceMap.get(spaceName);
    }

    public void setDefsFile(ResourceFile defsFile) {
        this.defsFile = defsFile;
    }

    public ResourceFile getDefsFile() {
        return this.defsFile;
    }

    public void setSpecFile(ResourceFile specFile) {
        this.specFile = specFile;
    }

    public ResourceFile getSpecFile() {
        return this.specFile;
    }

    public void setSlaFile(ResourceFile slaFile) {
        this.slaFile = slaFile;
    }

    public ResourceFile getSlaFile() {
        return this.slaFile;
    }

    public ResourceFile getManualIndexFile() {
        return this.manualIndexFile;
    }

    public void setManualIndexFile(ResourceFile manualIndexFile) {
        this.manualIndexFile = manualIndexFile;
    }
}

