/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class JcaTlsDSSSigner
implements TlsSigner {
    protected final JcaTlsCrypto crypto;
    protected final PrivateKey privateKey;
    protected final short algorithmType;
    protected final String algorithmName;

    protected JcaTlsDSSSigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, short s, String string) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
        this.algorithmType = s;
        this.algorithmName = string;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != this.algorithmType) {
            throw new IllegalStateException("Invalid algorithm: " + String.valueOf(signatureAndHashAlgorithm));
        }
        try {
            Signature signature = this.crypto.getHelper().createSignature(this.algorithmName);
            signature.initSign(this.privateKey, this.crypto.getSecureRandom());
            if (signatureAndHashAlgorithm == null) {
                signature.update(byArray, 16, 20);
            } else {
                signature.update(byArray, 0, byArray.length);
            }
            return signature.sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        return null;
    }
}

