/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.Objects;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;

public class ShareGroupAssignmentBuilder {
    private final ShareGroupMember member;
    private int targetAssignmentEpoch;
    private Assignment targetAssignment;

    public ShareGroupAssignmentBuilder(ShareGroupMember member) {
        this.member = Objects.requireNonNull(member);
    }

    public ShareGroupAssignmentBuilder withTargetAssignment(int targetAssignmentEpoch, Assignment targetAssignment) {
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.targetAssignment = Objects.requireNonNull(targetAssignment);
        return this;
    }

    public ShareGroupMember build() {
        if (this.targetAssignmentEpoch != this.member.memberEpoch()) {
            return new ShareGroupMember.Builder(this.member).setState(MemberState.STABLE).setAssignedPartitions(this.targetAssignment.partitions()).updateMemberEpoch(this.targetAssignmentEpoch).build();
        }
        return this.member;
    }
}

