/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.HierarchicalModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementComparator;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CompressedFoldersModelProvider
extends HierarchicalModelProvider {
    private static final CompressedFolderModelProviderDescriptor compressedDescriptor = new CompressedFolderModelProviderDescriptor();

    public CompressedFoldersModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
    }

    public CompressedFoldersModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement modelRoot, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(parentProvider, modelRoot, configuration, set);
    }

    @Override
    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return compressedDescriptor;
    }

    @Override
    public ViewerComparator getViewerComparator() {
        return new SynchronizeModelElementComparator(){

            protected int compareNames(IResource resource1, IResource resource2) {
                if (resource1.getType() == 2 && resource2.getType() == 2) {
                    return this.getComparator().compare(resource1.getProjectRelativePath().toString(), resource2.getProjectRelativePath().toString());
                }
                return super.compareNames(resource1, resource2);
            }
        };
    }

    @Override
    protected IDiffElement[] createModelObjects(ISynchronizeModelElement container) {
        Object resource = null;
        resource = container == this.getModelRoot() ? ResourcesPlugin.getWorkspace().getRoot() : container.getResource();
        if (resource != null) {
            if (resource.getType() == 4) {
                return this.getProjectChildren(container, (IProject)resource);
            }
            if (resource.getType() == 2) {
                return this.getFolderChildren(container, (IResource)resource);
            }
        }
        return super.createModelObjects(container);
    }

    private IDiffElement[] getFolderChildren(ISynchronizeModelElement parent, IResource resource) {
        IResource[] children = this.getSyncInfoTree().members(resource);
        ArrayList<ISynchronizeModelElement> result = new ArrayList<ISynchronizeModelElement>();
        IResource[] iResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child.getType() == 1) {
                result.add(this.createModelObject(parent, child));
            }
            ++n2;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private IDiffElement[] getProjectChildren(ISynchronizeModelElement parent, IProject project) {
        SyncInfo[] outOfSync = this.getSyncInfoTree().getSyncInfos((IResource)project, 2);
        HashSet<ISynchronizeModelElement> result = new HashSet<ISynchronizeModelElement>();
        HashSet<Object> resourcesToShow = new HashSet<Object>();
        SyncInfo[] syncInfoArray = outOfSync;
        int n = outOfSync.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo syncInfo = syncInfoArray[n2];
            IResource local = syncInfo.getLocal();
            if (local.getProjectRelativePath().segmentCount() == 1 && local.getType() == 1) {
                resourcesToShow.add(local);
            } else if (local.getType() == 1) {
                resourcesToShow.add(local.getParent());
            } else if (local.getType() == 2) {
                resourcesToShow.add(local);
            }
            ++n2;
        }
        for (IResource iResource : resourcesToShow) {
            result.add(this.createModelObject(parent, iResource));
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    @Override
    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, IResource resource) {
        if (resource.getType() == 2) {
            SyncInfo info = this.getSyncInfoTree().getSyncInfo(resource);
            SynchronizeModelElement newNode = info != null ? new CompressedFolderDiffNode(parent, info) : new UnchangedCompressedDiffNode(parent, resource);
            this.addToViewer(newNode);
            return newNode;
        }
        return super.createModelObject(parent, resource);
    }

    @Override
    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos;
        SyncInfo[] syncInfoArray = infos = event.getAddedResources();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            this.addResource(info);
            ++n2;
        }
    }

    @Override
    protected void addResource(SyncInfo info) {
        IResource local = info.getLocal();
        ISynchronizeModelElement existingNode = this.getModelObject(local);
        if (existingNode == null) {
            if (local.getType() == 1) {
                ISynchronizeModelElement parentNode = this.getModelObject((IResource)local.getParent());
                if (parentNode == null) {
                    ISynchronizeModelElement projectNode = this.getModelObject((IResource)local.getProject());
                    if (projectNode == null) {
                        projectNode = this.createModelObject(this.getModelRoot(), (IResource)local.getProject());
                    }
                    parentNode = local.getParent().getType() == 4 ? projectNode : this.createModelObject(projectNode, (IResource)local.getParent());
                }
                this.createModelObject(parentNode, local);
            } else {
                ISynchronizeModelElement projectNode = this.getModelObject((IResource)local.getProject());
                if (projectNode == null) {
                    projectNode = this.createModelObject(this.getModelRoot(), (IResource)local.getProject());
                }
                if (local.getProject() != local) {
                    this.createModelObject(projectNode, local);
                }
            }
        } else {
            this.handleChange(existingNode, info);
        }
    }

    @Override
    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] roots = event.getRemovedSubtreeRoots();
        ArrayList<IResource> removedProjects = new ArrayList<IResource>();
        IResource[] iResourceArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 4) {
                this.removeFromViewer(resource);
                removedProjects.add(resource);
            }
            ++n2;
        }
        IResource[] resources = event.getRemovedResources();
        ArrayList<Object> resourcesToRemove = new ArrayList<Object>();
        ArrayList<SyncInfo> resourcesToAdd = new ArrayList<SyncInfo>();
        IResource[] iResourceArray2 = resources;
        int n3 = resources.length;
        int n4 = 0;
        while (n4 < n3) {
            IResource resource = iResourceArray2[n4];
            if (!removedProjects.contains(resource.getProject())) {
                if (resource.getType() == 1) {
                    if (this.isCompressedParentEmpty(resource) && !this.isOutOfSync((IResource)resource.getParent())) {
                        resourcesToRemove.add(resource.getParent());
                    } else {
                        resourcesToRemove.add(resource);
                    }
                } else {
                    resourcesToRemove.add(resource);
                    resourcesToAdd.addAll(Arrays.asList(this.getSyncInfosForFileMembers((IContainer)resource)));
                }
            }
            ++n4;
        }
        if (!resourcesToRemove.isEmpty()) {
            this.removeFromViewer(resourcesToRemove.toArray(new IResource[resourcesToRemove.size()]));
        }
        if (!resourcesToAdd.isEmpty()) {
            this.addResources(resourcesToAdd.toArray(new SyncInfo[resourcesToAdd.size()]));
        }
    }

    @Override
    protected int getLogicalModelDepth(IResource resource) {
        if (resource.getType() == 4) {
            return 2;
        }
        return 1;
    }

    private boolean isCompressedParentEmpty(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() == 8 || parent.getType() == 4) {
            return false;
        }
        return !this.hasFileMembers(parent);
    }

    private boolean hasFileMembers(IContainer parent) {
        IResource[] members;
        IResource[] iResourceArray = members = this.getSyncInfoTree().members((IResource)parent);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private SyncInfo[] getSyncInfosForFileMembers(IContainer parent) {
        IResource[] members;
        ArrayList<SyncInfo> result = new ArrayList<SyncInfo>();
        IResource[] iResourceArray = members = this.getSyncInfoTree().members((IResource)parent);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            SyncInfo info = this.getSyncInfoTree().getSyncInfo(member);
            if (info != null) {
                result.add(info);
            }
            if (member instanceof IContainer) {
                result.addAll(Arrays.asList(this.getSyncInfosForFileMembers((IContainer)member)));
            }
            ++n2;
        }
        return result.toArray(new SyncInfo[result.size()]);
    }

    public class CompressedFolderDiffNode
    extends SyncInfoModelElement {
        public CompressedFolderDiffNode(IDiffContainer parent, SyncInfo info) {
            super(parent, info);
        }

        @Override
        public String getName() {
            IResource resource = this.getResource();
            return resource.getProjectRelativePath().toString();
        }

        @Override
        public ImageDescriptor getImageDescriptor(Object object) {
            return TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.svg");
        }
    }

    public static class CompressedFolderModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_compressedfolders";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getName() {
            return TeamUIMessages.CompressedFoldersModelProvider_0;
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.svg");
        }
    }

    protected class UnchangedCompressedDiffNode
    extends UnchangedResourceModelElement {
        public UnchangedCompressedDiffNode(IDiffContainer parent, IResource resource) {
            super(parent, resource);
        }

        @Override
        public String getName() {
            IResource resource = this.getResource();
            return resource.getProjectRelativePath().toString();
        }

        @Override
        public ImageDescriptor getImageDescriptor(Object object) {
            return TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.svg");
        }
    }
}

