/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.annotations.ModuleTarget;
import firrtl.backends.experimental.smt.UninterpretedModuleAnnotation;
import firrtl.backends.experimental.smt.UninterpretedModuleException;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.ClockType$;
import firrtl.ir.DefModule;
import firrtl.ir.Direction;
import firrtl.ir.ExtModule;
import firrtl.ir.Input$;
import firrtl.ir.Module;
import firrtl.ir.Output$;
import firrtl.ir.Port;
import firrtl.ir.Type;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class UninterpretedModuleAnnotation$
implements Serializable {
    public static final UninterpretedModuleAnnotation$ MODULE$ = new UninterpretedModuleAnnotation$();

    public int $lessinit$greater$default$3() {
        return 0;
    }

    public void checkModule(DefModule m, UninterpretedModuleAnnotation anno) {
        BoxedUnit boxedUnit;
        DefModule defModule = m;
        if (defModule instanceof Module) {
            throw new UninterpretedModuleException(new StringBuilder(63).append("UninterpretedModuleAnnotation can only be used with extmodule! ").append(anno).toString());
        }
        if (defModule instanceof ExtModule) {
            ExtModule extModule = (ExtModule)defModule;
            Seq clockInputs = (Seq)extModule.ports().collect(new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Port, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var3_8;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Direction direction = A1.direction();
                        Type type = A1.tpe();
                        if (Input$.MODULE$.equals(direction) && ClockType$.MODULE$.equals(type)) {
                            String string = A1.name();
                            return var3_8;
                        }
                    }
                    B1 B1 = function1.apply(x1);
                    return var3_8;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Port x1) {
                    Port port = x1;
                    if (port == null) return false;
                    Direction direction = port.direction();
                    Type type = port.tpe();
                    if (!Input$.MODULE$.equals(direction)) return false;
                    if (!ClockType$.MODULE$.equals(type)) return false;
                    return true;
                }
            });
            Seq clockOutput = (Seq)extModule.ports().collect(new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Port, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    void var3_8;
                    A1 A1 = x2;
                    if (A1 != null) {
                        Direction direction = A1.direction();
                        Type type = A1.tpe();
                        if (Output$.MODULE$.equals(direction) && ClockType$.MODULE$.equals(type)) {
                            String string = A1.name();
                            return var3_8;
                        }
                    }
                    B1 B1 = function1.apply(x2);
                    return var3_8;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Port x2) {
                    Port port = x2;
                    if (port == null) return false;
                    Direction direction = port.direction();
                    Type type = port.tpe();
                    if (!Output$.MODULE$.equals(direction)) return false;
                    if (!ClockType$.MODULE$.equals(type)) return false;
                    return true;
                }
            });
            Seq asyncResets = (Seq)extModule.ports().collect(new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Port, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Type type;
                    A1 A1 = x3;
                    Object object = A1 != null && AsyncResetType$.MODULE$.equals(type = A1.tpe()) ? A1.name() : function1.apply(x3);
                    return object;
                }

                public final boolean isDefinedAt(Port x3) {
                    Type type;
                    Port port = x3;
                    boolean bl = port != null && AsyncResetType$.MODULE$.equals(type = port.tpe());
                    return bl;
                }
            });
            if (clockOutput.nonEmpty()) {
                throw new UninterpretedModuleException(new StringBuilder(59).append("We do not support clock outputs for uninterpreted modules! ").append(clockOutput).toString());
            }
            if (asyncResets.nonEmpty()) {
                throw new UninterpretedModuleException(new StringBuilder(61).append("We do not support async reset I/O for uninterpreted modules! ").append(asyncResets).toString());
            }
            if (anno.stateBits() == 0) {
                if (clockInputs.nonEmpty()) {
                    throw new UninterpretedModuleException(new StringBuilder(54).append("A combinatorial module may not have any clock inputs! ").append(clockInputs).toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (clockInputs.size() != 1) {
                    throw new UninterpretedModuleException(new StringBuilder(53).append("A stateful module must have exactly one clock input! ").append(clockInputs).toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(defModule);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public UninterpretedModuleAnnotation apply(ModuleTarget target, String prefix, int stateBits) {
        return new UninterpretedModuleAnnotation(target, prefix, stateBits);
    }

    public int apply$default$3() {
        return 0;
    }

    public Option<Tuple3<ModuleTarget, String, Object>> unapply(UninterpretedModuleAnnotation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<ModuleTarget, String, Integer>>(new Tuple3<ModuleTarget, String, Integer>(x$0.target(), x$0.prefix(), BoxesRunTime.boxToInteger(x$0.stateBits())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UninterpretedModuleAnnotation$.class);
    }

    private UninterpretedModuleAnnotation$() {
    }
}

