/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.problems.internal.rendering.ProblemWriterRegistry;
import org.gradle.problems.internal.rendering.RenderOptions;
import org.gradle.problems.internal.rendering.SelectiveProblemWriter;

public abstract class ProblemWriter {
    private ProblemWriter() {
    }

    public abstract void write(InternalProblem var1, Writer var2);

    public abstract void write(Collection<InternalProblem> var1, Writer var2);

    public static ProblemWriter simple() {
        return new SimpleProblemWriter(ProblemWriterRegistry.INSTANCE, new RenderOptions("Problem found: ", true, true));
    }

    public static ProblemWriter grouping() {
        return new GroupingProblemWriter(ProblemWriterRegistry.INSTANCE, new RenderOptions("", false, false));
    }

    private static class SimpleProblemWriter
    extends ProblemWriter {
        private final ProblemWriterRegistry writerRegistry;
        private final RenderOptions options;

        SimpleProblemWriter(ProblemWriterRegistry writerRegistry, RenderOptions options) {
            this.writerRegistry = writerRegistry;
            this.options = options;
        }

        @Override
        public void write(InternalProblem problem, Writer writer) {
            PrintWriter output = new PrintWriter(writer);
            this.writerRegistry.problemWriterFor(problem.getDefinition().getId()).write(problem, this.options, output);
        }

        @Override
        public void write(Collection<InternalProblem> problems, Writer writer) {
            PrintWriter output = new PrintWriter(writer);
            String sep = "";
            for (InternalProblem problem : problems) {
                output.printf(sep, new Object[0]);
                sep = "%n";
                this.writerRegistry.problemWriterFor(problem.getDefinition().getId()).write(problem, this.options, output);
            }
        }
    }

    private static class GroupingProblemWriter
    extends ProblemWriter {
        private final ProblemWriterRegistry problemWriterRegistry;
        private final RenderOptions options;

        GroupingProblemWriter(ProblemWriterRegistry problemWriterRegistry, RenderOptions options) {
            this.problemWriterRegistry = problemWriterRegistry;
            this.options = options;
        }

        @Override
        public void write(InternalProblem problem, Writer writer) {
            this.write(Collections.singletonList(problem), writer);
        }

        @Override
        public void write(Collection<InternalProblem> problems, Writer writer) {
            this.write(problems, new PrintWriter(writer));
        }

        private void write(Collection<InternalProblem> problems, PrintWriter output) {
            Map<ProblemId, List<InternalProblem>> problemIdListMap = problems.stream().collect(Collectors.groupingBy(internalProblem -> internalProblem.getDefinition().getId()));
            String separator = "";
            for (Map.Entry<ProblemId, List<InternalProblem>> problemIdListEntry : problemIdListMap.entrySet()) {
                this.renderProblemsById(output, problemIdListEntry.getKey(), problemIdListEntry.getValue(), separator);
                separator = "%n";
            }
        }

        private void renderProblemsById(PrintWriter output, ProblemId problemId, List<InternalProblem> problems, String separator) {
            String sep = separator;
            SelectiveProblemWriter renderer = this.problemWriterRegistry.problemWriterFor(problemId);
            for (InternalProblem problem : problems) {
                output.printf(sep, new Object[0]);
                renderer.write(problem, this.options, output);
                sep = "%n";
            }
        }
    }
}

