/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.SystemProperties;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/util/JavaParametersBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mainClassName", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "build", "Lcom/intellij/execution/configurations/JavaParameters;", "getDefaultShortenCommandLineMethod", "Lcom/intellij/execution/ShortenCommandLine;", "rootPath", "withMainClassName", "name", "withSdkFrom", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "kotlin.idea"})
public final class JavaParametersBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private String mainClassName;
    @Nullable
    private Sdk sdk;

    public JavaParametersBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final JavaParameters build() {
        JavaParameters javaParameters;
        JavaParameters $this$build_u24lambda_u240 = javaParameters = new JavaParameters();
        boolean bl = false;
        $this$build_u24lambda_u240.setMainClass(this.mainClassName);
        Sdk sdk2 = this.sdk;
        if (sdk2 == null && (sdk2 = ProjectRootManager.getInstance((Project)this.project).getProjectSdk()) == null) {
            sdk2 = new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome());
        }
        $this$build_u24lambda_u240.setJdk(sdk2);
        Sdk sdk3 = $this$build_u24lambda_u240.getJdk();
        $this$build_u24lambda_u240.setShortenCommandLine(this.getDefaultShortenCommandLineMethod(sdk3 != null ? sdk3.getHomePath() : null), this.project);
        return javaParameters;
    }

    private final ShortenCommandLine getDefaultShortenCommandLineMethod(String rootPath) {
        return rootPath != null && JdkUtil.isModularRuntime((String)rootPath) ? ShortenCommandLine.ARGS_FILE : (JdkUtil.useClasspathJar() ? ShortenCommandLine.MANIFEST : ShortenCommandLine.CLASSPATH_FILE);
    }

    @NotNull
    public final JavaParametersBuilder withMainClassName(@Nullable String name2) {
        this.mainClassName = name2;
        return this;
    }

    @NotNull
    public final JavaParametersBuilder withSdkFrom(@Nullable Module module) {
        if (module == null) {
            return this;
        }
        Sdk sdk2 = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk2 == null) {
            return this;
        }
        Sdk sdk3 = sdk2;
        if (sdk3.getSdkType() instanceof JavaSdkType) {
            this.sdk = sdk3;
        }
        return this;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/util/JavaParametersBuilder$Companion;", "", "<init>", "()V", "getModuleDependencies", "", "", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getModuleDependencies(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            List list2 = OrderEnumerator.orderEntries((Module)module).withoutSdk().recursively().getPathsList().getPathList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPathList(...)");
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

