/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.set;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ArraySupport;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Set"}, include={"Enumerable"})
public class RubySet
extends RubyObject
implements Set {
    RubyHash hash;
    private static final byte[] RECURSIVE_BYTES = new byte[]{46, 46, 46};

    static RubyClass createSetClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        RubyClass Set2 = ((RubyModule)((RubyModule)Define.defineClass(context, "Set", Object2, RubySet::new).reifiedClass(RubySet.class)).include(context, Enumerable)).defineMethods(context, RubySet.class).tap(c -> c.marshalWith(new SetMarshal(c.getMarshal())));
        Access.loadService(context).require("jruby/set.rb");
        return Set2;
    }

    void unmarshal() {
        this.hash = (RubyHash)this.getInstanceVariable("@hash");
    }

    protected RubySet(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    final void allocHash(ThreadContext context) {
        this.setHash(new RubyHash(context.runtime, context.fals));
    }

    final void allocHash(Ruby runtime2) {
        this.setHash(new RubyHash(runtime2, runtime2.getFalse()));
    }

    final void allocHash(ThreadContext context, int size2) {
        this.setHash(new RubyHash(context.runtime, context.fals, size2));
    }

    final void setHash(RubyHash hash2) {
        this.hash = hash2;
        this.setInstanceVariable("@hash", hash2);
    }

    RubySet newSetFast(Ruby runtime2) {
        return RubySet.newSet(runtime2, this.getMetaClass());
    }

    public static RubySet newSet(Ruby runtime2) {
        return RubySet.newSet(runtime2, (RubyClass)runtime2.getClassFromPath("Set"));
    }

    public static RubySet newSet(Ruby runtime2, RubyClass metaclass) {
        RubySet set2 = new RubySet(runtime2, metaclass);
        set2.allocHash(runtime2);
        return set2;
    }

    private static RubySet newSet(ThreadContext context, RubyClass metaClass, RubyArray elements) {
        RubySet set2 = new RubySet(context.runtime, metaClass);
        return set2.initSet(context, elements.toJavaArrayMaybeUnsafe(), 0, elements.size());
    }

    final RubySet initSet(ThreadContext context, IRubyObject[] elements, int off, int len) {
        this.allocHash(context, Math.max(4, len));
        for (int i2 = off; i2 < len; ++i2) {
            this.invokeAdd(context, elements[i2]);
        }
        return this;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static RubySet create(ThreadContext context, IRubyObject self2, IRubyObject ... ary) {
        Ruby runtime2 = context.runtime;
        RubySet set2 = new RubySet(runtime2, (RubyClass)self2);
        return set2.initSet(context, ary, 0, ary.length);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        if (block.isGiven() && context.runtime.isVerbose()) {
            Warn.warning(context, "given block not used");
        }
        this.allocHash(context);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject enume, Block block) {
        if (enume.isNil()) {
            return this.initialize(context, block);
        }
        if (block.isGiven()) {
            return this.initWithEnum(context, enume, block);
        }
        this.allocHash(context);
        return RubySet.sites((ThreadContext)context).merge.call(context, (IRubyObject)this, (IRubyObject)this, enume);
    }

    protected IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        return switch (args2.length) {
            case 0 -> this.initialize(context, block);
            case 1 -> this.initialize(context, args2[0], block);
            default -> throw Error.argumentError(context, args2.length, 1);
        };
    }

    private IRubyObject initWithEnum(ThreadContext context, IRubyObject enume, final Block block) {
        if (enume instanceof RubyArray) {
            RubyArray ary = (RubyArray)enume;
            this.allocHash(context, ary.size());
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                this.invokeAdd(context, block.yield(context, (IRubyObject)ary.eltInternal(i2)));
            }
            return ary;
        }
        if (enume instanceof RubySet) {
            RubySet set2 = (RubySet)enume;
            this.allocHash(context, set2.size());
            for (IRubyObject elem : set2.elementsOrdered()) {
                this.invokeAdd(context, block.yield(context, elem));
            }
            return set2;
        }
        this.allocHash(context);
        return RubySet.doWithEnum(context, enume, new EachBody(context){

            @Override
            IRubyObject yieldImpl(ThreadContext context, IRubyObject val) {
                return RubySet.this.invokeAdd(context, block.yield(context, val));
            }
        });
    }

    private static IRubyObject doWithEnum(ThreadContext context, IRubyObject enume, EachBody blockImpl) {
        JavaSites.SetSites sites = RubySet.sites(context);
        if (sites.respond_to_each_entry.respondsTo(context, enume, enume)) {
            return sites.each_entry.call(context, enume, enume, new Block(blockImpl));
        }
        if (sites.respond_to_each.respondsTo(context, enume, enume)) {
            return sites.each.call(context, enume, enume, new Block(blockImpl));
        }
        throw Error.argumentError(context, "value must be enumerable");
    }

    @Override
    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        if (this.getRuntime().newSymbol("@hash").equals(name2) && value2 instanceof RubyHash) {
            this.setHash((RubyHash)value2);
            return value2;
        }
        return super.instance_variable_set(name2, value2);
    }

    IRubyObject invokeAdd(ThreadContext context, IRubyObject val) {
        return RubySet.sites((ThreadContext)context).add.call(context, (IRubyObject)this, (IRubyObject)this, val);
    }

    @JRubyMethod(frame=true)
    public IRubyObject initialize_dup(ThreadContext context, IRubyObject orig) {
        RubySet.sites((ThreadContext)context).initialize_dup_super.call(context, (IRubyObject)this, (IRubyObject)this, orig);
        this.setHash((RubyHash)((RubySet)orig).hash.dup(context));
        return this;
    }

    @JRubyMethod(frame=true, keywords=true, required=1, optional=1, checkArity=false)
    public IRubyObject initialize_clone(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        RubySet.sites((ThreadContext)context).initialize_clone_super.call(context, (IRubyObject)this, (IRubyObject)this, args2);
        IRubyObject orig = args2[0];
        this.setHash((RubyHash)((RubySet)orig).hash.rbClone(context));
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject freeze(ThreadContext context) {
        RubyHash hash2 = this.hash;
        if (hash2 != null) {
            hash2.freeze(context);
        }
        return super.freeze(context);
    }

    @JRubyMethod(name={"size"}, alias={"length"})
    public IRubyObject length(ThreadContext context) {
        return Convert.asFixnum(context, this.size());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isEmpty());
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear(ThreadContext context) {
        this.modifyCheck(context);
        this.clearImpl(context);
        return this;
    }

    @Deprecated(since="10.0")
    protected void clearImpl() {
        this.clearImpl(this.getCurrentContext());
    }

    protected void clearImpl(ThreadContext context) {
        this.hash.rb_clear(context);
    }

    @JRubyMethod
    public RubySet replace(ThreadContext context, IRubyObject enume) {
        if (enume instanceof RubySet) {
            RubySet enu = (RubySet)enume;
            this.modifyCheck(context);
            this.clearImpl(context);
            this.addImplSet(context, enu);
        } else {
            if (!enume.getMetaClass().hasModuleInHierarchy(Access.enumerableModule(context)) && !enume.respondsTo("each_entry")) {
                throw Error.argumentError(context, "value must be enumerable");
            }
            this.clearImpl(context);
            this.rb_merge(context, enume);
        }
        return this;
    }

    @Override
    @JRubyMethod
    public RubyArray to_a(ThreadContext context) {
        return this.hash.keys(context);
    }

    @JRubyMethod
    public RubySet to_set(ThreadContext context, Block block) {
        if (block.isGiven()) {
            RubySet set2 = new RubySet(context.runtime, this.getMetaClass());
            set2.initialize(context, this, block);
            return set2;
        }
        return this;
    }

    @JRubyMethod(rest=true)
    public RubySet to_set(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] rest;
        if (args2.length == 0) {
            return this.to_set(context, block);
        }
        IRubyObject klass = args2[0];
        RubyClass Set2 = Access.getClass(context, "Set");
        if (klass == Set2 && args2.length == 1 && !block.isGiven()) {
            return this;
        }
        if (klass instanceof RubyClass) {
            rest = ArraySupport.newCopy(args2, 1, args2.length - 1);
        } else {
            klass = Set2;
            rest = args2;
        }
        RubySet set2 = new RubySet(context.runtime, (RubyClass)klass);
        set2.initialize(context, rest, block);
        return set2;
    }

    @JRubyMethod
    public IRubyObject compare_by_identity(ThreadContext context) {
        this.hash.compare_by_identity(context);
        return this;
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return this.hash.compare_by_identity_p(context);
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public RubySet flatten_merge(ThreadContext context, IRubyObject set2) {
        this.flattenMerge(context, set2, new IdentityHashMap());
        return this;
    }

    private void flattenMerge(ThreadContext context, IRubyObject setArg, final IdentityHashMap seen) {
        if (setArg instanceof RubySet) {
            RubySet set2 = (RubySet)setArg;
            for (IRubyObject e : set2.elementsOrdered()) {
                this.addFlattened(context, seen, e);
            }
        } else {
            RubySet.sites((ThreadContext)context).each.call(context, setArg, setArg, new Block(new EachBody(context){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject e) {
                    RubySet.this.addFlattened(context, seen, e);
                    return context.nil;
                }
            }));
        }
    }

    private void addFlattened(ThreadContext context, IdentityHashMap seen, IRubyObject e) {
        if (e instanceof RubySet) {
            if (seen.containsKey(e)) {
                throw Error.argumentError(context, "tried to flatten recursive Set");
            }
            seen.put(e, null);
            this.flattenMerge(context, e, seen);
            seen.remove(e);
        } else {
            this.add(context, e);
        }
    }

    @JRubyMethod
    public RubySet flatten(ThreadContext context) {
        return this.newSetFast(context.runtime).flatten_merge(context, this);
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context) {
        for (IRubyObject e : this.elementsOrdered()) {
            if (!(e instanceof RubySet)) continue;
            return this.replace(context, this.flatten(context));
        }
        return context.nil;
    }

    @JRubyMethod(name={"include?"}, alias={"member?", "==="})
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, this.containsImpl(obj));
    }

    final boolean containsImpl(IRubyObject obj) {
        return this.hash.fastARef(obj) != null;
    }

    private boolean allElementsIncluded(RubySet set2) {
        for (IRubyObject o : set2.elements()) {
            if (this.containsImpl(o)) continue;
            return false;
        }
        return true;
    }

    @JRubyMethod(name={"superset?"}, alias={">="})
    public IRubyObject superset_p(ThreadContext context, IRubyObject setArg) {
        if (!(setArg instanceof RubySet)) {
            throw Error.argumentError(context, "value must be a set");
        }
        RubySet set2 = (RubySet)setArg;
        if (this.getMetaClass().isInstance(set2)) {
            return this.hash.op_ge(context, set2.hash);
        }
        return Convert.asBoolean(context, this.size() >= set2.size() && this.allElementsIncluded(set2));
    }

    @JRubyMethod(name={"proper_superset?"}, alias={">"})
    public IRubyObject proper_superset_p(ThreadContext context, IRubyObject setArg) {
        if (!(setArg instanceof RubySet)) {
            throw Error.argumentError(context, "value must be a set");
        }
        RubySet set2 = (RubySet)setArg;
        if (this.getMetaClass().isInstance(set2)) {
            return this.hash.op_gt(context, set2.hash);
        }
        return Convert.asBoolean(context, this.size() > set2.size() && this.allElementsIncluded(set2));
    }

    @JRubyMethod(name={"subset?"}, alias={"<="})
    public IRubyObject subset_p(ThreadContext context, IRubyObject setArg) {
        if (!(setArg instanceof RubySet)) {
            throw Error.argumentError(context, "value must be a set");
        }
        RubySet set2 = (RubySet)setArg;
        if (this.getMetaClass().isInstance(set2)) {
            return this.hash.op_le(context, set2.hash);
        }
        return Convert.asBoolean(context, this.size() <= set2.size() && this.allElementsIncluded(set2));
    }

    @JRubyMethod(name={"proper_subset?"}, alias={"<"})
    public IRubyObject proper_subset_p(ThreadContext context, IRubyObject setArg) {
        if (!(setArg instanceof RubySet)) {
            throw Error.argumentError(context, "value must be a set");
        }
        RubySet set2 = (RubySet)setArg;
        if (this.getMetaClass().isInstance(set2)) {
            return this.hash.op_lt(context, set2.hash);
        }
        return Convert.asBoolean(context, this.size() < set2.size() && this.allElementsIncluded(set2));
    }

    @JRubyMethod(name={"intersect?"})
    public IRubyObject intersect_p(ThreadContext context, IRubyObject setArg) {
        if (!(setArg instanceof RubySet)) {
            throw Error.argumentError(context, "value must be a set");
        }
        RubySet set2 = (RubySet)setArg;
        return Convert.asBoolean(context, this.intersect(set2));
    }

    public boolean intersect(RubySet set2) {
        if (this.size() < set2.size()) {
            for (IRubyObject o : this.elementsOrdered()) {
                if (!set2.containsImpl(o)) continue;
                return true;
            }
        } else {
            for (IRubyObject o : set2.elementsOrdered()) {
                if (!this.containsImpl(o)) continue;
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(name={"disjoint?"})
    public IRubyObject disjoint_p(ThreadContext context, IRubyObject setArg) {
        if (!(setArg instanceof RubySet)) {
            throw Error.argumentError(context, "value must be a set");
        }
        RubySet set2 = (RubySet)setArg;
        return Convert.asBoolean(context, !this.intersect(set2));
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubySet::size);
        }
        for (IRubyObject elem : this.elementsOrdered()) {
            block.yield(context, elem);
        }
        return this;
    }

    private static IRubyObject size(ThreadContext context, RubySet recv2, IRubyObject[] args2) {
        return Convert.asFixnum(context, recv2.size());
    }

    @JRubyMethod(name={"add"}, alias={"<<"})
    public RubySet add(ThreadContext context, IRubyObject obj) {
        this.modifyCheck(context);
        this.addImpl(context, obj);
        return this;
    }

    @Deprecated(since="10.0")
    protected void addImpl(Ruby runtime2, IRubyObject obj) {
        this.addImpl(runtime2.getCurrentContext(), obj);
    }

    protected void addImpl(ThreadContext context, IRubyObject obj) {
        this.hash.fastASetCheckString(context.runtime, obj, context.tru);
    }

    protected void addImplSet(ThreadContext context, RubySet set2) {
        this.hash.merge_bang(context, new IRubyObject[]{set2.hash}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"add?"})
    public IRubyObject add_p(ThreadContext context, IRubyObject obj) {
        if (this.containsImpl(obj)) {
            return context.nil;
        }
        return this.add(context, obj);
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject obj) {
        this.modifyCheck(context);
        this.deleteImpl(obj);
        return this;
    }

    protected boolean deleteImpl(IRubyObject obj) {
        this.hash.modify();
        return this.hash.fastDelete(obj);
    }

    protected void deleteImplIterator(IRubyObject obj, Iterator it) {
        it.remove();
    }

    @JRubyMethod(name={"delete?"})
    public IRubyObject delete_p(ThreadContext context, IRubyObject obj) {
        if (!this.containsImpl(obj)) {
            return context.nil;
        }
        return this.delete(context, obj);
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "delete_if", RubySet::size);
        }
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (!block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "keep_if", RubySet::size);
        }
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return this;
    }

    @JRubyMethod(name={"collect!"}, alias={"map!"})
    public IRubyObject collect_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "collect!", RubySet::size);
        }
        RubyArray elems = this.to_a(context);
        this.clearImpl(context);
        for (int i2 = 0; i2 < elems.size(); ++i2) {
            this.addImpl(context, block.yield(context, (IRubyObject)elems.eltInternal(i2)));
        }
        return this;
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "reject!", RubySet::size);
        }
        int size2 = this.size();
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (!block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return size2 == this.size() ? context.nil : this;
    }

    @JRubyMethod(name={"select!"}, alias={"filter!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select!", RubySet::size);
        }
        int size2 = this.size();
        Iterator<IRubyObject> it = this.elementsOrdered().iterator();
        while (it.hasNext()) {
            IRubyObject elem = it.next();
            if (block.yield(context, elem).isTrue()) continue;
            this.deleteImplIterator(elem, it);
        }
        return size2 == this.size() ? context.nil : this;
    }

    public RubySet rb_merge(ThreadContext context, IRubyObject enume) {
        return this.rb_merge(context, new IRubyObject[]{enume});
    }

    @JRubyMethod(name={"merge"}, required=1, rest=true)
    public RubySet rb_merge(ThreadContext context, IRubyObject ... args2) {
        for (IRubyObject arg2 : args2) {
            if (arg2 instanceof RubySet) {
                RubySet set2 = (RubySet)arg2;
                this.modifyCheck(context);
                this.addImplSet(context, set2);
                continue;
            }
            if (arg2 instanceof RubyArray) {
                RubyArray ary = (RubyArray)arg2;
                this.modifyCheck(context);
                for (int j = 0; j < ary.size(); ++j) {
                    this.addImpl(context, (IRubyObject)ary.eltInternal(j));
                }
                continue;
            }
            RubySet.doWithEnum(context, arg2, new EachBody(context){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject val) {
                    RubySet.this.addImpl(context, val);
                    return context.nil;
                }
            });
        }
        return this;
    }

    @JRubyMethod(name={"subtract"})
    public IRubyObject subtract(ThreadContext context, IRubyObject enume) {
        if (enume instanceof RubySet) {
            RubySet set2 = (RubySet)enume;
            this.modifyCheck(context);
            for (IRubyObject elem : set2.elementsOrdered()) {
                this.deleteImpl(elem);
            }
        } else if (enume instanceof RubyArray) {
            RubyArray ary = (RubyArray)enume;
            this.modifyCheck(context);
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                this.deleteImpl((IRubyObject)ary.eltInternal(i2));
            }
        } else {
            RubySet.doWithEnum(context, enume, new EachBody(context){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject val) {
                    RubySet.this.deleteImpl(val);
                    return context.nil;
                }
            });
        }
        return this;
    }

    @JRubyMethod(name={"|"}, alias={"+", "union"})
    public IRubyObject op_or(ThreadContext context, IRubyObject enume) {
        return ((RubySet)this.dup()).rb_merge(context, enume);
    }

    @JRubyMethod(name={"-"}, alias={"difference"})
    public IRubyObject op_diff(ThreadContext context, IRubyObject enume) {
        return ((RubySet)this.dup()).subtract(context, enume);
    }

    @JRubyMethod(name={"&"}, alias={"intersection"})
    public IRubyObject op_and(ThreadContext context, IRubyObject enume) {
        final RubySet newSet = new RubySet(context.runtime, this.getMetaClass());
        if (enume instanceof RubySet) {
            RubySet set2 = (RubySet)enume;
            newSet.allocHash(context, set2.size());
            for (IRubyObject obj : set2.elementsOrdered()) {
                if (!this.containsImpl(obj)) continue;
                newSet.addImpl(context, obj);
            }
        } else if (enume instanceof RubyArray) {
            RubyArray ary = (RubyArray)enume;
            newSet.allocHash(context, ary.size());
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                Object obj = ary.eltInternal(i2);
                if (!this.containsImpl((IRubyObject)obj)) continue;
                newSet.addImpl(context, (IRubyObject)obj);
            }
        } else {
            newSet.allocHash(context);
            RubySet.doWithEnum(context, enume, new EachBody(context){

                @Override
                IRubyObject yieldImpl(ThreadContext context, IRubyObject obj) {
                    if (RubySet.this.containsImpl(obj)) {
                        newSet.addImpl(context, obj);
                    }
                    return context.nil;
                }
            });
        }
        return newSet;
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext context, IRubyObject enume) {
        RubySet newSet = new RubySet(context.runtime, Access.getClass(context, "Set"));
        newSet.initialize(context, enume, Block.NULL_BLOCK);
        for (IRubyObject o : this.elementsOrdered()) {
            if (newSet.containsImpl(o)) {
                newSet.deleteImpl(o);
                continue;
            }
            newSet.addImpl(context, o);
        }
        return newSet;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (this.getMetaClass().isInstance(other)) {
            return this.hash.op_equal(context, ((RubySet)other).hash);
        }
        if (other instanceof RubySet) {
            RubySet that = (RubySet)other;
            if (this.size() == that.size()) {
                for (IRubyObject obj : this.elementsOrdered()) {
                    if (that.containsImpl(obj)) continue;
                    return context.fals;
                }
                return context.tru;
            }
        }
        return context.fals;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset(ThreadContext context) {
        this.hash.rehash(context);
        return this;
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        if (other instanceof RubySet) {
            return this.hash.op_eql(context, ((RubySet)other).hash);
        }
        return context.fals;
    }

    @Override
    public boolean eql(IRubyObject otherArg) {
        if (otherArg instanceof RubySet) {
            RubySet set2 = (RubySet)otherArg;
            ThreadContext context = this.getRuntime().getCurrentContext();
            return this.hash.op_eql(context, set2.hash) == context.tru;
        }
        return false;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        RubyHash hash2 = this.hash;
        return hash2 == null ? ((RubyBasicObject)context.nil).hash(context) : hash2.hash(context);
    }

    @JRubyMethod(name={"classify"})
    public IRubyObject classify(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "classify", RubySet::size);
        }
        RubyHash h = new RubyHash(context.runtime, this.size());
        for (IRubyObject i2 : this.elementsOrdered()) {
            IRubyObject key2 = block.yield(context, i2);
            RubySet set2 = (RubySet)h.fastARef(key2);
            if (set2 == null) {
                set2 = this.newSetFast(context.runtime);
                h.fastASet(key2, set2);
            }
            set2.invokeAdd(context, i2);
        }
        return h;
    }

    @JRubyMethod(name={"divide"})
    public IRubyObject divide(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "divide", RubySet::size);
        }
        if (block.getSignature().arityValue() == 2) {
            return this.divideTSort(context, block);
        }
        RubyHash vals = (RubyHash)this.classify(context, block);
        RubySet set2 = new RubySet(context.runtime, Access.getClass(context, "Set"));
        set2.allocHash(context, vals.size());
        for (IRubyObject val : vals.directValues()) {
            set2.invokeAdd(context, val);
        }
        return set2;
    }

    private IRubyObject divideTSort(ThreadContext context, Block block) {
        DivideTSortHash dig2 = DivideTSortHash.newInstance(context);
        for (IRubyObject u : this.elementsOrdered()) {
            RubyArray<?> a = Create.newArray(context);
            dig2.fastASet(u, a);
            for (IRubyObject v : this.elementsOrdered()) {
                IRubyObject ret = block.call(context, u, v);
                if (!ret.isTrue()) continue;
                a.append(context, v);
            }
        }
        final RubyClass Set2 = Access.getClass(context, "Set");
        final RubySet set2 = new RubySet(context.runtime, Set2);
        set2.allocHash(context, dig2.size());
        RubySet.sites((ThreadContext)context).each_strongly_connected_component.call(context, (IRubyObject)this, (IRubyObject)dig2, new Block(new JavaInternalBlockBody(this, context.runtime, Signature.ONE_REQUIRED){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                return this.doYield(context, null, args2[0]);
            }

            @Override
            protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject css) {
                set2.addImpl(context, (IRubyObject)RubySet.newSet(context, Set2, (RubyArray)css));
                return context.nil;
            }
        }));
        return set2;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        int otherSize;
        if (!(other instanceof RubySet)) {
            return context.nil;
        }
        RubySet otherSet = (RubySet)other;
        int size2 = this.size();
        if (size2 < (otherSize = otherSet.size())) {
            if (RubySet.sites((ThreadContext)context).proper_subset.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue()) {
                return RubyFixnum.minus_one(context.runtime);
            }
        } else if (size2 > otherSize) {
            if (RubySet.sites((ThreadContext)context).proper_superset.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue()) {
                return RubyFixnum.one(context.runtime);
            }
        } else if (RubySet.sites((ThreadContext)context).op_equal.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue()) {
            return RubyFixnum.zero(context.runtime);
        }
        return context.nil;
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join(ThreadContext context, IRubyObject sep) {
        return RubySet.sites((ThreadContext)context).ary_join.call(context, (IRubyObject)this, RubySet.sites((ThreadContext)context).to_a.call(context, this, this), sep);
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join(ThreadContext context) {
        return this.join(context, context.nil);
    }

    static RubyModule getTSort(ThreadContext context) {
        if (!Access.objectClass(context).hasConstant("TSort")) {
            Access.loadService(context).require("tsort");
        }
        return Access.getModule(context, "TSort");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"}, alias={"to_s"})
    public RubyString inspect(ThreadContext context) {
        if (this.size() == 0) {
            return this.inspectEmpty(context);
        }
        if (context.runtime.isInspecting(this)) {
            return this.inspectRecurse(context);
        }
        RubyString str = RubyString.newStringLight(context.runtime, 32, USASCIIEncoding.INSTANCE);
        RubySet.inspectPrefix(context, str, this.getMetaClass());
        try {
            context.runtime.registerInspecting(this);
            this.inspectSet(context, str);
            RubyString rubyString = str.cat(62);
            return rubyString;
        }
        finally {
            context.runtime.unregisterInspecting(this);
        }
    }

    private RubyString inspectEmpty(ThreadContext context) {
        RubyString str = RubyString.newStringLight(context.runtime, 16, USASCIIEncoding.INSTANCE);
        RubySet.inspectPrefix(context, str, this.getMetaClass());
        str.cat(123).cat(125).cat(62);
        return str;
    }

    private RubyString inspectRecurse(ThreadContext context) {
        RubyString str = RubyString.newStringLight(context.runtime, 20, USASCIIEncoding.INSTANCE);
        RubySet.inspectPrefix(context, str, this.getMetaClass());
        str.cat(123).cat(RECURSIVE_BYTES).cat(125).cat(62);
        return str;
    }

    private static RubyString inspectPrefix(ThreadContext context, RubyString str, RubyClass metaClass) {
        str.cat(35).cat(60).cat(metaClass.getRealClass().getName(context).getBytes(RubyEncoding.UTF8));
        str.cat(58).cat(32);
        return str;
    }

    private void inspectSet(ThreadContext context, RubyString str) {
        str.cat((byte)123);
        boolean notFirst = false;
        for (IRubyObject elem : this.elementsOrdered()) {
            RubyString s2 = RubySet.inspect(context, elem);
            if (notFirst) {
                str.cat((byte)44).cat((byte)32);
            } else {
                str.setEncoding(s2.getEncoding());
            }
            notFirst = true;
            str.catWithCodeRange(s2);
        }
        str.cat((byte)125);
    }

    protected final Set<IRubyObject> elements() {
        return this.hash.directKeySet();
    }

    protected Set<IRubyObject> elementsOrdered() {
        return this.elements();
    }

    @Deprecated
    protected final void modifyCheck(Ruby runtime2) {
        this.modifyCheck(runtime2.getCurrentContext());
    }

    protected final void modifyCheck(ThreadContext context) {
        if ((this.flags & FROZEN_F) != 0) {
            throw context.runtime.newFrozenError("Set", this);
        }
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    @Override
    public void clear() {
        this.clear(this.getRuntime().getCurrentContext());
    }

    public void clear(ThreadContext context) {
        this.clearImpl(context);
    }

    @Override
    public boolean contains(Object o) {
        return this.containsImpl(this.toRuby(o));
    }

    public Iterator<IRubyObject> rawIterator() {
        return this.elementsOrdered().iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.hash.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array2 = new Object[this.size()];
        int i2 = 0;
        for (IRubyObject elem : this.elementsOrdered()) {
            array2[i2++] = elem.toJava(Object.class);
        }
        return array2;
    }

    @Override
    public Object[] toArray(Object[] ary) {
        Class<?> type2 = ary.getClass().getComponentType();
        Object[] array2 = ary;
        if (array2.length < this.size()) {
            array2 = (Object[])Array.newInstance(type2, this.size());
        }
        int i2 = 0;
        for (IRubyObject elem : this.elementsOrdered()) {
            array2[i2++] = elem.toJava(type2);
        }
        return array2;
    }

    @Override
    public boolean add(Object element) {
        Ruby runtime2 = this.getRuntime();
        int size2 = this.size();
        this.addImpl(runtime2.getCurrentContext(), RubySet.toRuby(runtime2, element));
        return this.size() > size2;
    }

    @Override
    public boolean remove(Object element) {
        return this.deleteImpl(this.toRuby(element));
    }

    @Override
    public boolean containsAll(Collection coll) {
        for (Object elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection coll) {
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        int size2 = this.size();
        for (Object elem : coll) {
            this.addImpl(context, RubySet.toRuby(runtime2, elem));
        }
        return this.size() > size2;
    }

    @Override
    public boolean retainAll(Collection coll) {
        int size2 = this.size();
        Iterator<IRubyObject> iter = this.rawIterator();
        while (iter.hasNext()) {
            IRubyObject elem = iter.next();
            if (coll.contains(elem.toJava(Object.class))) continue;
            this.deleteImplIterator(elem, iter);
        }
        return this.size() < size2;
    }

    @Override
    public boolean removeAll(Collection coll) {
        boolean removed = false;
        for (Object elem : coll) {
            removed = this.remove(elem) | removed;
        }
        return removed;
    }

    static IRubyObject toRuby(Ruby runtime2, Object obj) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, obj);
    }

    final IRubyObject toRuby(Object obj) {
        return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), obj);
    }

    @Override
    @Deprecated
    @JRubyMethod
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    @Deprecated
    @JRubyMethod
    public IRubyObject untaint(ThreadContext context) {
        return this;
    }

    private static JavaSites.SetSites sites(ThreadContext context) {
        return context.sites.Set;
    }

    private static abstract class EachBody
    extends JavaInternalBlockBody {
        EachBody(ThreadContext context) {
            super(context.runtime, Signature.ONE_ARGUMENT);
        }

        @Override
        public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
            return this.yieldImpl(context, args2[0]);
        }

        abstract IRubyObject yieldImpl(ThreadContext var1, IRubyObject var2);

        @Override
        protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
            return this.yieldImpl(context, args2[0]);
        }

        @Override
        protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
            return this.yieldImpl(context, value2);
        }
    }

    public static final class DivideTSortHash
    extends RubyHash {
        private static final String NAME = "DivideTSortHash";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static DivideTSortHash newInstance(ThreadContext context) {
            RubyClass Set2 = Access.getClass(context, "Set");
            RubyClass klass = (RubyClass)Set2.getConstantAt(context, NAME, true);
            if (klass != null) return new DivideTSortHash(context.runtime, klass);
            Class<DivideTSortHash> clazz = DivideTSortHash.class;
            synchronized (DivideTSortHash.class) {
                klass = (RubyClass)Set2.getConstantAt(context, NAME, true);
                if (klass != null) return new DivideTSortHash(context.runtime, klass);
                RubyClass Hash2 = Access.hashClass(context);
                klass = (RubyClass)((RubyModule)((RubyModule)Set2.defineClassUnder(context, NAME, Hash2, Hash2.getAllocator())).include(context, RubySet.getTSort(context))).defineMethods(context, DivideTSortHash.class);
                Set2.setConstantVisibility(context, NAME, true);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new DivideTSortHash(context.runtime, klass);
            }
        }

        DivideTSortHash(Ruby runtime2, RubyClass metaClass) {
            super(runtime2, metaClass);
        }

        @JRubyMethod
        public IRubyObject tsort_each_node(ThreadContext context, Block block) {
            return this.each_key(context, block);
        }

        @JRubyMethod
        public IRubyObject tsort_each_child(ThreadContext context, IRubyObject node, Block block) {
            IRubyObject set2 = this.fetch(context, node, Block.NULL_BLOCK);
            if (set2 instanceof RubySet) {
                return ((RubySet)set2).each(context, block);
            }
            return RubySet.sites((ThreadContext)context).each.call(context, (IRubyObject)this, set2, block);
        }
    }

    private static final class SetMarshal
    implements ObjectMarshal {
        protected final ObjectMarshal defaultMarshal;

        SetMarshal(ObjectMarshal defaultMarshal) {
            this.defaultMarshal = defaultMarshal;
        }

        @Deprecated(since="10.0", forRemoval=true)
        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            this.defaultMarshal.marshalTo(runtime2, obj, type2, marshalStream);
        }

        public void marshalTo(ThreadContext context, RubyOutputStream out, Object obj, RubyClass type2, MarshalDumper marshalStream) {
            this.defaultMarshal.marshalTo(context, out, obj, type2, marshalStream);
        }

        @Deprecated(since="10.0", forRemoval=true)
        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            Object result2 = this.defaultMarshal.unmarshalFrom(runtime2, type2, unmarshalStream);
            ((RubySet)result2).unmarshal();
            return result2;
        }

        public Object unmarshalFrom(ThreadContext context, RubyInputStream in, RubyClass type2, MarshalLoader loader) {
            Object result2 = this.defaultMarshal.unmarshalFrom(context, in, type2, loader);
            ((RubySet)result2).unmarshal();
            return result2;
        }
    }
}

