/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.cli.help.FilterHelpAppendable;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.cli.help.Util;

public class TextHelpAppendable
extends FilterHelpAppendable {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_INDENT = 3;
    public static final int DEFAULT_LIST_INDENT = 7;
    private static final String BLANK_LINE = "";
    private static final Set<Character> BREAK_CHAR_SET = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf('\r'), Character.valueOf('\u000e'), Character.valueOf('\u000b'), Character.valueOf('\u001c'), Character.valueOf('\u001d'), Character.valueOf('\u001e'), Character.valueOf('\u001f'))));
    private final TextStyle.Builder textStyleBuilder = TextStyle.builder().setMaxWidth(74).setLeftPad(1).setIndent(3);

    public static int indexOfWrap(CharSequence text, int width, int startPos) {
        int pos;
        if (width < 1) {
            throw new IllegalArgumentException("Width must be greater than 0");
        }
        int limit = Math.min(startPos + width, text.length());
        for (int idx = startPos; idx < limit; ++idx) {
            if (!BREAK_CHAR_SET.contains(Character.valueOf(text.charAt(idx)))) continue;
            return idx;
        }
        if (startPos + width >= text.length()) {
            return text.length();
        }
        for (pos = limit = Math.min(startPos + width, text.length() - 1); pos >= startPos && !Util.isWhitespace(text.charAt(pos)); --pos) {
        }
        return pos > startPos ? pos : limit - 1;
    }

    protected static TextHelpAppendable systemOut() {
        return new TextHelpAppendable(System.out);
    }

    public TextHelpAppendable(Appendable output) {
        super(output);
    }

    protected TableDefinition adjustTableFormat(TableDefinition table) {
        ArrayList<Object> styleBuilders = new ArrayList<Object>();
        for (int i = 0; i < table.columnTextStyles().size(); ++i) {
            TextStyle style = table.columnTextStyles().get(i);
            TextStyle.Builder builder2 = TextStyle.builder().setTextStyle(style);
            styleBuilders.add(builder2);
            String string = table.headers().get(i);
            if (style.getMaxWidth() < string.length() || style.getMaxWidth() == Integer.MAX_VALUE) {
                builder2.setMaxWidth(string.length());
            }
            if (style.getMinWidth() < string.length()) {
                builder2.setMinWidth(string.length());
            }
            for (List<String> row : table.rows()) {
                String cell = row.get(i);
                if (cell.length() <= builder2.getMaxWidth()) continue;
                builder2.setMaxWidth(cell.length());
            }
        }
        int calcWidth = 0;
        int adjustedMaxWidth = this.textStyleBuilder.getMaxWidth();
        for (TextStyle.Builder builder2 : styleBuilders) {
            adjustedMaxWidth -= builder2.getLeftPad();
            if (builder2.isScalable()) {
                calcWidth += builder2.getMaxWidth();
                continue;
            }
            adjustedMaxWidth -= builder2.getMaxWidth();
        }
        if (calcWidth > adjustedMaxWidth) {
            double fraction = (double)adjustedMaxWidth * 1.0 / (double)calcWidth;
            for (int i = 0; i < styleBuilders.size(); ++i) {
                TextStyle.Builder builder4 = (TextStyle.Builder)styleBuilders.get(i);
                if (!builder4.isScalable()) continue;
                styleBuilders.set(i, this.resize(builder4, fraction));
            }
        }
        ArrayList<TextStyle> styles = new ArrayList<TextStyle>();
        styleBuilders.forEach(builder -> styles.add(builder.get()));
        return TableDefinition.from(table.caption(), styles, table.headers(), table.rows());
    }

    @Override
    public void appendHeader(int level, CharSequence text) throws IOException {
        if (!Util.isEmpty(text)) {
            if (level < 1) {
                throw new IllegalArgumentException("level must be at least 1");
            }
            char[] fillChars = new char[]{'=', '%', '+', '_'};
            int idx = Math.min(level, fillChars.length) - 1;
            TextStyle style = this.textStyleBuilder.get();
            Queue<String> queue = this.makeColumnQueue(text, style);
            queue.add(Util.repeatSpace(style.getLeftPad()) + Util.repeat(Math.min(text.length(), style.getMaxWidth()), fillChars[idx]));
            queue.add(BLANK_LINE);
            this.printQueue(queue);
        }
    }

    @Override
    public void appendList(boolean ordered, Collection<CharSequence> list) throws IOException {
        if (list != null && !list.isEmpty()) {
            TextStyle.Builder builder = TextStyle.builder().setLeftPad(this.textStyleBuilder.getLeftPad()).setIndent(7);
            int i = 1;
            for (CharSequence line : list) {
                String entry = ordered ? String.format(" %s. %s", i++, Util.defaultValue(line, BLANK_LINE)) : String.format(" * %s", Util.defaultValue(line, BLANK_LINE));
                builder.setMaxWidth(Math.min(this.textStyleBuilder.getMaxWidth(), entry.length()));
                this.printQueue(this.makeColumnQueue(entry, builder.get()));
            }
            this.output.append(System.lineSeparator());
        }
    }

    @Override
    public void appendParagraph(CharSequence paragraph) throws IOException {
        if (!Util.isEmpty(paragraph)) {
            Queue<String> queue = this.makeColumnQueue(paragraph, this.textStyleBuilder.get());
            queue.add(BLANK_LINE);
            this.printQueue(queue);
        }
    }

    @Override
    public void appendTable(TableDefinition rawTable) throws IOException {
        TableDefinition table = this.adjustTableFormat(rawTable);
        this.appendParagraph(table.caption());
        ArrayList<TextStyle> headerStyles = new ArrayList<TextStyle>();
        table.columnTextStyles().forEach(style -> headerStyles.add(TextStyle.builder().setTextStyle((TextStyle)style).setAlignment(TextStyle.Alignment.CENTER).get()));
        this.writeColumnQueues(this.makeColumnQueues(table.headers(), headerStyles), headerStyles);
        for (List<String> row : table.rows()) {
            this.writeColumnQueues(this.makeColumnQueues(row, table.columnTextStyles()), table.columnTextStyles());
        }
        this.output.append(System.lineSeparator());
    }

    @Override
    public void appendTitle(CharSequence title) throws IOException {
        if (!Util.isEmpty(title)) {
            TextStyle style = this.textStyleBuilder.get();
            Queue<String> queue = this.makeColumnQueue(title, style);
            queue.add(Util.repeatSpace(style.getLeftPad()) + Util.repeat(Math.min(title.length(), style.getMaxWidth()), '#'));
            queue.add(BLANK_LINE);
            this.printQueue(queue);
        }
    }

    public int getIndent() {
        return this.textStyleBuilder.getIndent();
    }

    public int getLeftPad() {
        return this.textStyleBuilder.getLeftPad();
    }

    public int getMaxWidth() {
        return this.textStyleBuilder.getMaxWidth();
    }

    public TextStyle.Builder getTextStyleBuilder() {
        return this.textStyleBuilder;
    }

    protected Queue<String> makeColumnQueue(CharSequence columnData, TextStyle style) {
        String lpad = Util.repeatSpace(style.getLeftPad());
        String indent = Util.repeatSpace(style.getIndent());
        LinkedList<String> result = new LinkedList<String>();
        int wrapPos = 0;
        int wrappedMaxWidth = style.getMaxWidth() - indent.length();
        while (wrapPos < columnData.length()) {
            int workingWidth = wrapPos == 0 ? style.getMaxWidth() : wrappedMaxWidth;
            int lastPos = TextHelpAppendable.indexOfWrap(columnData, workingWidth, wrapPos);
            CharSequence working = columnData.subSequence(wrapPos, lastPos);
            result.add(lpad + style.pad(wrapPos > 0, working));
            wrapPos = Util.indexOfNonWhitespace(columnData, lastPos);
            wrapPos = wrapPos == -1 ? lastPos + 1 : wrapPos;
        }
        return result;
    }

    protected List<Queue<String>> makeColumnQueues(List<String> columnData, List<TextStyle> styles) {
        ArrayList<Queue<String>> result = new ArrayList<Queue<String>>();
        for (int i = 0; i < columnData.size(); ++i) {
            result.add(this.makeColumnQueue(columnData.get(i), styles.get(i)));
        }
        return result;
    }

    private void printQueue(Queue<String> queue) throws IOException {
        for (String s2 : queue) {
            this.appendFormat("%s%n", Util.rtrim(s2));
        }
    }

    public void printWrapped(String text) throws IOException {
        this.printQueue(this.makeColumnQueue(text, this.textStyleBuilder.get()));
    }

    public void printWrapped(String text, TextStyle style) throws IOException {
        this.printQueue(this.makeColumnQueue(text, style));
    }

    private int resize(int orig, double fraction) {
        return (int)((double)orig * fraction);
    }

    protected TextStyle.Builder resize(TextStyle.Builder builder, double fraction) {
        int newIndent;
        double indentFrac = (double)builder.getIndent() * 1.0 / (double)builder.getMaxWidth();
        builder.setMaxWidth(Math.max(this.resize(builder.getMaxWidth(), fraction), builder.getMinWidth()));
        int maxAdjust = builder.getMaxWidth() / 3;
        int n = newIndent = builder.getMaxWidth() == 1 ? 0 : builder.getIndent();
        if (newIndent > maxAdjust) {
            newIndent = Math.min(this.resize(builder.getIndent(), indentFrac), maxAdjust);
        }
        builder.setIndent(newIndent);
        return builder;
    }

    public void setIndent(int indent) {
        this.textStyleBuilder.setIndent(indent);
    }

    public void setLeftPad(int leftPad) {
        this.textStyleBuilder.setLeftPad(leftPad);
    }

    public void setMaxWidth(int maxWidth) {
        this.textStyleBuilder.setMaxWidth(maxWidth);
    }

    protected void writeColumnQueues(List<Queue<String>> columnQueues, List<TextStyle> styles) throws IOException {
        boolean moreData = true;
        String lPad = Util.repeatSpace(this.textStyleBuilder.get().getLeftPad());
        while (moreData) {
            this.output.append(lPad);
            moreData = false;
            for (int i = 0; i < columnQueues.size(); ++i) {
                TextStyle style = styles.get(i);
                Queue<String> columnQueue = columnQueues.get(i);
                String line = columnQueue.poll();
                if (Util.isEmpty(line)) {
                    this.output.append(Util.repeatSpace(style.getMaxWidth() + style.getLeftPad()));
                } else {
                    this.output.append(line);
                }
                moreData |= !columnQueue.isEmpty();
            }
            this.output.append(System.lineSeparator());
        }
    }
}

