/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputInfo;
import org.tribuo.anomaly.AnomalyFactory;
import org.tribuo.anomaly.Event;
import org.tribuo.anomaly.ImmutableAnomalyInfo;
import org.tribuo.anomaly.MutableAnomalyInfo;

public abstract class AnomalyInfo
implements OutputInfo<Event> {
    private static final long serialVersionUID = 1L;
    private static final Set<Event> DOMAIN = AnomalyInfo.makeDomain();
    protected long expectedCount = 0L;
    protected long anomalyCount = 0L;
    protected int unknownCount = 0;

    protected AnomalyInfo() {
    }

    protected AnomalyInfo(AnomalyInfo other) {
        this.expectedCount = other.expectedCount;
        this.anomalyCount = other.anomalyCount;
        this.unknownCount = other.unknownCount;
    }

    public int getUnknownCount() {
        return this.unknownCount;
    }

    public long getAnomalyCount() {
        return this.anomalyCount;
    }

    public long getExpectedCount() {
        return this.expectedCount;
    }

    public Set<Event> getDomain() {
        return DOMAIN;
    }

    public long getEventCount(Event.EventType type) {
        switch (type) {
            case ANOMALOUS: {
                return this.anomalyCount;
            }
            case EXPECTED: {
                return this.expectedCount;
            }
            case UNKNOWN: {
                return this.unknownCount;
            }
        }
        return 0L;
    }

    public Iterable<Pair<String, Long>> outputCountsIterable() {
        ArrayList<Pair<String, Long>> list = new ArrayList<Pair<String, Long>>();
        list.add(new Pair((Object)Event.EventType.ANOMALOUS.toString(), (Object)this.anomalyCount));
        list.add(new Pair((Object)Event.EventType.EXPECTED.toString(), (Object)this.expectedCount));
        return list;
    }

    public int size() {
        return DOMAIN.size();
    }

    public ImmutableOutputInfo<Event> generateImmutableOutputInfo() {
        return new ImmutableAnomalyInfo(this);
    }

    public MutableOutputInfo<Event> generateMutableOutputInfo() {
        return new MutableAnomalyInfo(this);
    }

    public String toReadableString() {
        return "AnomalyInfo(anomalies=" + this.anomalyCount + ",expected=" + this.expectedCount + ",unknown=" + this.unknownCount + ")";
    }

    public String toString() {
        return this.toReadableString();
    }

    public abstract AnomalyInfo copy();

    private static Set<Event> makeDomain() {
        HashSet<Event> set = new HashSet<Event>();
        set.add(AnomalyFactory.EXPECTED_EVENT);
        set.add(AnomalyFactory.ANOMALOUS_EVENT);
        return Collections.unmodifiableSet(set);
    }
}

