/*
 * Decompiled with CFR 0.152.
 */
package JSON_mUtils_mVectors_Compile;

import BoundedInts_Compile.__default;
import JSON_mUtils_mVectors_Compile.VectorError;
import Wrappers_Compile.Outcome;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.function.Function;

public class Vector<A> {
    protected TypeDescriptor<A> _td_A;
    public int size;
    public int capacity;
    public Object data;
    public A _a;

    public Vector(TypeDescriptor<A> _td_A) {
        this._td_A = _td_A;
        this.size = 0;
        this.capacity = 0;
        this.data = _td_A.newArray(0);
        this._a = null;
    }

    public void __ctor(A a0, int initial__capacity) {
        this._a = a0;
        this.size = 0;
        this.capacity = initial__capacity;
        Function _init0 = ((Function<Object, Function>)_0_a0 -> _1___v0_boxed0 -> {
            BigInteger _1___v0 = _1___v0_boxed0;
            return _0_a0;
        }).apply(a0);
        Object _nw0 = this._td_A.newArray(Helpers.toIntChecked((long)initial__capacity, (String)"Java arrays may be no larger than the maximum 32-bit signed int"));
        BigInteger _i0_0 = BigInteger.ZERO;
        while (_i0_0.compareTo(BigInteger.valueOf(Array.getLength(_nw0))) < 0) {
            this._td_A.setArrayElement(_nw0, Helpers.toInt((BigInteger)_i0_0), _init0.apply(_i0_0));
            _i0_0 = _i0_0.add(BigInteger.ONE);
        }
        this.data = _nw0;
    }

    public A At(int idx) {
        return (A)this._td_A.getArrayElement(this.data, idx);
    }

    public A Top() {
        return (A)this._td_A.getArrayElement(this.data, this.size - 1);
    }

    public void Put(int idx, A a) {
        Object _arr0 = this.data;
        this._td_A.setArrayElement(_arr0, Helpers.toInt((int)idx), a);
    }

    public void CopyFrom(Object new__data, int count) {
        int _hi0 = count;
        int _0_idx = 0;
        while (Integer.compareUnsigned(_0_idx, _hi0) < 0) {
            Object _arr0 = this.data;
            this._td_A.setArrayElement(_arr0, Helpers.toInt((int)_0_idx), this._td_A.getArrayElement(new__data, _0_idx));
            ++_0_idx;
        }
    }

    public void Realloc(int new__capacity) {
        Object _rhs0 = this.data;
        int _rhs1 = this.capacity;
        Object _0_old__data = _rhs0;
        int _1_old__capacity = _rhs1;
        Function<BigInteger, Object> _init0 = _2___v1_boxed0 -> {
            BigInteger _2___v1 = _2___v1_boxed0;
            return this.a();
        };
        Object _nw0 = this._td_A.newArray(Helpers.toIntChecked((long)new__capacity, (String)"Java arrays may be no larger than the maximum 32-bit signed int"));
        BigInteger _i0_0 = BigInteger.ZERO;
        while (_i0_0.compareTo(BigInteger.valueOf(Array.getLength(_nw0))) < 0) {
            this._td_A.setArrayElement(_nw0, Helpers.toInt((BigInteger)_i0_0), _init0.apply(_i0_0));
            _i0_0 = _i0_0.add(BigInteger.ONE);
        }
        Object _rhs2 = _nw0;
        int _rhs3 = new__capacity;
        Vector _lhs0 = this;
        Vector _lhs1 = this;
        _lhs0.data = _rhs2;
        _lhs1.capacity = _rhs3;
        this.CopyFrom(_0_old__data, _1_old__capacity);
    }

    public int DefaultNewCapacity(int capacity) {
        if (Integer.compareUnsigned(capacity, this.MAX__CAPACITY__BEFORE__DOUBLING()) < 0) {
            return 2 * capacity;
        }
        return this.MAX__CAPACITY();
    }

    public Outcome<VectorError> ReallocDefault() {
        Outcome<VectorError> o = Outcome.Default(VectorError._typeDescriptor());
        if (this.capacity == this.MAX__CAPACITY()) {
            o = Outcome.create_Fail(VectorError._typeDescriptor(), VectorError.create());
            return o;
        }
        this.Realloc(this.DefaultNewCapacity(this.capacity));
        o = Outcome.create_Pass(VectorError._typeDescriptor());
        return o;
    }

    public Outcome<VectorError> Ensure(int reserved) {
        Outcome<VectorError> o = Outcome.Default(VectorError._typeDescriptor());
        if (Integer.compareUnsigned(reserved, this.MAX__CAPACITY() - this.size) > 0) {
            o = Outcome.create_Fail(VectorError._typeDescriptor(), VectorError.create());
            return o;
        }
        if (Integer.compareUnsigned(reserved, this.capacity - this.size) <= 0) {
            o = Outcome.create_Pass(VectorError._typeDescriptor());
            return o;
        }
        int _0_new__capacity = this.capacity;
        while (Integer.compareUnsigned(reserved, _0_new__capacity - this.size) > 0) {
            _0_new__capacity = this.DefaultNewCapacity(_0_new__capacity);
        }
        this.Realloc(_0_new__capacity);
        o = Outcome.create_Pass(VectorError._typeDescriptor());
        return o;
    }

    public void PopFast() {
        --this.size;
    }

    public void PushFast(A a) {
        Object _arr0 = this.data;
        int _index0 = this.size++;
        this._td_A.setArrayElement(_arr0, Helpers.toInt((int)_index0), a);
    }

    public Outcome<VectorError> Push(A a) {
        Outcome<VectorError> _out0;
        Outcome<VectorError> _0_d;
        Outcome<VectorError> o = Outcome.Default(VectorError._typeDescriptor());
        if (this.size == this.capacity && (_0_d = (_out0 = this.ReallocDefault())).is_Fail()) {
            o = _0_d;
            return o;
        }
        this.PushFast(a);
        o = Outcome.create_Pass(VectorError._typeDescriptor());
        return o;
    }

    public A a() {
        return this._a;
    }

    public int MAX__CAPACITY__BEFORE__DOUBLING() {
        return Integer.divideUnsigned(__default.UINT32__MAX(), 2);
    }

    public int MAX__CAPACITY() {
        return __default.UINT32__MAX();
    }

    public static <A> TypeDescriptor<Vector<A>> _typeDescriptor(TypeDescriptor<A> _td_A) {
        return TypeDescriptor.referenceWithInitializer(Vector.class, () -> null);
    }

    public String toString() {
        return "JSON.Utils.Vectors.Vector";
    }
}

