/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNaryDataRange;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public abstract class OWLNaryDataRangeImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLNaryDataRange {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLDataRange> operands;

    protected OWLNaryDataRangeImpl(@Nonnull Set<? extends OWLDataRange> operands) {
        OWLAPIPreconditions.checkNotNull(operands, "operands cannot be null");
        this.operands = CollectionFactory.sortOptionally(operands);
    }

    @Override
    public Set<OWLDataRange> getOperands() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.operands);
    }

    @Override
    public boolean isTopDatatype() {
        return false;
    }

    @Override
    public boolean isDatatype() {
        return false;
    }

    @Override
    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a datatype");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (OWLDataRange operand : this.operands) {
            this.addSignatureEntitiesToSetForValue(entities, operand);
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (OWLDataRange operand : this.operands) {
            this.addAnonymousIndividualsToSetForValue(anons, operand);
        }
    }
}

