# -*- shell-script -*-
# This program needs to be SOURCE'd and is not called as an executable
#
#   Copyright (C) 2008, 2011, 2024 Rocky Bernstein <rocky@gnu.org>
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 2, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; see the file COPYING.  If not, write to
#   the Free Software Foundation, 59 Temple Place, Suite 330, Boston,
#   MA 02111 USA.

typeset _Dbg_trace_old_set_opts
_Dbg_trace_old_set_opts=$-
set +u

# Name we refer to ourselves by
typeset _Dbg_debugger_name='zshdb'

# The shell we are configured to run under.
typeset _Dbg_shell='/usr/bin/zsh'

# The short shell name. Helps keep code common in bash, zsh, and ksh debuggers.
# Equivalent to
typeset _Dbg_shell_name=${_Dbg_shell##*/}

typeset -a _Dbg_script_args; _Dbg_script_args=("$@")

# Original $0. Note we can't set this in an include.
typeset _Dbg_orig_0=$0

# Equivalent to basename $0; the short program name
typeset _Dbg_pname=${0##*/}

## Stuff set by autoconf/configure ###
typeset prefix=/usr
typeset _Dbg_libdir=${prefix}/share/zshdb
###

[[ ! -d "$_Dbg_libdir" ]] && _Dbg_libdir='.'
# Parse just the libdir option
typeset -a libdir
zparseopts -a libdir -E L: -library:
if (( ${#libdir} > 0 )) ; then
    typeset -a lib_opts; eval "lib_opts=($libdir)"
    if [[ ! -d ${lib_opts[2]} ]] ; then
	print "${lib_opts[2]} is not a directory"
	exit 1
    fi
    _Dbg_libdir=${lib_opts[2]}
    unset lib_opts
fi

# Pull in the rest of the debugger code.
typeset _Dbg_main="$_Dbg_libdir/dbg-main.sh"
if [[ ! -r $_Dbg_main ]] ; then
  print "${_Dbg_pname}: Can't read debugger library file '${_Dbg_main}'."
  print "${_Dbg_pname}: Perhaps zshdb is installed wrong (if its installed)." >&2
  print "${_Dbg_pname}: Try running zshdb using -L (with a different directory)." >&2
  print "${_Dbg_pname}: Run zshdb --help for a list and explanation of options." >&2
  exit 1

fi
. "${_Dbg_libdir}/dbg-main.sh"

set -${_Dbg_trace_old_set_opts}
unset _Dbg_trace_old_set_opts

_Dbg_debugger() {
    trap '_Dbg_trap_handler $? "$0" "$@"' DEBUG
}
