/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note;

import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.NoteBuilder;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.NoteStyleAccessor;
import org.freeplane.features.note.NoteWriter;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.MainView;

public class NoteController
implements IExtension {
    public static final String NODE_NOTE_ICON = "accessories.plugins.NodeNoteIcon";
    private static final UIIcon noteIcon = IconStoreFactory.ICON_STORE.getUIIcon("knotes.svg");
    public static final Icon bwNoteIcon = IconStoreFactory.ICON_STORE.getUIIcon("note_black_and_transp.svg").getIcon();
    public static final String bwNoteIconUrl = "freeplaneresource:/images/note_black_and_transp.png";
    public static final String SHOW_NOTE_ICONS = "show_note_icons";
    private static final Integer NOTE_TOOLTIP = 9;
    public static final String SHOW_NOTES_IN_MAP = "show_notes_in_map";
    protected static final String SHOW_NOTE_ICON_IN_TOOLTIP = "show_note_icon_in_tooltip";
    private final ModeController modeController;

    public static NoteController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return NoteController.getController(modeController);
    }

    public static NoteController getController(ModeController modeController) {
        return modeController.getExtension(NoteController.class);
    }

    public static void install(NoteController noteController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(NoteController.class, noteController);
    }

    public NoteController() {
        ModeController modeController;
        this.modeController = modeController = Controller.getCurrentModeController();
        modeController.getMapController().getReadManager().addElementHandler("richcontent", new NoteBuilder());
        NoteWriter noteWriter = new NoteWriter(this);
        WriteManager writeManager = modeController.getMapController().getWriteManager();
        writeManager.addAttributeWriter("map", noteWriter);
        writeManager.addExtensionElementWriter(NoteModel.class, noteWriter);
        this.registerNoteTooltipProvider(modeController);
        this.registerStateIconProvider();
    }

    public String getNoteContentType(NodeModel node) {
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            String contentType;
            NoteModel note;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (note = NoteModel.getNote(styleNode)) == null || (contentType = note.getContentType()) == null) continue;
            return contentType;
        }
        return "html";
    }

    public final String getNoteText(NodeModel node) {
        NoteModel extension = node.getExtension(NoteModel.class);
        return extension != null ? extension.getText() : null;
    }

    protected void onWrite(MapModel map) {
    }

    private void registerNoteTooltipProvider(final ModeController modeController) {
        modeController.addToolTipProvider(NOTE_TOOLTIP, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController2, NodeModel node, Component view, ITooltipProvider.TooltipTrigger tooltipTrigger) {
                String text;
                if (!this.providesTooltip(node, tooltipTrigger)) {
                    return null;
                }
                String data = NoteModel.getNoteText(node);
                if (data == null) {
                    return null;
                }
                float zoom = view instanceof MainView ? ((MainView)view).getNodeView().getMap().getZoom() : 1.0f;
                String rule = new NoteStyleAccessor(modeController2, node, zoom, true).getNoteCSSStyle();
                StringBuilder tooltipBodyBegin = new StringBuilder("<body><div style=\"");
                tooltipBodyBegin.append(rule);
                tooltipBodyBegin.append("\">");
                if (ResourceController.getResourceController().getBooleanProperty(NoteController.SHOW_NOTE_ICON_IN_TOOLTIP)) {
                    tooltipBodyBegin.append("<img src =\"");
                    tooltipBodyBegin.append(NoteController.bwNoteIconUrl);
                    tooltipBodyBegin.append("\">");
                }
                try {
                    Object transformed = TextController.getController().getTransformedObjectNoFormattingNoThrow(node, NoteModel.getNote(node), data);
                    text = HtmlUtils.objectToHtml(transformed);
                }
                catch (Exception e) {
                    text = TextUtils.format("MainView.errorUpdateText", data, e.getLocalizedMessage());
                }
                if (!HtmlUtils.isHtml(text)) {
                    text = HtmlUtils.plainToHTML(text);
                }
                String tooltipText = text.replaceFirst("<body>", tooltipBodyBegin.toString()).replaceFirst("</body>", "</div></body>");
                return tooltipText;
            }

            private boolean providesTooltip(NodeModel node, ITooltipProvider.TooltipTrigger tooltipTrigger) {
                return tooltipTrigger == ITooltipProvider.TooltipTrigger.LINK || !NoteController.this.showNotesInMap(node.getMap()) || TextController.getController(modeController).isMinimized(node);
            }
        });
    }

    private void registerStateIconProvider() {
        IconController.getController().addStateIconProvider(new IStateIconProvider(){

            @Override
            public UIIcon getStateIcon(NodeModel node) {
                String showNoteIcon;
                boolean showIcon;
                if (NoteModel.getNoteText(node) != null && (showIcon = Boolean.parseBoolean(showNoteIcon = MapStyle.getController(NoteController.this.modeController).getPropertySetDefault(node.getMap(), NoteController.SHOW_NOTE_ICONS)))) {
                    return noteIcon;
                }
                return null;
            }

            @Override
            public boolean mustIncludeInIconRegistry() {
                return true;
            }
        });
    }

    public boolean showNotesInMap(MapModel model) {
        String property = MapStyleModel.getExtension(model).getProperty(SHOW_NOTES_IN_MAP);
        return Boolean.parseBoolean(property);
    }
}

