/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.openide.filesystems.FileFilterSupport;
import org.openide.filesystem.spi.FileChooserBuilderProvider;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class FileChooserBuilder {
    private boolean dirsOnly;
    private BadgeProvider badger;
    private String title;
    private String approveText;
    private static boolean PREVENT_SYMLINK_TRAVERSAL = !Boolean.getBoolean("allow.filechooser.symlink.traversal");
    private final String dirKey;
    private File failoverDir;
    private FileFilter filter;
    private boolean fileHiding;
    private boolean controlButtonsShown = true;
    private String aDescription;
    private boolean filesOnly;
    private static final boolean DONT_STORE_DIRECTORIES = Boolean.getBoolean("forget.recent.dirs");
    private SelectionApprover approver;
    private final List<FileFilter> filters = new ArrayList<FileFilter>(3);
    private boolean useAcceptAllFileFilter = true;
    private boolean force = false;

    public static FileChooserBuilder create(FileSystem fileSystem) {
        Collection providers = Lookup.getDefault().lookupAll(FileChooserBuilderProvider.class);
        for (FileChooserBuilderProvider provider : providers) {
            FileChooserBuilder builder = provider.createFileChooserBuilder(fileSystem);
            if (builder == null) continue;
            return builder;
        }
        return new FileChooserBuilder(fileSystem.getDisplayName());
    }

    public FileChooserBuilder(Class type) {
        this(type.getName());
    }

    public FileChooserBuilder(String dirKey) {
        Parameters.notNull((CharSequence)"dirKey", (Object)dirKey);
        this.dirKey = dirKey;
    }

    public FileChooserBuilder setDirectoriesOnly(boolean val) {
        this.dirsOnly = val;
        assert (!this.filesOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setFilesOnly(boolean val) {
        this.filesOnly = val;
        assert (!this.dirsOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setBadgeProvider(BadgeProvider provider) {
        this.badger = provider;
        return this;
    }

    public FileChooserBuilder setTitle(String val) {
        this.title = val;
        return this;
    }

    public FileChooserBuilder setApproveText(String val) {
        this.approveText = val;
        return this;
    }

    public FileChooserBuilder setFileFilter(FileFilter filter) {
        this.filter = filter;
        return this;
    }

    public FileChooserBuilder setAcceptAllFileFilterUsed(boolean accept) {
        this.useAcceptAllFileFilter = accept;
        return this;
    }

    public FileChooserBuilder setDefaultWorkingDirectory(File dir) {
        this.failoverDir = dir;
        return this;
    }

    public FileChooserBuilder setFileHiding(boolean fileHiding) {
        this.fileHiding = fileHiding;
        return this;
    }

    public FileChooserBuilder setControlButtonsAreShown(boolean val) {
        this.controlButtonsShown = val;
        return this;
    }

    public FileChooserBuilder setAccessibleDescription(String aDescription) {
        this.aDescription = aDescription;
        return this;
    }

    public JFileChooser createFileChooser() {
        SavedDirFileChooser result = new SavedDirFileChooser(this.dirKey, this.failoverDir, this.force, this.approver);
        this.prepareFileChooser(result);
        return result;
    }

    public FileChooserBuilder forceUseOfDefaultWorkingDirectory(boolean val) {
        this.force = val;
        return this;
    }

    public File[] showMultiOpenDialog() {
        JFileChooser chooser = this.createFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(Utilities.findDialogParent());
        if (0 == result) {
            File[] files = chooser.getSelectedFiles();
            return files == null ? new File[]{} : files;
        }
        return null;
    }

    public File showOpenDialog() {
        FileDialog fileDialog;
        JFileChooser chooser = this.createFileChooser();
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(chooser.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 0);
        }
        chooser.setMultiSelectionEnabled(false);
        int dlgResult = chooser.showOpenDialog(Utilities.findDialogParent());
        if (0 == dlgResult) {
            File result = chooser.getSelectedFile();
            if (result != null && !result.exists()) {
                result = null;
            }
            return result;
        }
        return null;
    }

    public File showSaveDialog() {
        FileDialog fileDialog;
        JFileChooser chooser = this.createFileChooser();
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(chooser.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 1);
        }
        int result = chooser.showSaveDialog(Utilities.findDialogParent());
        if (0 == result) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File showFileDialog(FileDialog fileDialog, int mode) {
        String oldFileDialogProp = System.getProperty("apple.awt.fileDialogForDirectories");
        if (this.dirsOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        fileDialog.setMode(mode);
        fileDialog.setVisible(true);
        if (this.dirsOnly) {
            if (null != oldFileDialogProp) {
                System.setProperty("apple.awt.fileDialogForDirectories", oldFileDialogProp);
            } else {
                System.clearProperty("apple.awt.fileDialogForDirectories");
            }
        }
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            String selFile = fileDialog.getFile();
            File dir = new File(fileDialog.getDirectory());
            return new File(dir, selFile);
        }
        return null;
    }

    private void prepareFileChooser(JFileChooser chooser) {
        chooser.setFileSelectionMode(this.dirsOnly ? 1 : (this.filesOnly ? 0 : 2));
        chooser.setFileHidingEnabled(this.fileHiding);
        chooser.setControlButtonsAreShown(this.controlButtonsShown);
        chooser.setAcceptAllFileFilterUsed(this.useAcceptAllFileFilter);
        if (this.title != null) {
            chooser.setDialogTitle(this.title);
        }
        if (this.approveText != null) {
            chooser.setApproveButtonText(this.approveText);
        }
        if (this.badger != null) {
            chooser.setFileView(new CustomFileView(new BadgeIconProvider(this.badger), chooser.getFileSystemView()));
        }
        if (PREVENT_SYMLINK_TRAVERSAL) {
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)chooser.getCurrentDirectory());
        }
        if (this.filter != null) {
            chooser.setFileFilter(this.filter);
        }
        if (this.aDescription != null) {
            chooser.getAccessibleContext().setAccessibleDescription(this.aDescription);
        }
        if (!this.filters.isEmpty()) {
            for (FileFilter f : this.filters) {
                chooser.addChoosableFileFilter(f);
            }
        }
    }

    private FileDialog createFileDialog(File currentDirectory) {
        if (this.badger != null) {
            return null;
        }
        if (!Boolean.getBoolean("nb.native.filechooser")) {
            return null;
        }
        if (this.dirsOnly && !BaseUtilities.isMac()) {
            return null;
        }
        Component parentComponent = Utilities.findDialogParent();
        Frame parentFrame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parentComponent);
        FileDialog fileDialog = new FileDialog(parentFrame);
        if (this.title != null) {
            fileDialog.setTitle(this.title);
        }
        if (null != currentDirectory) {
            fileDialog.setDirectory(currentDirectory.getAbsolutePath());
        }
        return fileDialog;
    }

    public FileChooserBuilder addFileFilter(FileFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public FileChooserBuilder addDefaultFileFilters() {
        this.filters.addAll(FileFilterSupport.findRegisteredFileFilters());
        return this;
    }

    public FileChooserBuilder setSelectionApprover(SelectionApprover approver) {
        this.approver = approver;
        return this;
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon1, Icon icon2, int xMerge, int yMerge) {
            assert (icon1 != null);
            assert (icon2 != null);
            this.icon1 = icon1;
            this.icon2 = icon2;
            if (xMerge == -1) {
                xMerge = icon1.getIconWidth() - icon2.getIconWidth();
            }
            if (yMerge == -1) {
                yMerge = icon1.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = xMerge;
            this.yMerge = yMerge;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y);
            this.icon2.paintIcon(c, g, x + this.xMerge, y + this.yMerge);
        }
    }

    private static final class CustomFileView
    extends FileView {
        private final IconProvider provider;
        private final FileSystemView view;

        CustomFileView(IconProvider provider, FileSystemView view) {
            this.provider = provider;
            this.view = view;
        }

        @Override
        public Icon getIcon(File f) {
            Icon result = this.view.getSystemIcon(f);
            result = this.provider.getIcon(f, result);
            return result;
        }
    }

    private static final class BadgeIconProvider
    implements IconProvider {
        private final BadgeProvider badger;

        public BadgeIconProvider(BadgeProvider badger) {
            this.badger = badger;
        }

        @Override
        public Icon getIcon(File file, Icon orig) {
            Icon badge = this.badger.getBadge(file);
            if (badge != null && orig != null) {
                return new MergedIcon(orig, badge, this.badger.getXOffset(), this.badger.getYOffset());
            }
            return orig;
        }
    }

    public static interface BadgeProvider {
        public Icon getBadge(File var1);

        public int getXOffset();

        public int getYOffset();
    }

    static interface IconProvider {
        public Icon getIcon(File var1, Icon var2);
    }

    private static final class SavedDirFileChooser
    extends JFileChooser {
        private final String dirKey;
        private final SelectionApprover approver;

        SavedDirFileChooser(String dirKey, File failoverDir, boolean force, SelectionApprover approver) {
            this.dirKey = dirKey;
            this.approver = approver;
            if (force && failoverDir != null && failoverDir.exists() && failoverDir.isDirectory()) {
                this.setCurrentDirectory(failoverDir);
            } else {
                String path;
                String string = path = DONT_STORE_DIRECTORIES ? null : NbPreferences.forModule(FileChooserBuilder.class).get(dirKey, null);
                if (path != null) {
                    File f = new File(path);
                    if (f.exists() && f.isDirectory()) {
                        this.setCurrentDirectory(f);
                    } else if (failoverDir != null) {
                        this.setCurrentDirectory(failoverDir);
                    }
                } else if (failoverDir != null) {
                    this.setCurrentDirectory(failoverDir);
                }
            }
        }

        @Override
        public void approveSelection() {
            if (this.approver != null) {
                boolean approved;
                File[] selected = this.getSelectedFiles();
                File sf = this.getSelectedFile();
                if ((selected == null || selected.length == 0) && sf != null) {
                    selected = new File[]{sf};
                }
                if (approved = this.approver.approve(selected)) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }

        @Override
        public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
            int result = super.showDialog(parent, approveButtonText);
            if (result == 0) {
                this.saveCurrentDir();
            }
            return result;
        }

        private void saveCurrentDir() {
            File dir = super.getCurrentDirectory();
            if (!DONT_STORE_DIRECTORIES && dir != null && dir.exists() && dir.isDirectory()) {
                NbPreferences.forModule(FileChooserBuilder.class).put(this.dirKey, dir.getPath());
            }
        }
    }

    public static interface SelectionApprover {
        public boolean approve(File[] var1);
    }
}

