/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.Tuples;

private import glib.MemorySlice;
private import glib.c.functions;
public  import glib.c.types;


/**
 * The #GTuples struct is used to return records (or tuples) from the
 * #GRelation by g_relation_select(). It only contains one public
 * member - the number of records that matched. To access the matched
 * records, you must use g_tuples_index().
 * 
 * Deprecated: Rarely used API
 */
public final class Tuples
{
	/** the main Gtk struct */
	protected GTuples* gTuples;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GTuples* getTuplesStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gTuples;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gTuples;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GTuples* gTuples, bool ownedRef = false)
	{
		this.gTuples = gTuples;
		this.ownedRef = ownedRef;
	}

	~this ()
	{
		if ( ownedRef )
			sliceFree(gTuples);
	}


	/**
	 * the number of records that matched.
	 */
	public @property uint len()
	{
		return gTuples.len;
	}

	/** Ditto */
	public @property void len(uint value)
	{
		gTuples.len = value;
	}

	/**
	 * Frees the records which were returned by g_relation_select(). This
	 * should always be called after g_relation_select() when you are
	 * finished with the records. The records are not removed from the
	 * #GRelation.
	 *
	 * Deprecated: Rarely used API
	 */
	public void destroy()
	{
		g_tuples_destroy(gTuples);
	}

	/**
	 * Gets a field from the records returned by g_relation_select(). It
	 * returns the given field of the record at the given index. The
	 * returned value should not be changed.
	 *
	 * Deprecated: Rarely used API
	 *
	 * Params:
	 *     index = the index of the record.
	 *     field = the field to return.
	 *
	 * Returns: the field of the record.
	 */
	public void* index(int index, int field)
	{
		return g_tuples_index(gTuples, index, field);
	}
}
