/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.exception;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ThrowableInterner;

public final class FrequentErrorLogger {
    @NotNull
    private final Map<Integer, Integer> ourReportedIssues;
    @NotNull
    private final Logger myLogger;

    @NotNull
    public static FrequentErrorLogger newInstance(@NotNull Logger logger) {
        if (logger == null) {
            FrequentErrorLogger.$$$reportNull$$$0(0);
        }
        return new FrequentErrorLogger(logger);
    }

    private FrequentErrorLogger(@NotNull Logger logger) {
        if (logger == null) {
            FrequentErrorLogger.$$$reportNull$$$0(1);
        }
        this.ourReportedIssues = new ConcurrentHashMap<Integer, Integer>();
        this.myLogger = logger;
    }

    public void error(@NotNull @NonNls String message, @NotNull Throwable t) {
        if (message == null) {
            FrequentErrorLogger.$$$reportNull$$$0(2);
        }
        if (t == null) {
            FrequentErrorLogger.$$$reportNull$$$0(3);
        }
        this.report(t, () -> this.myLogger.error(message, t));
    }

    public void error(@NotNull @NonNls String message, @NotNull Throwable t, Attachment ... attachments) {
        if (message == null) {
            FrequentErrorLogger.$$$reportNull$$$0(4);
        }
        if (t == null) {
            FrequentErrorLogger.$$$reportNull$$$0(5);
        }
        this.report(t, () -> this.myLogger.error(message, t, attachments));
    }

    public void info(@NotNull @NonNls String message, @NotNull Throwable t) {
        if (message == null) {
            FrequentErrorLogger.$$$reportNull$$$0(6);
        }
        if (t == null) {
            FrequentErrorLogger.$$$reportNull$$$0(7);
        }
        this.report(t, () -> this.myLogger.info(message, t));
    }

    private void report(@NotNull Throwable t, @NotNull Runnable writeToLog) {
        int hash;
        Integer reportedTimes;
        if (t == null) {
            FrequentErrorLogger.$$$reportNull$$$0(8);
        }
        if (writeToLog == null) {
            FrequentErrorLogger.$$$reportNull$$$0(9);
        }
        if ((reportedTimes = this.ourReportedIssues.get(hash = ThrowableInterner.computeHashCode(t))) == null || reportedTimes > 1000) {
            writeToLog.run();
            this.ourReportedIssues.put(hash, 1);
        } else {
            this.ourReportedIssues.put(hash, reportedTimes + 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeToLog";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/exception/FrequentErrorLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "info";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

