/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import javax.annotation.Nullable;
import org.gradle.internal.deprecation.DeprecationLogger;

@Deprecated
public class VersionNumber
implements Comparable<VersionNumber> {
    private static final DefaultScheme DEFAULT_SCHEME = new DefaultScheme();
    private static final SchemeWithPatchVersion PATCH_SCHEME = new SchemeWithPatchVersion();
    public static final VersionNumber UNKNOWN = VersionNumber.version(0);
    private final int major;
    private final int minor;
    private final int micro;
    private final int patch;
    private final String qualifier;
    private final AbstractScheme scheme;
    private boolean deprecationLogged;

    private static void logDeprecation() {
        DeprecationLogger.deprecateType(VersionNumber.class).willBeRemovedInGradle9().withUpgradeGuideSection(7, "org_gradle_util_reports_deprecations").nagUser();
    }

    public VersionNumber(int major, int minor, int micro, @Nullable String qualifier) {
        this(major, minor, micro, 0, qualifier, DEFAULT_SCHEME, true);
    }

    public VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier) {
        this(major, minor, micro, patch, qualifier, PATCH_SCHEME, true);
    }

    private VersionNumber(int major, int minor, int micro, int patch, @Nullable String qualifier, AbstractScheme scheme, boolean logDeprecation) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.patch = patch;
        this.qualifier = qualifier;
        this.scheme = scheme;
        if (logDeprecation) {
            VersionNumber.logDeprecation();
            this.deprecationLogged = true;
        }
    }

    private void maybeLogDeprecation() {
        if (!this.deprecationLogged) {
            VersionNumber.logDeprecation();
        }
    }

    public int getMajor() {
        this.maybeLogDeprecation();
        return this.major;
    }

    public int getMinor() {
        this.maybeLogDeprecation();
        return this.minor;
    }

    public int getMicro() {
        this.maybeLogDeprecation();
        return this.micro;
    }

    public int getPatch() {
        this.maybeLogDeprecation();
        return this.patch;
    }

    @Nullable
    public String getQualifier() {
        this.maybeLogDeprecation();
        return this.qualifier;
    }

    public VersionNumber getBaseVersion() {
        this.maybeLogDeprecation();
        return new VersionNumber(this.major, this.minor, this.micro, this.patch, null, this.scheme, false);
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        if (this.patch != other.patch) {
            return this.patch - other.patch;
        }
        return Ordering.natural().nullsLast().compare((Object)this.toLowerCase(this.qualifier), (Object)this.toLowerCase(other.qualifier));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.patch;
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.qualifier});
        return result;
    }

    public String toString() {
        this.maybeLogDeprecation();
        return this.scheme.format(this);
    }

    public static VersionNumber version(int major) {
        return VersionNumber.version(major, 0);
    }

    public static VersionNumber version(int major, int minor) {
        return new VersionNumber(major, minor, 0, 0, null, DEFAULT_SCHEME, false);
    }

    public static Scheme scheme() {
        VersionNumber.logDeprecation();
        return DEFAULT_SCHEME;
    }

    public static Scheme withPatchNumber() {
        VersionNumber.logDeprecation();
        return PATCH_SCHEME;
    }

    public static VersionNumber parse(String versionString) {
        return DEFAULT_SCHEME.parse(versionString);
    }

    @Nullable
    private String toLowerCase(@Nullable String string) {
        return string == null ? null : string.toLowerCase();
    }

    private static class SchemeWithPatchVersion
    extends AbstractScheme {
        private static final String VERSION_TEMPLATE = "%d.%d.%d.%d%s";

        private SchemeWithPatchVersion() {
            super(4);
        }

        @Override
        public String format(VersionNumber versionNumber) {
            return String.format(VERSION_TEMPLATE, versionNumber.major, versionNumber.minor, versionNumber.micro, versionNumber.patch, versionNumber.qualifier == null ? "" : "-" + versionNumber.qualifier);
        }
    }

    private static class DefaultScheme
    extends AbstractScheme {
        private static final String VERSION_TEMPLATE = "%d.%d.%d%s";

        public DefaultScheme() {
            super(3);
        }

        @Override
        public String format(VersionNumber versionNumber) {
            return String.format(VERSION_TEMPLATE, versionNumber.major, versionNumber.minor, versionNumber.micro, versionNumber.qualifier == null ? "" : "-" + versionNumber.qualifier);
        }
    }

    private static abstract class AbstractScheme
    implements Scheme {
        final int depth;

        protected AbstractScheme(int depth) {
            this.depth = depth;
        }

        @Override
        public VersionNumber parse(@Nullable String versionString) {
            if (versionString == null || versionString.length() == 0) {
                return UNKNOWN;
            }
            Scanner scanner = new Scanner(versionString);
            int major = 0;
            int minor = 0;
            int micro = 0;
            int patch = 0;
            if (!scanner.hasDigit()) {
                return UNKNOWN;
            }
            major = scanner.scanDigit();
            if (scanner.isSeparatorAndDigit('.')) {
                scanner.skipSeparator();
                minor = scanner.scanDigit();
                if (scanner.isSeparatorAndDigit('.')) {
                    scanner.skipSeparator();
                    micro = scanner.scanDigit();
                    if (this.depth > 3 && scanner.isSeparatorAndDigit('.', '_')) {
                        scanner.skipSeparator();
                        patch = scanner.scanDigit();
                    }
                }
            }
            if (scanner.isEnd()) {
                return new VersionNumber(major, minor, micro, patch, null, this, false);
            }
            if (scanner.isQualifier()) {
                scanner.skipSeparator();
                return new VersionNumber(major, minor, micro, patch, scanner.remainder(), this, false);
            }
            return UNKNOWN;
        }

        private static class Scanner {
            int pos;
            final String str;

            private Scanner(String string) {
                this.str = string;
            }

            boolean hasDigit() {
                return this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos));
            }

            boolean isSeparatorAndDigit(char ... separators) {
                return this.pos < this.str.length() - 1 && this.oneOf(separators) && Character.isDigit(this.str.charAt(this.pos + 1));
            }

            private boolean oneOf(char ... separators) {
                char current = this.str.charAt(this.pos);
                for (int i = 0; i < separators.length; ++i) {
                    char separator = separators[i];
                    if (current != separator) continue;
                    return true;
                }
                return false;
            }

            boolean isQualifier() {
                return this.pos < this.str.length() - 1 && this.oneOf('.', '-');
            }

            int scanDigit() {
                int start = this.pos;
                while (this.hasDigit()) {
                    ++this.pos;
                }
                return Integer.parseInt(this.str.substring(start, this.pos));
            }

            public boolean isEnd() {
                return this.pos == this.str.length();
            }

            public void skipSeparator() {
                ++this.pos;
            }

            @Nullable
            public String remainder() {
                return this.pos == this.str.length() ? null : this.str.substring(this.pos);
            }
        }
    }

    @Deprecated
    public static interface Scheme {
        public VersionNumber parse(String var1);

        public String format(VersionNumber var1);
    }
}

