#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-4wEItkatDyfAFCzTPH6SAN
key:                  lsp-2.1.0.0-4wEItkatDyfAFCzTPH6SAN
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  e18ac8538e22bdf8f43268447fc221dc
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-EjYcMkrIVdu9wybjt2x400:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-EjYcMkrIVdu9wybjt2x400:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-EjYcMkrIVdu9wybjt2x400:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-EjYcMkrIVdu9wybjt2x400:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-4wEItkatDyfAFCzTPH6SAN
depends:
    aeson-2.1.2.1-3HLieqpkeG06w6MDAYdLLk
    async-2.2.5-GGvJE1nOBFYGFw0FXsPFU0
    attoparsec-0.14.4-D6xkbFZLQBXDD0qvU7o55y base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-1Xm391iqQA3JzPA3ZEW0rk
    containers-0.6.7 data-default-0.7.1.3-1SaGr9SWFYZ17MG1fTAOKi
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.7.0-KrA5CwhmktQ6Qu5a4JCqq7
    lens-5.3.3-1zYcQilqoBK5EhYwkXjOnb
    lsp-types-2.0.1.0-EjYcMkrIVdu9wybjt2x400 mtl-2.2.2
    prettyprinter-1.7.1-IxfK3MMc5TsGC7SkX421m7
    random-1.2.1.3-KY8hXIsRO0nEsZvihu4hBT
    row-types-1.0.1.2-4x8U1r2LNA9AnBIlVe6fUq
    sorted-list-0.2.3.1-1EyuINttNxEHWSXCyB2xGD stm-2.5.1.0
    temporary-1.3-Kn2M9G1H4VS6orEei4BtCV text-2.0.2
    text-rope-0.3-31JrMTK7qlyJ4XXJrO6vBR transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM
    uuid-1.3.16-7LbW7JPPUccGPBdJigsSEH

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

