#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-CdC8peAfrdb8hOGLMSVnxm
key:                  trifecta-2.1.4-CdC8peAfrdb8hOGLMSVnxm
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  5b939e098ada840123842af927d50c79
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-CdC8peAfrdb8hOGLMSVnxm
depends:
    ansi-terminal-1.0.2-HSq0v3QUl8T11Wgx1QLnTe array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-1AsqmJqbexUDW45IoYp4gz
    blaze-html-0.9.2.0-3cSCYM9QSR99BQnVHXrYzE
    blaze-markup-0.8.3.0-gQO1lU2QPQ9hXIev9mjlD bytestring-0.11.5.3
    charset-0.3.12-1p9k4y1n0jP2YEwlz0PgWj
    comonad-5.0.9-69ztrEylAHVD4BHHoJEwKX containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-9t49hsSqDY3BaiXjhf8y3o
    ghc-prim-0.9.1 hashable-1.4.7.0-KrA5CwhmktQ6Qu5a4JCqq7
    indexed-traversable-0.1.4-KvS9wRlCKDWFRGYTEgz6lC
    lens-5.3.3-1zYcQilqoBK5EhYwkXjOnb mtl-2.2.2
    parsers-0.12.12-AruA0KJE2LQHQP2zlD1Eci
    prettyprinter-1.7.1-IxfK3MMc5TsGC7SkX421m7
    prettyprinter-ansi-terminal-1.1.3-AVYpYA7i4fdJ805glBa68
    profunctors-5.6.3-GJws21l5du15P9B6ShOpfs
    reducers-3.12.5-820cDb4znE9Cq21cO3kAUK transformers-0.5.6.2
    unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

