/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.context;

import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.Contextualized;
import io.smallrye.mutiny.infrastructure.CallbackDecorator;
import io.smallrye.mutiny.tuples.Functions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class BaseContextPropagationInterceptor
implements CallbackDecorator {
    protected abstract SmallRyeThreadContext getThreadContext();

    public <T> Supplier<T> decorate(Supplier<T> supplier) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(supplier)) {
            return supplier;
        }
        return context.contextualSupplier(supplier);
    }

    public <T> Consumer<T> decorate(Consumer<T> consumer) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(consumer)) {
            return consumer;
        }
        return context.contextualConsumer(consumer);
    }

    public LongConsumer decorate(LongConsumer consumer) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized((Object)consumer) || context.isEmpty()) {
            return consumer;
        }
        Consumer cons = context.contextualConsumer(consumer::accept);
        return new ContextualizedLongConsumer(cons);
    }

    public Runnable decorate(Runnable runnable) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized((Object)runnable)) {
            return runnable;
        }
        return context.contextualRunnable(runnable);
    }

    public <V> Callable<V> decorate(Callable<V> callable) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(callable)) {
            return callable;
        }
        return context.contextualCallable(callable);
    }

    public <T1, T2> BiConsumer<T1, T2> decorate(BiConsumer<T1, T2> consumer) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(consumer)) {
            return consumer;
        }
        return context.contextualConsumer(consumer);
    }

    public <I, O> Function<I, O> decorate(Function<I, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function)) {
            return function;
        }
        return context.contextualFunction(function);
    }

    public <I1, I2, I3, O> Functions.Function3<I1, I2, I3, O> decorate(Functions.Function3<I1, I2, I3, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2]));
        return new ContextualizedFunction3(fun);
    }

    public <I1, I2, I3, I4, O> Functions.Function4<I1, I2, I3, I4, O> decorate(Functions.Function4<I1, I2, I3, I4, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2], args[3]));
        return new ContextualizedFunction4(fun);
    }

    public <I1, I2, I3, I4, I5, O> Functions.Function5<I1, I2, I3, I4, I5, O> decorate(Functions.Function5<I1, I2, I3, I4, I5, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2], args[3], args[4]));
        return new ContextualizedFunction5(fun);
    }

    public <I1, I2, I3, I4, I5, I6, O> Functions.Function6<I1, I2, I3, I4, I5, I6, O> decorate(Functions.Function6<I1, I2, I3, I4, I5, I6, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2], args[3], args[4], args[5]));
        return new ContextualizedFunction6(fun);
    }

    public <I1, I2, I3, I4, I5, I6, I7, O> Functions.Function7<I1, I2, I3, I4, I5, I6, I7, O> decorate(Functions.Function7<I1, I2, I3, I4, I5, I6, I7, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2], args[3], args[4], args[5], args[6]));
        return new ContextualizedFunction7(fun);
    }

    public <I1, I2, I3, I4, I5, I6, I7, I8, O> Functions.Function8<I1, I2, I3, I4, I5, I6, I7, I8, O> decorate(Functions.Function8<I1, I2, I3, I4, I5, I6, I7, I8, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]));
        return new ContextualizedFunction8(fun);
    }

    public <I1, I2, I3, I4, I5, I6, I7, I8, I9, O> Functions.Function9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> decorate(Functions.Function9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function) || context.isEmpty()) {
            return function;
        }
        Function fun = context.contextualFunction(args -> function.apply(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]));
        return new ContextualizedFunction9(fun);
    }

    public <I1, I2, O> BiFunction<I1, I2, O> decorate(BiFunction<I1, I2, O> function) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(function)) {
            return function;
        }
        return context.contextualFunction(function);
    }

    public <T> BinaryOperator<T> decorate(BinaryOperator<T> operator) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(operator) || context.isEmpty()) {
            return operator;
        }
        BiFunction function = context.contextualFunction(operator);
        return new ContextualizedBinaryOperator(function);
    }

    public <T1, T2, T3> Functions.TriConsumer<T1, T2, T3> decorate(Functions.TriConsumer<T1, T2, T3> consumer) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(consumer) || context.isEmpty()) {
            return consumer;
        }
        return new ContextualizedTriConsumer<T1, T2, T3>(context.currentContextExecutor(), consumer);
    }

    public BooleanSupplier decorate(BooleanSupplier supplier) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized((Object)supplier) || context.isEmpty()) {
            return supplier;
        }
        Supplier contextualized = context.contextualSupplier(supplier::getAsBoolean);
        return new ContextualizedBooleanSupplier(contextualized);
    }

    public <T> Predicate<T> decorate(Predicate<T> predicate) {
        SmallRyeThreadContext context = this.getThreadContext();
        if (context.isContextualized(predicate) || context.isEmpty()) {
            return predicate;
        }
        Function contextualized = context.contextualFunction(predicate::test);
        return new ContextualizedPredicate(contextualized);
    }

    static class ContextualizedPredicate<T>
    implements Predicate<T>,
    Contextualized {
        private final Function<T, Boolean> contextualized;

        ContextualizedPredicate(Function<T, Boolean> contextualized) {
            this.contextualized = contextualized;
        }

        @Override
        public boolean test(T t) {
            return this.contextualized.apply(t);
        }
    }

    static class ContextualizedBooleanSupplier
    implements BooleanSupplier,
    Contextualized {
        private final Supplier<Boolean> contextualized;

        ContextualizedBooleanSupplier(Supplier<Boolean> contextualized) {
            this.contextualized = contextualized;
        }

        @Override
        public boolean getAsBoolean() {
            return this.contextualized.get();
        }
    }

    static class ContextualizedTriConsumer<T1, T2, T3>
    implements Functions.TriConsumer<T1, T2, T3>,
    Contextualized {
        private final Executor executor;
        private final Functions.TriConsumer<T1, T2, T3> consumer;

        ContextualizedTriConsumer(Executor executor, Functions.TriConsumer<T1, T2, T3> consumer) {
            this.executor = executor;
            this.consumer = consumer;
        }

        public void accept(T1 t1, T2 t2, T3 t3) {
            this.executor.execute(() -> this.consumer.accept(t1, t2, t3));
        }
    }

    static class ContextualizedBinaryOperator<T>
    implements BinaryOperator<T>,
    Contextualized {
        private final BiFunction<T, T, T> contextualized;

        ContextualizedBinaryOperator(BiFunction<T, T, T> contextualized) {
            this.contextualized = contextualized;
        }

        @Override
        public T apply(T t, T t2) {
            return this.contextualized.apply(t, t2);
        }
    }

    static class ContextualizedFunction9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O>
    implements Functions.Function9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction9(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3, I4 item4, I5 item5, I6 item6, I7 item7, I8 item8, I9 item9) {
            return this.function.apply(new Object[]{item1, item2, item3, item4, item5, item6, item7, item8, item9});
        }
    }

    static class ContextualizedFunction8<I1, I2, I3, I4, I5, I6, I7, I8, O>
    implements Functions.Function8<I1, I2, I3, I4, I5, I6, I7, I8, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction8(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3, I4 item4, I5 item5, I6 item6, I7 item7, I8 item8) {
            return this.function.apply(new Object[]{item1, item2, item3, item4, item5, item6, item7, item8});
        }
    }

    static class ContextualizedFunction7<I1, I2, I3, I4, I5, I6, I7, O>
    implements Functions.Function7<I1, I2, I3, I4, I5, I6, I7, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction7(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3, I4 item4, I5 item5, I6 item6, I7 item7) {
            return this.function.apply(new Object[]{item1, item2, item3, item4, item5, item6, item7});
        }
    }

    static class ContextualizedFunction6<I1, I2, I3, I4, I5, I6, O>
    implements Functions.Function6<I1, I2, I3, I4, I5, I6, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction6(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3, I4 item4, I5 item5, I6 item6) {
            return this.function.apply(new Object[]{item1, item2, item3, item4, item5, item6});
        }
    }

    static class ContextualizedFunction5<I1, I2, I3, I4, I5, O>
    implements Functions.Function5<I1, I2, I3, I4, I5, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction5(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3, I4 item4, I5 item5) {
            return this.function.apply(new Object[]{item1, item2, item3, item4, item5});
        }
    }

    static class ContextualizedFunction4<I1, I2, I3, I4, O>
    implements Functions.Function4<I1, I2, I3, I4, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction4(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3, I4 item4) {
            return this.function.apply(new Object[]{item1, item2, item3, item4});
        }
    }

    static class ContextualizedFunction3<I1, I2, I3, O>
    implements Functions.Function3<I1, I2, I3, O>,
    Contextualized {
        private final Function<Object[], O> function;

        ContextualizedFunction3(Function<Object[], O> function) {
            this.function = function;
        }

        public O apply(I1 item1, I2 item2, I3 item3) {
            return this.function.apply(new Object[]{item1, item2, item3});
        }
    }

    static class ContextualizedLongConsumer
    implements LongConsumer,
    Contextualized {
        private final Consumer<Long> contextualized;

        ContextualizedLongConsumer(Consumer<Long> contextualized) {
            this.contextualized = contextualized;
        }

        @Override
        public void accept(long value) {
            this.contextualized.accept(value);
        }
    }
}

