/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.v1;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilterQuery
implements Serializable {
    private static final long serialVersionUID = -142808200594318258L;
    public final int count;
    public final long[] follow;
    public final String[] track;
    public final double[][] locations;
    public final String[] language;
    public final FilterLevel filterLevel;

    private FilterQuery(int count, long @Nullable [] follow, @Nullable String[] track, double[][] locations, @Nullable String[] language, @Nullable FilterLevel filterLevel) {
        this.count = count;
        this.follow = follow;
        this.track = track;
        this.locations = locations;
        this.language = language;
        this.filterLevel = filterLevel;
    }

    public FilterQuery count(int count) {
        return new FilterQuery(count, this.follow, this.track, this.locations, this.language, this.filterLevel);
    }

    public static FilterQuery ofFollow(long ... follow) {
        return new FilterQuery(0, follow, null, null, null, null);
    }

    public FilterQuery follow(long ... follow) {
        return new FilterQuery(this.count, follow, this.track, this.locations, this.language, this.filterLevel);
    }

    public static FilterQuery ofTrack(String ... track) {
        return new FilterQuery(0, null, track, null, null, null);
    }

    public FilterQuery track(String ... track) {
        return new FilterQuery(this.count, this.follow, track, this.locations, this.language, this.filterLevel);
    }

    public static FilterQuery ofLocations(double[] @NotNull [] locations) {
        return new FilterQuery(0, null, null, locations, null, null);
    }

    public FilterQuery locations(double[] @NotNull [] locations) {
        return new FilterQuery(this.count, this.follow, this.track, locations, this.language, this.filterLevel);
    }

    public FilterQuery language(String ... language) {
        return new FilterQuery(this.count, this.follow, this.track, this.locations, language, this.filterLevel);
    }

    public FilterQuery filterLevel(@NotNull FilterLevel filterLevel) {
        return new FilterQuery(this.count, this.follow, this.track, this.locations, this.language, filterLevel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterQuery that = (FilterQuery)o;
        if (this.count != that.count) {
            return false;
        }
        if (!Arrays.equals(this.follow, that.follow)) {
            return false;
        }
        if (!Arrays.equals(this.track, that.track)) {
            return false;
        }
        if (!Arrays.equals(this.language, that.language)) {
            return false;
        }
        return Objects.equals((Object)this.filterLevel, (Object)that.filterLevel);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + (this.follow != null ? Arrays.hashCode(this.follow) : 0);
        result = 31 * result + (this.track != null ? Arrays.hashCode(this.track) : 0);
        result = 31 * result + (this.language != null ? Arrays.hashCode(this.language) : 0);
        result = 31 * result + (this.filterLevel != null ? this.filterLevel.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FilterQuery{count=" + this.count + ", follow=" + Arrays.toString(this.follow) + ", track=" + (this.track == null ? null : Arrays.asList(this.track)) + ", locations=" + (this.locations == null ? null : Arrays.asList(this.locations)) + ", language=" + (this.language == null ? null : Arrays.asList(this.language)) + ", filter_level=" + (Object)((Object)this.filterLevel) + '}';
    }

    public static enum FilterLevel {
        NONE,
        LOW,
        MEDIUM;

    }
}

