/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ExplainedVerificationException;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.ActionTokenHandler;
import org.keycloak.authentication.actiontoken.DefaultActionToken;
import org.keycloak.authentication.actiontoken.ExplainedTokenVerificationException;
import org.keycloak.authentication.actiontoken.resetcred.ResetCredentialsActionTokenHandler;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.TriFunction;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.exceptions.TokenNotActiveException;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.MessageType;
import org.keycloak.forms.login.freemarker.DetachedInfoStateChecker;
import org.keycloak.forms.login.freemarker.DetachedInfoStateCookie;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.DefaultActionTokenKey;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectKeyModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.UserConsentManager;
import org.keycloak.services.resources.LoginActionsServiceChecks;
import org.keycloak.services.resources.LoginActionsServiceException;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SessionCodeChecks;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.BrowserHistoryHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.LocaleUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class LoginActionsService {
    private static final Logger logger = Logger.getLogger(LoginActionsService.class);
    public static final String AUTHENTICATE_PATH = "authenticate";
    public static final String REGISTRATION_PATH = "registration";
    public static final String RESET_CREDENTIALS_PATH = "reset-credentials";
    public static final String REQUIRED_ACTION = "required-action";
    public static final String FIRST_BROKER_LOGIN_PATH = "first-broker-login";
    public static final String POST_BROKER_LOGIN_PATH = "post-broker-login";
    public static final String RESTART_PATH = "restart";
    public static final String DETACHED_INFO_PATH = "detached-info";
    public static final String FORWARDED_ERROR_MESSAGE_NOTE = "forwardedErrorMessage";
    public static final String SESSION_CODE = "session_code";
    public static final String AUTH_SESSION_ID = "auth_session_id";
    public static final String CANCEL_AIA = "cancel-aia";
    private final RealmModel realm;
    private final HttpRequest request;
    protected final HttpHeaders headers;
    private final ClientConnection clientConnection;
    protected final KeycloakSession session;
    private EventBuilder event;

    public static UriBuilder loginActionsBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return LoginActionsService.loginActionsBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authenticationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "authenticateForm");
    }

    public static UriBuilder requiredActionProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "requiredActionPOST");
    }

    public static UriBuilder actionTokenProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "executeActionToken");
    }

    public static UriBuilder registrationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "processRegister");
    }

    public static UriBuilder firstBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "firstBrokerLoginGet");
    }

    public static UriBuilder postBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "postBrokerLoginGet");
    }

    public static UriBuilder loginActionsBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getLoginActionsService");
    }

    public LoginActionsService(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.event = event;
        CacheControlUtil.noBackButtonCacheControlHeader(session);
        this.request = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    private boolean checkSsl() {
        if (this.session.getContext().getUri().getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    private SessionCodeChecks checksForCode(String authSessionId, String code, String execution, String clientId, String tabId, String clientData, String flowPath) {
        SessionCodeChecks res = new SessionCodeChecks(this.realm, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, authSessionId, code, execution, clientId, tabId, clientData, flowPath);
        res.initialVerify();
        return res;
    }

    protected URI getLastExecutionUrl(String flowPath, String executionId, String clientId, String tabId, String clientData) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, (UriInfo)this.session.getContext().getUri()).getLastExecutionUrl(flowPath, executionId, clientId, tabId, clientData);
    }

    @Path(value="restart")
    @GET
    public Response restartSession(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="client_data") String clientData, @QueryParam(value="skip_logout") String skipLogout) {
        UserSessionModel userSession;
        this.event.event(EventType.RESTART_AUTHENTICATION);
        SessionCodeChecks checks = new SessionCodeChecks(this.realm, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, authSessionId, null, null, clientId, tabId, clientData, null);
        AuthenticationSessionModel authSession = checks.initialVerifyAuthSession();
        if (authSession == null) {
            return checks.getResponse();
        }
        this.event.user(authSession.getAuthenticatedUser());
        this.event.detail("username", authSession.getAuthNote("ATTEMPTED_USERNAME"));
        this.event.detail("auth_method", authSession.getProtocol());
        String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
        if (flowPath == null) {
            flowPath = AUTHENTICATE_PATH;
        }
        if (!Boolean.parseBoolean(skipLogout) && (userSession = new AuthenticationSessionManager(this.session).getUserSession(authSession)) != null) {
            logger.debugf("Logout of user session %s when restarting flow during re-authentication", (Object)userSession.getId());
            AuthenticationManager.backchannelLogout(this.session, userSession, false);
            authSession = AuthenticationProcessor.recreate(this.session, authSession);
        }
        AuthenticationProcessor.resetFlow(authSession, flowPath);
        URI redirectUri = this.getLastExecutionUrl(flowPath, null, authSession.getClient().getClientId(), authSession.getTabId(), AuthenticationProcessor.getClientData(this.session, authSession));
        logger.debugf("Flow restart requested. Redirecting to %s", (Object)redirectUri);
        this.event.success();
        return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
    }

    @Path(value="detached-info")
    @GET
    public Response detachedInfo(@QueryParam(value="kc_state_checker") String stateCheckerParam) {
        ClientModel client;
        DetachedInfoStateCookie cookie;
        try {
            cookie = new DetachedInfoStateChecker(this.session, this.realm).verifyStateCheckerParameter(stateCheckerParam);
            logger.tracef("Detached info endpoint invoked and cookie successfully verified. StateCheckerParam=%s, StateCookie=%s", (Object)stateCheckerParam, (Object)cookie);
        }
        catch (VerificationException ve) {
            logger.warn((Object)ve.getMessage());
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "expiredActionTokenNoSessionMessage", new Object[0]);
        }
        this.processLocaleParam(null);
        boolean skipLink = true;
        if (cookie.getClientUuid() != null && (client = this.session.clients().getClientById(this.realm, cookie.getClientUuid())) != null) {
            this.session.getContext().setClient(client);
            skipLink = client.equals((Object)SystemClientUtil.getSystemClient((RealmModel)this.realm));
        }
        MessageType type = Enum.valueOf(MessageType.class, cookie.getMessageType());
        Response.Status statusObj = cookie.getStatus() == null ? Response.Status.BAD_REQUEST : Response.Status.fromStatusCode((int)cookie.getStatus());
        Object[] paramsAsObject = cookie.getMessageParameters() == null ? null : cookie.getMessageParameters().toArray();
        LoginFormsProvider loginForm = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setDetachedAuthSession().setMessage(type, cookie.getMessageKey(), paramsAsObject);
        if (skipLink) {
            loginForm.setAttribute("skipLink", (Object)true);
        }
        return type == MessageType.ERROR ? loginForm.createErrorPage(statusObj) : loginForm.createInfoPage();
    }

    @Path(value="authenticate")
    @GET
    public Response authenticate(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="client_data") String clientData) {
        this.event.event(EventType.LOGIN);
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, clientData, AUTHENTICATE_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        boolean actionRequest = checks.isActionRequest();
        this.processLocaleParam(authSession);
        return this.processAuthentication(actionRequest, execution, authSession, null);
    }

    protected void processLocaleParam(AuthenticationSessionModel authSession) {
        LocaleUtil.processLocaleParam(this.session, this.realm, authSession);
    }

    protected Response processAuthentication(boolean action, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        return this.processFlow(action, execution, authSession, AUTHENTICATE_PATH, AuthenticationFlowResolver.resolveBrowserFlow((AuthenticationSessionModel)authSession), errorMessage, new AuthenticationProcessor());
    }

    protected Response processFlow(boolean action, String execution, AuthenticationSessionModel authSession, String flowPath, AuthenticationFlowModel flow, String errorMessage, AuthenticationProcessor processor) {
        Response response;
        String forwardedErrorMessage;
        processor.setAuthenticationSession(authSession).setFlowPath(flowPath).setBrowserFlow(true).setFlowId(flow.getId()).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage));
        }
        if ((forwardedErrorMessage = authSession.getAuthNote(FORWARDED_ERROR_MESSAGE_NOTE)) != null) {
            authSession.removeAuthNote(FORWARDED_ERROR_MESSAGE_NOTE);
            processor.setForwardedErrorMessage(new FormMessage(null, forwardedErrorMessage));
        }
        try {
            response = action ? processor.authenticationAction(execution) : processor.authenticate();
        }
        catch (WebApplicationException e) {
            response = e.getResponse();
            authSession = processor.getAuthenticationSession();
        }
        catch (Exception e) {
            response = processor.handleBrowserException(e);
            authSession = processor.getAuthenticationSession();
        }
        return BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, response, action, this.request);
    }

    @Path(value="authenticate")
    @POST
    public Response authenticateForm(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="client_data") String clientData) {
        return this.authenticate(authSessionId, code, execution, clientId, tabId, clientData);
    }

    @Path(value="reset-credentials")
    @POST
    public Response resetCredentialsPOST(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="client_data") String clientData, @QueryParam(value="key") String key) {
        if (key != null) {
            return this.handleActionToken(key, execution, clientId, tabId, clientData, null);
        }
        this.event.event(EventType.RESET_PASSWORD);
        return this.resetCredentials(authSessionId, code, execution, clientId, tabId, clientData);
    }

    @Path(value="reset-credentials")
    @GET
    public Response resetCredentialsGET(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="tab_id") String tabId, @QueryParam(value="client_data") String clientData) {
        ClientModel client = this.realm.getClientByClientId(clientId);
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).getCurrentAuthenticationSession(this.realm, client, tabId);
        this.processLocaleParam(authSession);
        this.event.event(EventType.RESET_PASSWORD);
        if (authSession == null && code == null && clientData == null) {
            if (!this.realm.isResetPasswordAllowed()) {
                this.event.error("not_allowed");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "resetCredentialNotAllowedMessage", new Object[0]);
            }
            authSession = this.createAuthenticationSessionForClient(clientId, redirectUri);
            return this.processResetCredentials(false, null, authSession, null);
        }
        return this.resetCredentials(authSessionId, code, execution, clientId, tabId, clientData);
    }

    AuthenticationSessionModel createAuthenticationSessionForClient(String clientID, String redirectUriParam) throws UriBuilderException, IllegalArgumentException {
        ClientModel client;
        String redirectUri = null;
        if (clientID == null) {
            if (redirectUriParam != null) {
                logger.warn((Object)"Unsupported to send 'redirect_uri' parameter without providing 'client_id' parameter.");
                throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "missingParameterMessage", "client_id");
            }
            client = SystemClientUtil.getSystemClient((RealmModel)this.realm);
            redirectUri = Urls.accountBase(this.session.getContext().getUri().getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        } else {
            client = this.session.clients().getClientByClientId(this.realm, clientID);
            if (client == null) {
                throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
            }
            if (!client.isEnabled()) {
                throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "clientDisabledMessage", new Object[0]);
            }
            if (redirectUriParam != null && (redirectUri = RedirectUtils.verifyRedirectUri(this.session, redirectUriParam, client)) == null) {
                throw new ErrorPageException(this.session, null, Response.Status.BAD_REQUEST, "invalidParameterMessage", "redirect_uri");
            }
        }
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, true);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("response_type", "code");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        if (redirectUri != null) {
            authSession.setRedirectUri(redirectUri);
            authSession.setClientNote("redirect_uri", redirectUri);
        } else {
            authSession.setAuthNote("END_AFTER_REQUIRED_ACTIONS", "true");
        }
        return authSession;
    }

    protected Response resetCredentials(String authSessionId, String code, String execution, String clientId, String tabId, String clientData) {
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, clientData, RESET_CREDENTIALS_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.USER)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        if (!this.realm.isResetPasswordAllowed()) {
            this.event.error("not_allowed");
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this.processResetCredentials(checks.isActionRequest(), execution, authSession, null);
    }

    @Path(value="action-token")
    @GET
    public Response executeActionToken(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="key") String key, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.handleActionToken(key, execution, clientId, tabId, clientData, null);
    }

    protected <T extends JsonWebToken> Response handleActionToken(String tokenString, String execution, String clientId, String tabId, String clientData, TriFunction<ActionTokenHandler<T>, T, ActionTokenContext<T>, Response> preHandleToken) {
        JsonWebToken token;
        ActionTokenHandler<Object> handler;
        String eventError = null;
        String defaultErrorMessage = null;
        AuthenticationSessionModel authSession = null;
        ClientModel client = null;
        if (clientId != null) {
            client = this.realm.getClientByClientId(clientId);
        }
        AuthenticationSessionManager authenticationSessionManager = new AuthenticationSessionManager(this.session);
        KeycloakContext sessionContext = this.session.getContext();
        if (client != null) {
            sessionContext.setClient(client);
            authSession = authenticationSessionManager.getCurrentAuthenticationSession(this.realm, client, tabId);
        }
        this.event.event(EventType.EXECUTE_ACTION_TOKEN);
        try {
            if (tokenString == null) {
                throw new ExplainedTokenVerificationException(null, "not_allowed", "invalidRequestMessage");
            }
            TokenVerifier tokenVerifier = TokenVerifier.create((String)tokenString, DefaultActionTokenKey.class);
            DefaultActionTokenKey aToken = (DefaultActionTokenKey)tokenVerifier.getToken();
            this.event.detail("token_id", aToken.getId()).detail("action", aToken.getActionId()).user(aToken.getUserId());
            handler = this.resolveActionTokenHandler(aToken.getActionId());
            eventError = handler.getDefaultEventError();
            defaultErrorMessage = handler.getDefaultErrorMessage();
            if (!this.realm.isEnabled()) {
                throw new ExplainedTokenVerificationException((JsonWebToken)aToken, "realm_disabled", "realmNotEnabledMessage");
            }
            if (!this.checkSsl()) {
                throw new ExplainedTokenVerificationException((JsonWebToken)aToken, "ssl_required", "httpsRequiredMessage");
            }
            TokenVerifier verifier = tokenVerifier.withChecks(new TokenVerifier.Predicate[]{TokenVerifier.IS_ACTIVE, new TokenVerifier.RealmUrlCheck(Urls.realmIssuer(sessionContext.getUri().getBaseUri(), this.realm.getName())), DefaultActionToken.ACTION_TOKEN_BASIC_CHECKS});
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            SignatureVerifierContext signatureVerifier = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, algorithm)).verifier(kid);
            verifier.verifierContext(signatureVerifier);
            verifier.verify();
            token = TokenVerifier.create((String)tokenString, handler.getTokenClass()).getToken();
        }
        catch (TokenNotActiveException ex) {
            if (authSession != null) {
                this.event.clone().error("expired_code");
                String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
                if (flowPath == null) {
                    flowPath = AUTHENTICATE_PATH;
                }
                AuthenticationProcessor.resetFlow(authSession, flowPath);
                return this.processFlowFromPath(flowPath, authSession, "expiredActionTokenSessionExistsMessage");
            }
            return this.handleActionTokenVerificationException(null, (VerificationException)((Object)ex), "expired_code", "expiredActionTokenNoSessionMessage");
        }
        catch (ExplainedTokenVerificationException ex) {
            return this.handleActionTokenVerificationException(null, (VerificationException)((Object)ex), ex.getErrorEvent(), ex.getMessage());
        }
        catch (ExplainedVerificationException ex) {
            return this.handleActionTokenVerificationException(null, ex, ex.getErrorEvent(), ex.getMessage());
        }
        catch (VerificationException ex) {
            return this.handleActionTokenVerificationException(null, ex, eventError, defaultErrorMessage);
        }
        ActionTokenContext<T> tokenContext = new ActionTokenContext<T>(this.session, this.realm, (UriInfo)sessionContext.getUri(), this.clientConnection, this.request, this.event, handler, execution, clientData, this::processFlow, this::brokerLoginFlow);
        if (preHandleToken != null) {
            return (Response)preHandleToken.apply(handler, (Object)token, tokenContext);
        }
        try {
            String tokenAuthSessionCompoundId = handler.getAuthenticationSessionIdFromToken(token, tokenContext, authSession);
            if (authSession == null) {
                authSession = handler.startFreshAuthenticationSession(token, tokenContext);
                tokenContext.setAuthenticationSession(authSession, true);
            } else if (!LoginActionsServiceChecks.doesAuthenticationSessionFromCookieMatchOneFromToken(tokenContext, authSession, tokenAuthSessionCompoundId)) {
                logger.debugf("Authentication session in progress but no authentication session ID was found in action token %s, restarting.", (Object)token.getId());
                authenticationSessionManager.removeAuthenticationSession(this.realm, authSession, false);
                authSession = handler.startFreshAuthenticationSession(token, tokenContext);
                tokenContext.setAuthenticationSession(authSession, true);
                this.processLocaleParam(authSession);
            }
            sessionContext.setAuthenticationSession(authSession);
            this.initLoginEvent(authSession);
            this.event.event(handler.eventType());
            LoginActionsServiceChecks.checkIsUserValid(token, tokenContext, this.event);
            LoginActionsServiceChecks.checkIsClientValid(token, tokenContext);
            sessionContext.setClient(authSession.getClient());
            TokenVerifier.createWithoutSignature((JsonWebToken)token).withChecks(handler.getVerifiers(tokenContext)).verify();
            authSession = tokenContext.getAuthenticationSession();
            this.event = tokenContext.getEvent();
            this.event.event(handler.eventType());
            if (!handler.canUseTokenRepeatedly(token, tokenContext)) {
                LoginActionsServiceChecks.checkTokenWasNotUsedYet(token, tokenContext);
                authSession.setAuthNote("INVALIDATE_ACTION_TOKEN", ((SingleUseObjectKeyModel)token).serializeKey());
            }
            authSession.setAuthNote("ACTION_TOKEN_USER", ((SingleUseObjectKeyModel)token).getUserId());
            authSession.setAuthNote("key", tokenString);
            return handler.handleToken(token, tokenContext);
        }
        catch (ExplainedTokenVerificationException ex) {
            return this.handleActionTokenVerificationException(tokenContext, (VerificationException)((Object)ex), ex.getErrorEvent(), ex.getMessage());
        }
        catch (LoginActionsServiceException ex) {
            Response response = ex.getResponse();
            return response == null ? this.handleActionTokenVerificationException(tokenContext, ex, eventError, defaultErrorMessage) : response;
        }
        catch (VerificationException ex) {
            return this.handleActionTokenVerificationException(tokenContext, ex, eventError, defaultErrorMessage);
        }
    }

    private Response processFlowFromPath(String flowPath, AuthenticationSessionModel authSession, String errorMessage) {
        if (AUTHENTICATE_PATH.equals(flowPath)) {
            return this.processAuthentication(false, null, authSession, errorMessage);
        }
        if (REGISTRATION_PATH.equals(flowPath)) {
            return this.processRegistration(false, null, authSession, errorMessage);
        }
        if (RESET_CREDENTIALS_PATH.equals(flowPath)) {
            return this.processResetCredentials(false, null, authSession, errorMessage);
        }
        return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, errorMessage == null ? "invalidRequestMessage" : errorMessage, new Object[0]);
    }

    private <T extends JsonWebToken> ActionTokenHandler<T> resolveActionTokenHandler(String actionId) throws VerificationException {
        if (actionId == null) {
            throw new VerificationException("Action token operation not set");
        }
        ActionTokenHandler handler = (ActionTokenHandler)this.session.getProvider(ActionTokenHandler.class, actionId);
        if (handler == null) {
            throw new VerificationException("Invalid action token operation");
        }
        return handler;
    }

    private Response handleActionTokenVerificationException(ActionTokenContext<?> tokenContext, VerificationException ex, String eventError, String errorMessage) {
        if (tokenContext != null && tokenContext.getAuthenticationSession() != null) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, tokenContext.getAuthenticationSession(), true);
        }
        this.event.detail("reason", ex == null ? "<unknown>" : ex.getMessage()).error(eventError == null ? "invalid_code" : eventError);
        return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, errorMessage == null ? "invalidCodeMessage" : errorMessage, new Object[0]);
    }

    protected Response processResetCredentials(boolean actionRequest, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        ResetCredentialsActionTokenHandler.ResetCredsAuthenticationProcessor authProcessor = new ResetCredentialsActionTokenHandler.ResetCredsAuthenticationProcessor();
        return this.processFlow(actionRequest, execution, authSession, RESET_CREDENTIALS_PATH, this.realm.getResetCredentialsFlow(), errorMessage, authProcessor);
    }

    protected Response processRegistration(boolean action, String execution, AuthenticationSessionModel authSession, String errorMessage) {
        return this.processFlow(action, execution, authSession, REGISTRATION_PATH, this.realm.getRegistrationFlow(), errorMessage, new AuthenticationProcessor());
    }

    @Path(value="registration")
    @GET
    public Response registerPage(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.registerRequest(authSessionId, code, execution, clientId, tabId, clientData);
    }

    @Path(value="registration")
    @POST
    public Response processRegister(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId, @QueryParam(value="token") String tokenString) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && tokenString != null) {
            this.preHandleActionToken(tokenString);
        }
        return this.registerRequest(authSessionId, code, execution, clientId, tabId, clientData);
    }

    private Response registerRequest(String authSessionId, String code, String execution, String clientId, String tabId, String clientData) {
        this.event.event(EventType.REGISTER);
        if (!Organizations.isRegistrationAllowed(this.session, this.realm)) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "registrationNotAllowedMessage", new Object[0]);
        }
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, clientData, REGISTRATION_PATH);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.processLocaleParam(authSession);
        AuthenticationManager.expireIdentityCookie(this.session);
        return this.processRegistration(checks.isActionRequest(), execution, authSession, null);
    }

    @Path(value="first-broker-login")
    @GET
    public Response firstBrokerLoginGet(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, clientData, FIRST_BROKER_LOGIN_PATH);
    }

    @Path(value="first-broker-login")
    @POST
    public Response firstBrokerLoginPost(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, clientData, FIRST_BROKER_LOGIN_PATH);
    }

    @Path(value="post-broker-login")
    @GET
    public Response postBrokerLoginGet(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, clientData, POST_BROKER_LOGIN_PATH);
    }

    @Path(value="post-broker-login")
    @POST
    public Response postBrokerLoginPost(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String execution, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.brokerLoginFlow(authSessionId, code, execution, clientId, tabId, clientData, POST_BROKER_LOGIN_PATH);
    }

    protected Response brokerLoginFlow(String authSessionId, String code, String execution, String clientId, String tabId, String clientData, String flowPath) {
        String flowId;
        final boolean firstBrokerLogin = flowPath.equals(FIRST_BROKER_LOGIN_PATH);
        EventType eventType = firstBrokerLogin ? EventType.IDENTITY_PROVIDER_FIRST_LOGIN : EventType.IDENTITY_PROVIDER_POST_LOGIN;
        this.event.event(eventType);
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, execution, clientId, tabId, clientData, flowPath);
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            this.event.error("Failed to verify login action");
            return checks.getResponse();
        }
        this.event.detail("code_id", code);
        final AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.processLocaleParam(authSession);
        String noteKey = firstBrokerLogin ? "BROKERED_CONTEXT" : "PBL_BROKERED_IDENTITY_CONTEXT";
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, noteKey);
        if (serializedCtx == null) {
            ServicesLogger.LOGGER.notFoundSerializedCtxInClientSession(noteKey);
            String message = "Not found serialized context in authenticationSession.";
            this.event.error(message);
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, message, new Object[0]));
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(this.session, authSession);
        final String identityProviderAlias = brokerContext.getIdpConfig().getAlias();
        if (firstBrokerLogin) {
            flowId = brokerContext.getIdpConfig().getFirstBrokerLoginFlowId();
            if (flowId == null) {
                flowId = this.realm.getFirstBrokerLoginFlow().getId();
            }
        } else {
            flowId = brokerContext.getIdpConfig().getPostBrokerLoginFlowId();
        }
        if (flowId == null) {
            ServicesLogger.LOGGER.flowNotConfigForIDP(identityProviderAlias);
            String message = "Flow not configured for identity provider";
            this.event.error(message);
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, message, new Object[0]));
        }
        AuthenticationFlowModel brokerLoginFlow = this.realm.getAuthenticationFlowById(flowId);
        if (brokerLoginFlow == null) {
            ServicesLogger.LOGGER.flowNotFoundForIDP(flowId, identityProviderAlias);
            String message = "Flow not found for identity provider";
            this.event.error(message);
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, message, new Object[0]));
        }
        this.event.detail("identity_provider", identityProviderAlias).detail("identity_provider_identity", brokerContext.getUsername());
        this.event.success();
        AuthenticationProcessor processor = new AuthenticationProcessor(){

            @Override
            public Response authenticateOnly() throws AuthenticationFlowException {
                Response challenge = super.authenticateOnly();
                if (challenge != null && "true".equals(this.authenticationSession.getAuthNote("forwarded.passive.login"))) {
                    logger.errorf("Challenge encountered when executing %s flow. Auth requests with prompt=none are incompatible with challenges", (Object)this.flowPath);
                    LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, authSession.getProtocol());
                    protocol.setRealm(this.realm).setHttpHeaders(LoginActionsService.this.headers).setUriInfo((UriInfo)this.session.getContext().getUri()).setEventBuilder(this.event);
                    return protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED, null);
                }
                return challenge;
            }

            @Override
            protected Response authenticationComplete() {
                if (firstBrokerLogin) {
                    authSession.setAuthNote("FIRST_BROKER_LOGIN_SUCCESS", identityProviderAlias);
                } else {
                    String authStateNoteKey = "PBL_AUTH_STATE." + identityProviderAlias;
                    authSession.setAuthNote(authStateNoteKey, "true");
                }
                return LoginActionsService.this.redirectToAfterBrokerLoginEndpoint(authSession, firstBrokerLogin);
            }
        };
        this.configureOrganization(brokerContext);
        return this.processFlow(checks.isActionRequest(), execution, authSession, flowPath, brokerLoginFlow, null, processor);
    }

    private void configureOrganization(BrokeredIdentityContext brokerContext) {
        String organizationId;
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && (organizationId = brokerContext.getIdpConfig().getOrganizationId()) != null) {
            OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
            this.session.getContext().setOrganization(provider.getById(organizationId));
            this.session.setAttribute(BrokeredIdentityContext.class.getName(), (Object)brokerContext);
        }
    }

    private Response redirectToAfterBrokerLoginEndpoint(AuthenticationSessionModel authSession, boolean firstBrokerLogin) {
        return LoginActionsService.redirectToAfterBrokerLoginEndpoint(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), authSession, firstBrokerLogin);
    }

    public static Response redirectToAfterBrokerLoginEndpoint(KeycloakSession session, RealmModel realm, UriInfo uriInfo, AuthenticationSessionModel authSession, boolean firstBrokerLogin) {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
        authSession.getParentSession().setTimestamp(Time.currentTime());
        String clientId = authSession.getClient().getClientId();
        String tabId = authSession.getTabId();
        String clientData = AuthenticationProcessor.getClientData(session, authSession);
        URI redirect = firstBrokerLogin ? Urls.identityProviderAfterFirstBrokerLogin(uriInfo.getBaseUri(), realm.getName(), accessCode.getOrGenerateCode(), clientId, tabId, clientData) : Urls.identityProviderAfterPostBrokerLogin(uriInfo.getBaseUri(), realm.getName(), accessCode.getOrGenerateCode(), clientId, tabId, clientData);
        logger.debugf("Redirecting to '%s' ", (Object)redirect);
        return Response.status((int)302).location(redirect).build();
    }

    @Path(value="consent")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processConsent() {
        MultivaluedMap formData = this.request.getDecodedFormParameters();
        this.event.event(EventType.LOGIN);
        String code = (String)formData.getFirst((Object)SESSION_CODE);
        String clientId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"client_id");
        String tabId = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"tab_id");
        String clientData = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"client_data");
        SessionCodeChecks checks = this.checksForCode(null, code, null, clientId, tabId, clientData, REQUIRED_ACTION);
        if (!checks.verifyRequiredAction(CommonClientSessionModel.Action.OAUTH_GRANT.name())) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.initLoginEvent(authSession);
        UserModel user = authSession.getAuthenticatedUser();
        ClientModel client = authSession.getClient();
        if (formData.containsKey((Object)"cancel")) {
            LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, authSession.getProtocol());
            protocol.setRealm(this.realm).setHttpHeaders(this.headers).setUriInfo((UriInfo)this.session.getContext().getUri()).setEventBuilder(this.event);
            Response response = protocol.sendError(authSession, LoginProtocol.Error.CONSENT_DENIED, null);
            this.event.error("rejected_by_user");
            return response;
        }
        UserConsentModel grantedConsent = UserConsentManager.getConsentByClient(this.session, this.realm, user, client.getId());
        if (grantedConsent == null) {
            grantedConsent = new UserConsentModel(client);
            UserConsentManager.addConsent(this.session, this.realm, user, grantedConsent);
        }
        boolean updateConsentRequired = false;
        for (String clientScopeId : authSession.getClientScopes()) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)this.realm, (ClientModel)client, (String)clientScopeId);
            if (clientScope != null) {
                if (grantedConsent.isClientScopeGranted(clientScope) || !clientScope.isDisplayOnConsentScreen()) continue;
                grantedConsent.addGrantedClientScope(clientScope);
                updateConsentRequired = true;
                continue;
            }
            logger.warnf("Client scope or client with ID '%s' not found", (Object)clientScopeId);
        }
        if (updateConsentRequired) {
            UserConsentManager.updateConsent(this.session, this.realm, user, grantedConsent);
        }
        this.event.detail("consent", "consent_granted");
        this.event.success();
        ClientSessionContext clientSessionCtx = AuthenticationProcessor.attachSession(authSession, null, this.session, this.realm, this.clientConnection, this.event);
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, this.realm, clientSessionCtx.getClientSession().getUserSession(), clientSessionCtx, this.request, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.event, authSession);
    }

    private void initLoginEvent(AuthenticationSessionModel authSession) {
        String rememberMe;
        String attemptedUsername;
        String responseType = authSession.getClientNote("response_type");
        if (responseType == null) {
            responseType = "code";
        }
        String respMode = authSession.getClientNote("response_mode");
        OIDCResponseMode responseMode = OIDCResponseMode.parse(respMode, OIDCResponseType.parse(responseType));
        this.event.event(EventType.LOGIN).client(authSession.getClient()).detail("code_id", authSession.getParentSession().getId()).detail("redirect_uri", authSession.getRedirectUri()).detail("auth_method", authSession.getProtocol()).detail("response_type", responseType).detail("response_mode", responseMode.toString().toLowerCase());
        UserModel authenticatedUser = authSession.getAuthenticatedUser();
        if (authenticatedUser != null) {
            this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername());
        }
        if ((attemptedUsername = authSession.getAuthNote("ATTEMPTED_USERNAME")) != null) {
            this.event.detail("username", attemptedUsername);
        }
        if ((rememberMe = authSession.getAuthNote("remember_me")) == null || !rememberMe.equalsIgnoreCase("true")) {
            rememberMe = "false";
        }
        this.event.detail("remember_me", rememberMe);
        Map userSessionNotes = authSession.getUserSessionNotes();
        String identityProvider = (String)userSessionNotes.get("identity_provider");
        if (identityProvider != null) {
            this.event.detail("identity_provider", identityProvider).detail("identity_provider_identity", (String)userSessionNotes.get("identity_provider_identity"));
        }
    }

    @Path(value="required-action")
    @POST
    public Response requiredActionPOST(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String action, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.processRequireAction(authSessionId, code, action, clientId, tabId, clientData);
    }

    @Path(value="required-action")
    @GET
    public Response requiredActionGET(@QueryParam(value="auth_session_id") String authSessionId, @QueryParam(value="session_code") String code, @QueryParam(value="execution") String action, @QueryParam(value="client_id") String clientId, @QueryParam(value="client_data") String clientData, @QueryParam(value="tab_id") String tabId) {
        return this.processRequireAction(authSessionId, code, action, clientId, tabId, clientData);
    }

    private Response processRequireAction(String authSessionId, String code, String action, String clientId, String tabId, String clientData) {
        Response response;
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        SessionCodeChecks checks = this.checksForCode(authSessionId, code, action, clientId, tabId, clientData, REQUIRED_ACTION);
        if (!checks.verifyRequiredAction(action)) {
            return checks.getResponse();
        }
        AuthenticationSessionModel authSession = checks.getAuthenticationSession();
        this.processLocaleParam(authSession);
        if (!checks.isActionRequest()) {
            this.initLoginEvent(authSession);
            this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
            return AuthenticationManager.nextActionAfterAuthentication(this.session, authSession, this.clientConnection, this.request, (UriInfo)this.session.getContext().getUri(), this.event);
        }
        this.initLoginEvent(authSession);
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        this.event.detail("custom_required_action", action);
        RequiredActionFactory factory = (RequiredActionFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, DefaultRequiredActions.getDefaultRequiredActionCaseInsensitively((String)action));
        if (factory == null) {
            ServicesLogger.LOGGER.actionProviderNull();
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "invalidCodeMessage", new Object[0]));
        }
        RequiredActionContextResult context = new RequiredActionContextResult(authSession, this.realm, this.event, this.session, this.request, authSession.getAuthenticatedUser(), factory){

            @Override
            public void ignore() {
                throw new RuntimeException("Cannot call ignore within processAction()");
            }
        };
        RequiredActionProvider provider = null;
        try {
            provider = AuthenticationManager.createRequiredAction(context);
        }
        catch (AuthenticationFlowException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw new WebApplicationException(ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "displayUnsupported", new Object[0]));
        }
        if (this.isCancelAppInitiatedAction(factory.getId(), authSession, context)) {
            provider.initiatedActionCanceled(this.session, authSession);
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.CANCELLED, authSession);
            context.success();
        } else {
            provider.processAction((RequiredActionContext)context);
        }
        if (action != null) {
            authSession.setAuthNote("last.processed.execution", action);
        }
        if (context.getStatus() == RequiredActionContext.Status.SUCCESS) {
            this.event.clone().success();
            this.initLoginEvent(authSession);
            this.event.event(EventType.LOGIN);
            authSession.removeRequiredAction(factory.getId());
            authSession.getAuthenticatedUser().removeRequiredAction(factory.getId());
            authSession.removeAuthNote("current.authentication.execution");
            AuthenticationManager.setKcActionStatus(factory.getId(), RequiredActionContext.KcActionStatus.SUCCESS, authSession);
            response = AuthenticationManager.nextActionAfterAuthentication(this.session, authSession, this.clientConnection, this.request, (UriInfo)this.session.getContext().getUri(), this.event);
        } else if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
            response = context.getChallenge();
        } else if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
            response = this.interruptionResponse(context, authSession, action, LoginProtocol.Error.CONSENT_DENIED);
        } else {
            throw new RuntimeException("Unreachable");
        }
        return BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, response, true, this.request);
    }

    private Response interruptionResponse(RequiredActionContextResult context, AuthenticationSessionModel authSession, String action, LoginProtocol.Error error) {
        LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, authSession.getProtocol());
        protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(this.event);
        this.event.detail("custom_required_action", action);
        this.event.error("rejected_by_user");
        return protocol.sendError(authSession, error, context.getErrorMessage());
    }

    private boolean isCancelAppInitiatedAction(String providerId, AuthenticationSessionModel authSession, RequiredActionContextResult context) {
        if (providerId.equals(authSession.getClientNote("kc_action_executing")) && !Boolean.TRUE.toString().equals(authSession.getClientNote("kc_action_enforced"))) {
            MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
            boolean userRequestedCancelAIA = formData.getFirst((Object)CANCEL_AIA) != null;
            return userRequestedCancelAIA;
        }
        return false;
    }

    public Response preHandleActionToken(String tokenString) {
        return this.handleActionToken(tokenString, null, null, null, null, (rec$, x$0, x$1) -> ((ActionTokenHandler)rec$).preHandleToken((JsonWebToken)x$0, x$1));
    }
}

