/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;

public class IOUtils {
    private static final Method SUPPRESS_METHOD;

    public static void close(Closeable ... objects) throws IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) throws IOException {
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final void addSuppressed(Throwable exception, Throwable suppressed) {
        if (SUPPRESS_METHOD != null && exception != null && suppressed != null) {
            try {
                SUPPRESS_METHOD.invoke((Object)exception, suppressed);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    static {
        Method m;
        try {
            m = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (Exception e) {
            m = null;
        }
        SUPPRESS_METHOD = m;
    }
}

