# typed: strict

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/rbi/prism/node.rbi.erb
if you are looking to modify the template
=end

class Prism::Node
  abstract!

  sig { returns(Prism::Source) }
  def source; end

  sig { returns(Integer) }
  def node_id; end

  sig { returns(Prism::Location) }
  def location; end

  sig{ returns(Integer) }
  def flags; end

  sig { returns(T::Boolean) }
  def newline?; end

  sig { returns(T::Boolean) }
  def static_literal?; end

  sig { returns(Integer) }
  def start_offset; end

  sig { returns(Integer) }
  def end_offset; end

  sig { returns(T::Array[String]) }
  def source_lines; end

  sig { returns(T::Array[String]) }
  def script_lines; end

  sig { returns(String) }
  def slice; end

  sig { returns(String) }
  def slice_lines; end

  sig { params(q: T.untyped).void }
  def pretty_print(q); end

  sig { returns(String) }
  def to_dot; end

  sig { params(line: Integer, column: Integer).returns(T::Array[Prism::Node]) }
  def tunnel(line, column); end

  sig { params(block: T.proc.params(node: Prism::Node).returns(T::Boolean)).returns(T.nilable(Prism::Node)) }
  def breadth_first_search(&block); end

  sig { abstract.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { abstract.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { abstract.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { abstract.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { abstract.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { abstract.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { abstract.returns(Symbol) }
  def type; end

  sig { abstract.returns(String) }
  def inspect; end
end

# Represents the use of the `alias` keyword to alias a global variable.
#
#     alias $foo $bar
#     ^^^^^^^^^^^^^^^
class Prism::AliasGlobalVariableNode < Prism::Node
  sig { returns(T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)) }
  def new_name; end

  sig { returns(T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode)) }
  def old_name; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode), old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode), keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, new_name, old_name, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode), old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode), keyword_loc: Prism::Location).returns(Prism::AliasGlobalVariableNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, new_name: self.new_name, old_name: self.old_name, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `alias` keyword to alias a method.
#
#     alias foo bar
#     ^^^^^^^^^^^^^
class Prism::AliasMethodNode < Prism::Node
  sig { returns(T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)) }
  def new_name; end

  sig { returns(T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode)) }
  def old_name; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode), old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode), keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, new_name, old_name, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode), old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode), keyword_loc: Prism::Location).returns(Prism::AliasMethodNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, new_name: self.new_name, old_name: self.old_name, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an alternation pattern in pattern matching.
#
#     foo => bar | baz
#            ^^^^^^^^^
class Prism::AlternationPatternNode < Prism::Node
  sig { returns(Prism::Node) }
  def left; end

  sig { returns(Prism::Node) }
  def right; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).returns(Prism::AlternationPatternNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, left: self.left, right: self.right, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&` operator or the `and` keyword.
#
#     left and right
#     ^^^^^^^^^^^^^^
class Prism::AndNode < Prism::Node
  sig { returns(Prism::Node) }
  def left; end

  sig { returns(Prism::Node) }
  def right; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).returns(Prism::AndNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, left: self.left, right: self.right, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a set of arguments to a method or a keyword.
#
#     return foo, bar, baz
#            ^^^^^^^^^^^^^
class Prism::ArgumentsNode < Prism::Node
  sig { returns(T::Boolean) }
  def contains_forwarding?; end

  sig { returns(T::Boolean) }
  def contains_keywords?; end

  sig { returns(T::Boolean) }
  def contains_keyword_splat?; end

  sig { returns(T::Boolean) }
  def contains_splat?; end

  sig { returns(T::Boolean) }
  def contains_multiple_splats?; end

  sig { returns(T::Array[Prism::Node]) }
  def arguments; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, arguments: T::Array[Prism::Node]).void }
  def initialize(source, node_id, location, flags, arguments); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, arguments: T::Array[Prism::Node]).returns(Prism::ArgumentsNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, arguments: self.arguments); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an array literal. This can be a regular array using brackets or a special array using % like %w or %i.
#
#     [1, 2, 3]
#     ^^^^^^^^^
class Prism::ArrayNode < Prism::Node
  sig { returns(T::Boolean) }
  def contains_splat?; end

  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, elements: T::Array[Prism::Node], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, elements, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, elements: T::Array[Prism::Node], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::ArrayNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, elements: self.elements, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an array pattern in pattern matching.
#
#     foo in 1, 2
#     ^^^^^^^^^^^
#
#     foo in [1, 2]
#     ^^^^^^^^^^^^^
#
#     foo in *bar
#     ^^^^^^^^^^^
#
#     foo in Bar[]
#     ^^^^^^^^^^^^
#
#     foo in Bar[1, 2, 3]
#     ^^^^^^^^^^^^^^^^^^^
class Prism::ArrayPatternNode < Prism::Node
  sig { returns(T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode))) }
  def constant; end

  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  sig { returns(T::Array[Prism::Node]) }
  def posts; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)), requireds: T::Array[Prism::Node], rest: T.nilable(Prism::Node), posts: T::Array[Prism::Node], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, constant, requireds, rest, posts, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)), requireds: T::Array[Prism::Node], rest: T.nilable(Prism::Node), posts: T::Array[Prism::Node], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::ArrayPatternNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, constant: self.constant, requireds: self.requireds, rest: self.rest, posts: self.posts, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a hash key/value pair.
#
#     { a => b }
#       ^^^^^^
class Prism::AssocNode < Prism::Node
  sig { returns(Prism::Node) }
  def key; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, key: Prism::Node, value: Prism::Node, operator_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, key, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, key: Prism::Node, value: Prism::Node, operator_loc: T.nilable(Prism::Location)).returns(Prism::AssocNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, key: self.key, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a splat in a hash literal.
#
#     { **foo }
#       ^^^^^
class Prism::AssocSplatNode < Prism::Node
  sig { returns(T.nilable(Prism::Node)) }
  def value; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: T.nilable(Prism::Node), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::AssocSplatNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents reading a reference to a field in the previous match.
#
#     $'
#     ^^
class Prism::BackReferenceReadNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::BackReferenceReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a begin statement.
#
#     begin
#       foo
#     end
#     ^^^^^
class Prism::BeginNode < Prism::Node
  sig { returns(T.nilable(Prism::Location)) }
  def begin_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(T.nilable(Prism::RescueNode)) }
  def rescue_clause; end

  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  sig { returns(T.nilable(Prism::EnsureNode)) }
  def ensure_clause; end

  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, begin_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), rescue_clause: T.nilable(Prism::RescueNode), else_clause: T.nilable(Prism::ElseNode), ensure_clause: T.nilable(Prism::EnsureNode), end_keyword_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, begin_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), rescue_clause: T.nilable(Prism::RescueNode), else_clause: T.nilable(Prism::ElseNode), ensure_clause: T.nilable(Prism::EnsureNode), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::BeginNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, begin_keyword_loc: self.begin_keyword_loc, statements: self.statements, rescue_clause: self.rescue_clause, else_clause: self.else_clause, ensure_clause: self.ensure_clause, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def begin_keyword; end

  sig { returns(T.nilable(String)) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a block argument using `&`.
#
#     bar(&args)
#     ^^^^^^^^^^
class Prism::BlockArgumentNode < Prism::Node
  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, expression: T.nilable(Prism::Node), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, expression, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, expression: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::BlockArgumentNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, expression: self.expression, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a block local variable.
#
#     a { |; b| }
#            ^
class Prism::BlockLocalVariableNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::BlockLocalVariableNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a block of ruby code.
#
#     [1, 2, 3].each { |i| puts x }
#                    ^^^^^^^^^^^^^^
class Prism::BlockNode < Prism::Node
  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode))) }
  def parameters; end

  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), opening_loc: Prism::Location, closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, locals, parameters, body, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::BlockNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, locals: self.locals, parameters: self.parameters, body: self.body, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a block parameter of a method, block, or lambda definition.
#
#     def a(&b)
#           ^^
#     end
class Prism::BlockParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(T.nilable(Symbol)) }
  def name; end

  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).returns(Prism::BlockParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a block's parameters declaration.
#
#     -> (a, b = 1; local) { }
#        ^^^^^^^^^^^^^^^^^
#
#     foo do |a, b = 1; local|
#            ^^^^^^^^^^^^^^^^^
#     end
class Prism::BlockParametersNode < Prism::Node
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  sig { returns(T::Array[Prism::BlockLocalVariableNode]) }
  def locals; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, parameters: T.nilable(Prism::ParametersNode), locals: T::Array[Prism::BlockLocalVariableNode], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, parameters, locals, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, parameters: T.nilable(Prism::ParametersNode), locals: T::Array[Prism::BlockLocalVariableNode], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::BlockParametersNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, parameters: self.parameters, locals: self.locals, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `break` keyword.
#
#     break foo
#     ^^^^^^^^^
class Prism::BreakNode < Prism::Node
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, arguments: T.nilable(Prism::ArgumentsNode), keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, arguments, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, arguments: T.nilable(Prism::ArgumentsNode), keyword_loc: Prism::Location).returns(Prism::BreakNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, arguments: self.arguments, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator on a call.
#
#     foo.bar &&= value
#     ^^^^^^^^^^^^^^^^^
class Prism::CallAndWriteNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  sig { returns(Symbol) }
  def read_name; end

  sig { returns(Symbol) }
  def write_name; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::CallAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, message_loc: self.message_loc, read_name: self.read_name, write_name: self.write_name, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(T.nilable(String)) }
  def message; end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a method call, in all of the various forms that can take.
#
#     foo
#     ^^^
#
#     foo()
#     ^^^^^
#
#     +foo
#     ^^^^
#
#     foo + bar
#     ^^^^^^^^^
#
#     foo.bar
#     ^^^^^^^
#
#     foo&.bar
#     ^^^^^^^^
class Prism::CallNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { returns(T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))) }
  def block; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), name: Symbol, message_loc: T.nilable(Prism::Location), opening_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), closing_loc: T.nilable(Prism::Location), block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), name: Symbol, message_loc: T.nilable(Prism::Location), opening_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), closing_loc: T.nilable(Prism::Location), block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))).returns(Prism::CallNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, name: self.name, message_loc: self.message_loc, opening_loc: self.opening_loc, arguments: self.arguments, closing_loc: self.closing_loc, block: self.block); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(T.nilable(String)) }
  def message; end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of an assignment operator on a call.
#
#     foo.bar += baz
#     ^^^^^^^^^^^^^^
class Prism::CallOperatorWriteNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  sig { returns(Symbol) }
  def read_name; end

  sig { returns(Symbol) }
  def write_name; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, binary_operator: Symbol, binary_operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, binary_operator, binary_operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, binary_operator: Symbol, binary_operator_loc: Prism::Location, value: Prism::Node).returns(Prism::CallOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, message_loc: self.message_loc, read_name: self.read_name, write_name: self.write_name, binary_operator: self.binary_operator, binary_operator_loc: self.binary_operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(T.nilable(String)) }
  def message; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator on a call.
#
#     foo.bar ||= value
#     ^^^^^^^^^^^^^^^^^
class Prism::CallOrWriteNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  sig { returns(Symbol) }
  def read_name; end

  sig { returns(Symbol) }
  def write_name; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::CallOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, message_loc: self.message_loc, read_name: self.read_name, write_name: self.write_name, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(T.nilable(String)) }
  def message; end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a method call.
#
#     foo.bar, = 1
#     ^^^^^^^
#
#     begin
#     rescue => foo.bar
#               ^^^^^^^
#     end
#
#     for foo.bar in baz do end
#         ^^^^^^^
class Prism::CallTargetNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(Prism::Node) }
  def receiver; end

  sig { returns(Prism::Location) }
  def call_operator_loc; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def message_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: Prism::Node, call_operator_loc: Prism::Location, name: Symbol, message_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: Prism::Node, call_operator_loc: Prism::Location, name: Symbol, message_loc: Prism::Location).returns(Prism::CallTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, name: self.name, message_loc: self.message_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def call_operator; end

  sig { returns(String) }
  def message; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a local variable in pattern matching.
#
#     foo => [bar => baz]
#            ^^^^^^^^^^^^
class Prism::CapturePatternNode < Prism::Node
  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::LocalVariableTargetNode) }
  def target; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, target: Prism::LocalVariableTargetNode, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, value, target, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, target: Prism::LocalVariableTargetNode, operator_loc: Prism::Location).returns(Prism::CapturePatternNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value, target: self.target, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of a case statement for pattern matching.
#
#     case true
#     in false
#     end
#     ^^^^^^^^^
class Prism::CaseMatchNode < Prism::Node
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  sig { returns(T::Array[Prism::InNode]) }
  def conditions; end

  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, predicate: T.nilable(Prism::Node), conditions: T::Array[Prism::InNode], else_clause: T.nilable(Prism::ElseNode), case_keyword_loc: Prism::Location, end_keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, predicate: T.nilable(Prism::Node), conditions: T::Array[Prism::InNode], else_clause: T.nilable(Prism::ElseNode), case_keyword_loc: Prism::Location, end_keyword_loc: Prism::Location).returns(Prism::CaseMatchNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, predicate: self.predicate, conditions: self.conditions, else_clause: self.else_clause, case_keyword_loc: self.case_keyword_loc, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def case_keyword; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of a case statement.
#
#     case true
#     when false
#     end
#     ^^^^^^^^^^
class Prism::CaseNode < Prism::Node
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  sig { returns(T::Array[Prism::WhenNode]) }
  def conditions; end

  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, predicate: T.nilable(Prism::Node), conditions: T::Array[Prism::WhenNode], else_clause: T.nilable(Prism::ElseNode), case_keyword_loc: Prism::Location, end_keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, predicate: T.nilable(Prism::Node), conditions: T::Array[Prism::WhenNode], else_clause: T.nilable(Prism::ElseNode), case_keyword_loc: Prism::Location, end_keyword_loc: Prism::Location).returns(Prism::CaseNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, predicate: self.predicate, conditions: self.conditions, else_clause: self.else_clause, case_keyword_loc: self.case_keyword_loc, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def case_keyword; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a class declaration involving the `class` keyword.
#
#     class Foo end
#     ^^^^^^^^^^^^^
class Prism::ClassNode < Prism::Node
  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  sig { returns(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode)) }
  def constant_path; end

  sig { returns(T.nilable(Prism::Location)) }
  def inheritance_operator_loc; end

  sig { returns(T.nilable(Prism::Node)) }
  def superclass; end

  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], class_keyword_loc: Prism::Location, constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode), inheritance_operator_loc: T.nilable(Prism::Location), superclass: T.nilable(Prism::Node), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location, name: Symbol).void }
  def initialize(source, node_id, location, flags, locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], class_keyword_loc: Prism::Location, constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode), inheritance_operator_loc: T.nilable(Prism::Location), superclass: T.nilable(Prism::Node), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location, name: Symbol).returns(Prism::ClassNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, locals: self.locals, class_keyword_loc: self.class_keyword_loc, constant_path: self.constant_path, inheritance_operator_loc: self.inheritance_operator_loc, superclass: self.superclass, body: self.body, end_keyword_loc: self.end_keyword_loc, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def class_keyword; end

  sig { returns(T.nilable(String)) }
  def inheritance_operator; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator for assignment to a class variable.
#
#     @@target &&= value
#     ^^^^^^^^^^^^^^^^^^
class Prism::ClassVariableAndWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ClassVariableAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a class variable using an operator that isn't `=`.
#
#     @@target += value
#     ^^^^^^^^^^^^^^^^^
class Prism::ClassVariableOperatorWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).void }
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::ClassVariableOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, binary_operator_loc: self.binary_operator_loc, value: self.value, binary_operator: self.binary_operator); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator for assignment to a class variable.
#
#     @@target ||= value
#     ^^^^^^^^^^^^^^^^^^
class Prism::ClassVariableOrWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ClassVariableOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents referencing a class variable.
#
#     @@foo
#     ^^^^^
class Prism::ClassVariableReadNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ClassVariableReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a class variable in a context that doesn't have an explicit value.
#
#     @@foo, @@bar = baz
#     ^^^^^  ^^^^^
class Prism::ClassVariableTargetNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ClassVariableTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a class variable.
#
#     @@foo = 1
#     ^^^^^^^^^
class Prism::ClassVariableWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::ClassVariableWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator for assignment to a constant.
#
#     Target &&= value
#     ^^^^^^^^^^^^^^^^
class Prism::ConstantAndWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a constant using an operator that isn't `=`.
#
#     Target += value
#     ^^^^^^^^^^^^^^^
class Prism::ConstantOperatorWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).void }
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::ConstantOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, binary_operator_loc: self.binary_operator_loc, value: self.value, binary_operator: self.binary_operator); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator for assignment to a constant.
#
#     Target ||= value
#     ^^^^^^^^^^^^^^^^
class Prism::ConstantOrWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator for assignment to a constant path.
#
#     Parent::Child &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
class Prism::ConstantPathAndWriteNode < Prism::Node
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantPathAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, target: self.target, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents accessing a constant through a path of `::` operators.
#
#     Foo::Bar
#     ^^^^^^^^
class Prism::ConstantPathNode < Prism::Node
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  sig { returns(T.nilable(Symbol)) }
  def name; end

  sig { returns(Prism::Location) }
  def delimiter_loc; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, parent: T.nilable(Prism::Node), name: T.nilable(Symbol), delimiter_loc: Prism::Location, name_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, parent, name, delimiter_loc, name_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, parent: T.nilable(Prism::Node), name: T.nilable(Symbol), delimiter_loc: Prism::Location, name_loc: Prism::Location).returns(Prism::ConstantPathNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, parent: self.parent, name: self.name, delimiter_loc: self.delimiter_loc, name_loc: self.name_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def delimiter; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a constant path using an operator that isn't `=`.
#
#     Parent::Child += value
#     ^^^^^^^^^^^^^^^^^^^^^^
class Prism::ConstantPathOperatorWriteNode < Prism::Node
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).void }
  def initialize(source, node_id, location, flags, target, binary_operator_loc, value, binary_operator); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::ConstantPathOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, target: self.target, binary_operator_loc: self.binary_operator_loc, value: self.value, binary_operator: self.binary_operator); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator for assignment to a constant path.
#
#     Parent::Child ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
class Prism::ConstantPathOrWriteNode < Prism::Node
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantPathOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, target: self.target, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a constant path in a context that doesn't have an explicit value.
#
#     Foo::Foo, Bar::Bar = baz
#     ^^^^^^^^  ^^^^^^^^
class Prism::ConstantPathTargetNode < Prism::Node
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  sig { returns(T.nilable(Symbol)) }
  def name; end

  sig { returns(Prism::Location) }
  def delimiter_loc; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, parent: T.nilable(Prism::Node), name: T.nilable(Symbol), delimiter_loc: Prism::Location, name_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, parent, name, delimiter_loc, name_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, parent: T.nilable(Prism::Node), name: T.nilable(Symbol), delimiter_loc: Prism::Location, name_loc: Prism::Location).returns(Prism::ConstantPathTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, parent: self.parent, name: self.name, delimiter_loc: self.delimiter_loc, name_loc: self.name_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def delimiter; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a constant path.
#
#     ::Foo = 1
#     ^^^^^^^^^
#
#     Foo::Bar = 1
#     ^^^^^^^^^^^^
#
#     ::Foo::Bar = 1
#     ^^^^^^^^^^^^^^
class Prism::ConstantPathWriteNode < Prism::Node
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantPathWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, target: self.target, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents referencing a constant.
#
#     Foo
#     ^^^
class Prism::ConstantReadNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ConstantReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a constant in a context that doesn't have an explicit value.
#
#     Foo, Bar = baz
#     ^^^  ^^^
class Prism::ConstantTargetNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ConstantTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a constant.
#
#     Foo = 1
#     ^^^^^^^
class Prism::ConstantWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::ConstantWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a method definition.
#
#     def method
#     end
#     ^^^^^^^^^^
class Prism::DefNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(Prism::Location) }
  def def_keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def equal_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, receiver: T.nilable(Prism::Node), parameters: T.nilable(Prism::ParametersNode), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), locals: T::Array[Symbol], def_keyword_loc: Prism::Location, operator_loc: T.nilable(Prism::Location), lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location), equal_loc: T.nilable(Prism::Location), end_keyword_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, name, name_loc, receiver, parameters, body, locals, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, receiver: T.nilable(Prism::Node), parameters: T.nilable(Prism::ParametersNode), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), locals: T::Array[Symbol], def_keyword_loc: Prism::Location, operator_loc: T.nilable(Prism::Location), lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location), equal_loc: T.nilable(Prism::Location), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::DefNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, receiver: self.receiver, parameters: self.parameters, body: self.body, locals: self.locals, def_keyword_loc: self.def_keyword_loc, operator_loc: self.operator_loc, lparen_loc: self.lparen_loc, rparen_loc: self.rparen_loc, equal_loc: self.equal_loc, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def def_keyword; end

  sig { returns(T.nilable(String)) }
  def operator; end

  sig { returns(T.nilable(String)) }
  def lparen; end

  sig { returns(T.nilable(String)) }
  def rparen; end

  sig { returns(T.nilable(String)) }
  def equal; end

  sig { returns(T.nilable(String)) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `defined?` keyword.
#
#     defined?(a)
#     ^^^^^^^^^^^
class Prism::DefinedNode < Prism::Node
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, lparen_loc: T.nilable(Prism::Location), value: Prism::Node, rparen_loc: T.nilable(Prism::Location), keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, lparen_loc, value, rparen_loc, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, lparen_loc: T.nilable(Prism::Location), value: Prism::Node, rparen_loc: T.nilable(Prism::Location), keyword_loc: Prism::Location).returns(Prism::DefinedNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, lparen_loc: self.lparen_loc, value: self.value, rparen_loc: self.rparen_loc, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def lparen; end

  sig { returns(T.nilable(String)) }
  def rparen; end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an `else` clause in a `case`, `if`, or `unless` statement.
#
#     if a then b else c end
#                 ^^^^^^^^^^
class Prism::ElseNode < Prism::Node
  sig { returns(Prism::Location) }
  def else_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, else_keyword_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), end_keyword_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, else_keyword_loc, statements, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, else_keyword_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::ElseNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, else_keyword_loc: self.else_keyword_loc, statements: self.statements, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def else_keyword; end

  sig { returns(T.nilable(String)) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an interpolated set of statements.
#
#     "foo #{bar}"
#          ^^^^^^
class Prism::EmbeddedStatementsNode < Prism::Node
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, opening_loc, statements, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), closing_loc: Prism::Location).returns(Prism::EmbeddedStatementsNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, statements: self.statements, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an interpolated variable.
#
#     "foo #@bar"
#          ^^^^^
class Prism::EmbeddedVariableNode < Prism::Node
  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)) }
  def variable; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)).void }
  def initialize(source, node_id, location, flags, operator_loc, variable); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)).returns(Prism::EmbeddedVariableNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, operator_loc: self.operator_loc, variable: self.variable); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an `ensure` clause in a `begin` statement.
#
#     begin
#       foo
#     ensure
#     ^^^^^^
#       bar
#     end
class Prism::EnsureNode < Prism::Node
  sig { returns(Prism::Location) }
  def ensure_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, ensure_keyword_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), end_keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, ensure_keyword_loc, statements, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, ensure_keyword_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), end_keyword_loc: Prism::Location).returns(Prism::EnsureNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, ensure_keyword_loc: self.ensure_keyword_loc, statements: self.statements, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def ensure_keyword; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the literal `false` keyword.
#
#     false
#     ^^^^^
class Prism::FalseNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::FalseNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a find pattern in pattern matching.
#
#     foo in *bar, baz, *qux
#            ^^^^^^^^^^^^^^^
#
#     foo in [*bar, baz, *qux]
#            ^^^^^^^^^^^^^^^^^
#
#     foo in Foo(*bar, baz, *qux)
#            ^^^^^^^^^^^^^^^^^^^^
class Prism::FindPatternNode < Prism::Node
  sig { returns(T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode))) }
  def constant; end

  sig { returns(Prism::SplatNode) }
  def left; end

  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  sig { returns(T.any(Prism::SplatNode, Prism::MissingNode)) }
  def right; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)), left: Prism::SplatNode, requireds: T::Array[Prism::Node], right: T.any(Prism::SplatNode, Prism::MissingNode), opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, constant, left, requireds, right, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)), left: Prism::SplatNode, requireds: T::Array[Prism::Node], right: T.any(Prism::SplatNode, Prism::MissingNode), opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::FindPatternNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, constant: self.constant, left: self.left, requireds: self.requireds, right: self.right, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `..` or `...` operators to create flip flops.
#
#     baz if foo .. bar
#            ^^^^^^^^^^
class Prism::FlipFlopNode < Prism::Node
  sig { returns(T::Boolean) }
  def exclude_end?; end

  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: T.nilable(Prism::Node), right: T.nilable(Prism::Node), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, left: T.nilable(Prism::Node), right: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::FlipFlopNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, left: self.left, right: self.right, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a floating point number literal.
#
#     1.0
#     ^^^
class Prism::FloatNode < Prism::Node
  sig { returns(Float) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Float).void }
  def initialize(source, node_id, location, flags, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Float).returns(Prism::FloatNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `for` keyword.
#
#     for i in a end
#     ^^^^^^^^^^^^^^
class Prism::ForNode < Prism::Node
  sig { returns(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)) }
  def index; end

  sig { returns(Prism::Node) }
  def collection; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(Prism::Location) }
  def for_keyword_loc; end

  sig { returns(Prism::Location) }
  def in_keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def do_keyword_loc; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode), collection: Prism::Node, statements: T.nilable(Prism::StatementsNode), for_keyword_loc: Prism::Location, in_keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), end_keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode), collection: Prism::Node, statements: T.nilable(Prism::StatementsNode), for_keyword_loc: Prism::Location, in_keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), end_keyword_loc: Prism::Location).returns(Prism::ForNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, index: self.index, collection: self.collection, statements: self.statements, for_keyword_loc: self.for_keyword_loc, in_keyword_loc: self.in_keyword_loc, do_keyword_loc: self.do_keyword_loc, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def for_keyword; end

  sig { returns(String) }
  def in_keyword; end

  sig { returns(T.nilable(String)) }
  def do_keyword; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents forwarding all arguments to this method to another method.
#
#     def foo(...)
#       bar(...)
#           ^^^
#     end
class Prism::ForwardingArgumentsNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingArgumentsNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the forwarding parameter in a method, block, or lambda declaration.
#
#     def foo(...)
#             ^^^
#     end
class Prism::ForwardingParameterNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `super` keyword without parentheses or arguments.
#
#     super
#     ^^^^^
class Prism::ForwardingSuperNode < Prism::Node
  sig { returns(T.nilable(Prism::BlockNode)) }
  def block; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, block: T.nilable(Prism::BlockNode)).void }
  def initialize(source, node_id, location, flags, block); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, block: T.nilable(Prism::BlockNode)).returns(Prism::ForwardingSuperNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, block: self.block); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator for assignment to a global variable.
#
#     $target &&= value
#     ^^^^^^^^^^^^^^^^^
class Prism::GlobalVariableAndWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::GlobalVariableAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a global variable using an operator that isn't `=`.
#
#     $target += value
#     ^^^^^^^^^^^^^^^^
class Prism::GlobalVariableOperatorWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).void }
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::GlobalVariableOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, binary_operator_loc: self.binary_operator_loc, value: self.value, binary_operator: self.binary_operator); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator for assignment to a global variable.
#
#     $target ||= value
#     ^^^^^^^^^^^^^^^^^
class Prism::GlobalVariableOrWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::GlobalVariableOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents referencing a global variable.
#
#     $foo
#     ^^^^
class Prism::GlobalVariableReadNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::GlobalVariableReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a global variable in a context that doesn't have an explicit value.
#
#     $foo, $bar = baz
#     ^^^^  ^^^^
class Prism::GlobalVariableTargetNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::GlobalVariableTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a global variable.
#
#     $foo = 1
#     ^^^^^^^^
class Prism::GlobalVariableWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::GlobalVariableWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a hash literal.
#
#     { a => b }
#     ^^^^^^^^^^
class Prism::HashNode < Prism::Node
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]) }
  def elements; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)], closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, opening_loc, elements, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)], closing_loc: Prism::Location).returns(Prism::HashNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, elements: self.elements, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a hash pattern in pattern matching.
#
#     foo => { a: 1, b: 2 }
#            ^^^^^^^^^^^^^^
#
#     foo => { a: 1, b: 2, **c }
#            ^^^^^^^^^^^^^^^^^^^
class Prism::HashPatternNode < Prism::Node
  sig { returns(T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode))) }
  def constant; end

  sig { returns(T::Array[Prism::AssocNode]) }
  def elements; end

  sig { returns(T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode))) }
  def rest; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)), elements: T::Array[Prism::AssocNode], rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)), opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, constant, elements, rest, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)), elements: T::Array[Prism::AssocNode], rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)), opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::HashPatternNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, constant: self.constant, elements: self.elements, rest: self.rest, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `if` keyword, either in the block form or the modifier form, or a ternary expression.
#
#     bar if foo
#     ^^^^^^^^^^
#
#     if foo then bar end
#     ^^^^^^^^^^^^^^^^^^^
#
#     foo ? bar : baz
#     ^^^^^^^^^^^^^^^
class Prism::IfNode < Prism::Node
  sig { returns(T.nilable(Prism::Location)) }
  def if_keyword_loc; end

  sig { returns(Prism::Node) }
  def predicate; end

  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(T.nilable(T.any(Prism::ElseNode, Prism::IfNode))) }
  def subsequent; end

  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, if_keyword_loc: T.nilable(Prism::Location), predicate: Prism::Node, then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)), end_keyword_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, if_keyword_loc, predicate, then_keyword_loc, statements, subsequent, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, if_keyword_loc: T.nilable(Prism::Location), predicate: Prism::Node, then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::IfNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, if_keyword_loc: self.if_keyword_loc, predicate: self.predicate, then_keyword_loc: self.then_keyword_loc, statements: self.statements, subsequent: self.subsequent, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def if_keyword; end

  sig { returns(T.nilable(String)) }
  def then_keyword; end

  sig { returns(T.nilable(String)) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an imaginary number literal.
#
#     1.0i
#     ^^^^
class Prism::ImaginaryNode < Prism::Node
  sig { returns(T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)) }
  def numeric; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)).void }
  def initialize(source, node_id, location, flags, numeric); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)).returns(Prism::ImaginaryNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, numeric: self.numeric); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a node that is implicitly being added to the tree but doesn't correspond directly to a node in the source.
#
#     { foo: }
#       ^^^^
#
#     { Foo: }
#       ^^^^
#
#     foo in { bar: }
#              ^^^^
class Prism::ImplicitNode < Prism::Node
  sig { returns(T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)).void }
  def initialize(source, node_id, location, flags, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)).returns(Prism::ImplicitNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents using a trailing comma to indicate an implicit rest parameter.
#
#     foo { |bar,| }
#               ^
#
#     foo in [bar,]
#                ^
#
#     for foo, in bar do end
#            ^
#
#     foo, = bar
#        ^
class Prism::ImplicitRestNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ImplicitRestNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `in` keyword in a case statement.
#
#     case a; in b then c end
#             ^^^^^^^^^^^
class Prism::InNode < Prism::Node
  sig { returns(Prism::Node) }
  def pattern; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(Prism::Location) }
  def in_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def then_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, pattern: Prism::Node, statements: T.nilable(Prism::StatementsNode), in_loc: Prism::Location, then_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, pattern, statements, in_loc, then_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, pattern: Prism::Node, statements: T.nilable(Prism::StatementsNode), in_loc: Prism::Location, then_loc: T.nilable(Prism::Location)).returns(Prism::InNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, pattern: self.pattern, statements: self.statements, in_loc: self.in_loc, then_loc: self.then_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def in; end

  sig { returns(T.nilable(String)) }
  def then; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator on a call to the `[]` method.
#
#     foo.bar[baz] &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^
class Prism::IndexAndWriteNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), operator_loc: Prism::Location, value: Prism::Node).returns(Prism::IndexAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, opening_loc: self.opening_loc, arguments: self.arguments, closing_loc: self.closing_loc, block: self.block, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of an assignment operator on a call to `[]`.
#
#     foo.bar[baz] += value
#     ^^^^^^^^^^^^^^^^^^^^^
class Prism::IndexOperatorWriteNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), binary_operator: Symbol, binary_operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, binary_operator, binary_operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), binary_operator: Symbol, binary_operator_loc: Prism::Location, value: Prism::Node).returns(Prism::IndexOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, opening_loc: self.opening_loc, arguments: self.arguments, closing_loc: self.closing_loc, block: self.block, binary_operator: self.binary_operator, binary_operator_loc: self.binary_operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator on a call to `[]`.
#
#     foo.bar[baz] ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^
class Prism::IndexOrWriteNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), operator_loc: Prism::Location, value: Prism::Node).returns(Prism::IndexOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, call_operator_loc: self.call_operator_loc, opening_loc: self.opening_loc, arguments: self.arguments, closing_loc: self.closing_loc, block: self.block, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def call_operator; end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to an index.
#
#     foo[bar], = 1
#     ^^^^^^^^
#
#     begin
#     rescue => foo[bar]
#               ^^^^^^^^
#     end
#
#     for foo[bar] in baz do end
#         ^^^^^^^^
class Prism::IndexTargetNode < Prism::Node
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  sig { returns(T::Boolean) }
  def variable_call?; end

  sig { returns(T::Boolean) }
  def attribute_write?; end

  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  sig { returns(Prism::Node) }
  def receiver; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: Prism::Node, opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode)).void }
  def initialize(source, node_id, location, flags, receiver, opening_loc, arguments, closing_loc, block); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, receiver: Prism::Node, opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode)).returns(Prism::IndexTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, receiver: self.receiver, opening_loc: self.opening_loc, arguments: self.arguments, closing_loc: self.closing_loc, block: self.block); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator for assignment to an instance variable.
#
#     @target &&= value
#     ^^^^^^^^^^^^^^^^^
class Prism::InstanceVariableAndWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::InstanceVariableAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to an instance variable using an operator that isn't `=`.
#
#     @target += value
#     ^^^^^^^^^^^^^^^^
class Prism::InstanceVariableOperatorWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).void }
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::InstanceVariableOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, binary_operator_loc: self.binary_operator_loc, value: self.value, binary_operator: self.binary_operator); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator for assignment to an instance variable.
#
#     @target ||= value
#     ^^^^^^^^^^^^^^^^^
class Prism::InstanceVariableOrWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::InstanceVariableOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents referencing an instance variable.
#
#     @foo
#     ^^^^
class Prism::InstanceVariableReadNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::InstanceVariableReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to an instance variable in a context that doesn't have an explicit value.
#
#     @foo, @bar = baz
#     ^^^^  ^^^^
class Prism::InstanceVariableTargetNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::InstanceVariableTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to an instance variable.
#
#     @foo = 1
#     ^^^^^^^^
class Prism::InstanceVariableWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::InstanceVariableWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an integer number literal.
#
#     1
#     ^
class Prism::IntegerNode < Prism::Node
  sig { returns(T::Boolean) }
  def binary?; end

  sig { returns(T::Boolean) }
  def decimal?; end

  sig { returns(T::Boolean) }
  def octal?; end

  sig { returns(T::Boolean) }
  def hexadecimal?; end

  sig { returns(Integer) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Integer).void }
  def initialize(source, node_id, location, flags, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Integer).returns(Prism::IntegerNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a regular expression literal that contains interpolation that is being used in the predicate of a conditional to implicitly match against the last line read by an IO object.
#
#     if /foo #{bar} baz/ then end
#        ^^^^^^^^^^^^^^^^
class Prism::InterpolatedMatchLastLineNode < Prism::Node
  sig { returns(T::Boolean) }
  def ignore_case?; end

  sig { returns(T::Boolean) }
  def extended?; end

  sig { returns(T::Boolean) }
  def multi_line?; end

  sig { returns(T::Boolean) }
  def once?; end

  sig { returns(T::Boolean) }
  def euc_jp?; end

  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  sig { returns(T::Boolean) }
  def windows_31j?; end

  sig { returns(T::Boolean) }
  def utf_8?; end

  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).returns(Prism::InterpolatedMatchLastLineNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, parts: self.parts, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a regular expression literal that contains interpolation.
#
#     /foo #{bar} baz/
#     ^^^^^^^^^^^^^^^^
class Prism::InterpolatedRegularExpressionNode < Prism::Node
  sig { returns(T::Boolean) }
  def ignore_case?; end

  sig { returns(T::Boolean) }
  def extended?; end

  sig { returns(T::Boolean) }
  def multi_line?; end

  sig { returns(T::Boolean) }
  def once?; end

  sig { returns(T::Boolean) }
  def euc_jp?; end

  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  sig { returns(T::Boolean) }
  def windows_31j?; end

  sig { returns(T::Boolean) }
  def utf_8?; end

  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).returns(Prism::InterpolatedRegularExpressionNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, parts: self.parts, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a string literal that contains interpolation.
#
#     "foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^
class Prism::InterpolatedStringNode < Prism::Node
  sig { returns(T::Boolean) }
  def frozen?; end

  sig { returns(T::Boolean) }
  def mutable?; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode)]) }
  def parts; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode)], closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode)], closing_loc: T.nilable(Prism::Location)).returns(Prism::InterpolatedStringNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, parts: self.parts, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a symbol literal that contains interpolation.
#
#     :"foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^^
class Prism::InterpolatedSymbolNode < Prism::Node
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: T.nilable(Prism::Location)).returns(Prism::InterpolatedSymbolNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, parts: self.parts, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an xstring literal that contains interpolation.
#
#     `foo #{bar} baz`
#     ^^^^^^^^^^^^^^^^
class Prism::InterpolatedXStringNode < Prism::Node
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).returns(Prism::InterpolatedXStringNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, parts: self.parts, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents reading from the implicit `it` local variable.
#
#     -> { it }
#          ^^
class Prism::ItLocalVariableReadNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItLocalVariableReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an implicit set of parameters through the use of the `it` keyword within a block or lambda.
#
#     -> { it + it }
#     ^^^^^^^^^^^^^^
class Prism::ItParametersNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItParametersNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a hash literal without opening and closing braces.
#
#     foo(a: b)
#         ^^^^
class Prism::KeywordHashNode < Prism::Node
  sig { returns(T::Boolean) }
  def symbol_keys?; end

  sig { returns(T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]) }
  def elements; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]).void }
  def initialize(source, node_id, location, flags, elements); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]).returns(Prism::KeywordHashNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, elements: self.elements); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a keyword rest parameter to a method, block, or lambda definition.
#
#     def a(**b)
#           ^^^
#     end
class Prism::KeywordRestParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(T.nilable(Symbol)) }
  def name; end

  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).returns(Prism::KeywordRestParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents using a lambda literal (not the lambda method call).
#
#     ->(value) { value * 2 }
#     ^^^^^^^^^^^^^^^^^^^^^^^
class Prism::LambdaNode < Prism::Node
  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode))) }
  def parameters; end

  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], operator_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location, parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))).void }
  def initialize(source, node_id, location, flags, locals, operator_loc, opening_loc, closing_loc, parameters, body); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], operator_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location, parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))).returns(Prism::LambdaNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, locals: self.locals, operator_loc: self.operator_loc, opening_loc: self.opening_loc, closing_loc: self.closing_loc, parameters: self.parameters, body: self.body); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `&&=` operator for assignment to a local variable.
#
#     target &&= value
#     ^^^^^^^^^^^^^^^^
class Prism::LocalVariableAndWriteNode < Prism::Node
  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Integer) }
  def depth; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node, name: Symbol, depth: Integer).void }
  def initialize(source, node_id, location, flags, name_loc, operator_loc, value, name, depth); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node, name: Symbol, depth: Integer).returns(Prism::LocalVariableAndWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value, name: self.name, depth: self.depth); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents assigning to a local variable using an operator that isn't `=`.
#
#     target += value
#     ^^^^^^^^^^^^^^^
class Prism::LocalVariableOperatorWriteNode < Prism::Node
  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Symbol) }
  def binary_operator; end

  sig { returns(Integer) }
  def depth; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, name: Symbol, binary_operator: Symbol, depth: Integer).void }
  def initialize(source, node_id, location, flags, name_loc, binary_operator_loc, value, name, binary_operator, depth); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, name: Symbol, binary_operator: Symbol, depth: Integer).returns(Prism::LocalVariableOperatorWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name_loc: self.name_loc, binary_operator_loc: self.binary_operator_loc, value: self.value, name: self.name, binary_operator: self.binary_operator, depth: self.depth); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||=` operator for assignment to a local variable.
#
#     target ||= value
#     ^^^^^^^^^^^^^^^^
class Prism::LocalVariableOrWriteNode < Prism::Node
  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Integer) }
  def depth; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node, name: Symbol, depth: Integer).void }
  def initialize(source, node_id, location, flags, name_loc, operator_loc, value, name, depth); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node, name: Symbol, depth: Integer).returns(Prism::LocalVariableOrWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value, name: self.name, depth: self.depth); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents reading a local variable. Note that this requires that a local variable of the same name has already been written to in the same scope, otherwise it is parsed as a method call.
#
#     foo
#     ^^^
class Prism::LocalVariableReadNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Integer) }
  def depth; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer).void }
  def initialize(source, node_id, location, flags, name, depth); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer).returns(Prism::LocalVariableReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, depth: self.depth); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a local variable in a context that doesn't have an explicit value.
#
#     foo, bar = baz
#     ^^^  ^^^
class Prism::LocalVariableTargetNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Integer) }
  def depth; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer).void }
  def initialize(source, node_id, location, flags, name, depth); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer).returns(Prism::LocalVariableTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, depth: self.depth); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing to a local variable.
#
#     foo = 1
#     ^^^^^^^
class Prism::LocalVariableWriteNode < Prism::Node
  sig { returns(Symbol) }
  def name; end

  sig { returns(Integer) }
  def depth; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, depth, name_loc, value, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::LocalVariableWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, depth: self.depth, name_loc: self.name_loc, value: self.value, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a regular expression literal used in the predicate of a conditional to implicitly match against the last line read by an IO object.
#
#     if /foo/i then end
#        ^^^^^^
class Prism::MatchLastLineNode < Prism::Node
  sig { returns(T::Boolean) }
  def ignore_case?; end

  sig { returns(T::Boolean) }
  def extended?; end

  sig { returns(T::Boolean) }
  def multi_line?; end

  sig { returns(T::Boolean) }
  def once?; end

  sig { returns(T::Boolean) }
  def euc_jp?; end

  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  sig { returns(T::Boolean) }
  def windows_31j?; end

  sig { returns(T::Boolean) }
  def utf_8?; end

  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def content_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(String) }
  def unescaped; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).void }
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).returns(Prism::MatchLastLineNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, content_loc: self.content_loc, closing_loc: self.closing_loc, unescaped: self.unescaped); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def content; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the modifier `in` operator.
#
#     foo in bar
#     ^^^^^^^^^^
class Prism::MatchPredicateNode < Prism::Node
  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Node) }
  def pattern; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, pattern: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, value, pattern, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, pattern: Prism::Node, operator_loc: Prism::Location).returns(Prism::MatchPredicateNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value, pattern: self.pattern, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `=>` operator.
#
#     foo => bar
#     ^^^^^^^^^^
class Prism::MatchRequiredNode < Prism::Node
  sig { returns(Prism::Node) }
  def value; end

  sig { returns(Prism::Node) }
  def pattern; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, pattern: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, value, pattern, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, pattern: Prism::Node, operator_loc: Prism::Location).returns(Prism::MatchRequiredNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, value: self.value, pattern: self.pattern, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents writing local variables using a regular expression match with named capture groups.
#
#     /(?<foo>bar)/ =~ baz
#     ^^^^^^^^^^^^^^^^^^^^
class Prism::MatchWriteNode < Prism::Node
  sig { returns(Prism::CallNode) }
  def call; end

  sig { returns(T::Array[Prism::LocalVariableTargetNode]) }
  def targets; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, call: Prism::CallNode, targets: T::Array[Prism::LocalVariableTargetNode]).void }
  def initialize(source, node_id, location, flags, call, targets); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, call: Prism::CallNode, targets: T::Array[Prism::LocalVariableTargetNode]).returns(Prism::MatchWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, call: self.call, targets: self.targets); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a node that is missing from the source and results in a syntax error.
class Prism::MissingNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::MissingNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a module declaration involving the `module` keyword.
#
#     module Foo end
#     ^^^^^^^^^^^^^^
class Prism::ModuleNode < Prism::Node
  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(Prism::Location) }
  def module_keyword_loc; end

  sig { returns(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode)) }
  def constant_path; end

  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], module_keyword_loc: Prism::Location, constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location, name: Symbol).void }
  def initialize(source, node_id, location, flags, locals, module_keyword_loc, constant_path, body, end_keyword_loc, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], module_keyword_loc: Prism::Location, constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location, name: Symbol).returns(Prism::ModuleNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, locals: self.locals, module_keyword_loc: self.module_keyword_loc, constant_path: self.constant_path, body: self.body, end_keyword_loc: self.end_keyword_loc, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def module_keyword; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a multi-target expression.
#
#     a, (b, c) = 1, 2, 3
#        ^^^^^^
#
# This can be a part of `MultiWriteNode` as above, or the target of a `for` loop
#
#     for a, b in [[1, 2], [3, 4]]
#         ^^^^
class Prism::MultiTargetNode < Prism::Node
  sig { returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)]) }
  def lefts; end

  sig { returns(T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode))) }
  def rest; end

  sig { returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)]) }
  def rights; end

  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)), rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)), rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location)).returns(Prism::MultiTargetNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, lefts: self.lefts, rest: self.rest, rights: self.rights, lparen_loc: self.lparen_loc, rparen_loc: self.rparen_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def lparen; end

  sig { returns(T.nilable(String)) }
  def rparen; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a write to a multi-target expression.
#
#     a, b, c = 1, 2, 3
#     ^^^^^^^^^^^^^^^^^
class Prism::MultiWriteNode < Prism::Node
  sig { returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)]) }
  def lefts; end

  sig { returns(T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode))) }
  def rest; end

  sig { returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)]) }
  def rights; end

  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)), rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location), operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)), rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location), operator_loc: Prism::Location, value: Prism::Node).returns(Prism::MultiWriteNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, lefts: self.lefts, rest: self.rest, rights: self.rights, lparen_loc: self.lparen_loc, rparen_loc: self.rparen_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def lparen; end

  sig { returns(T.nilable(String)) }
  def rparen; end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `next` keyword.
#
#     next 1
#     ^^^^^^
class Prism::NextNode < Prism::Node
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, arguments: T.nilable(Prism::ArgumentsNode), keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, arguments, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, arguments: T.nilable(Prism::ArgumentsNode), keyword_loc: Prism::Location).returns(Prism::NextNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, arguments: self.arguments, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `nil` keyword.
#
#     nil
#     ^^^
class Prism::NilNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::NilNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of `**nil` inside method arguments.
#
#     def a(**nil)
#           ^^^^^
#     end
class Prism::NoKeywordsParameterNode < Prism::Node
  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, operator_loc, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, keyword_loc: Prism::Location).returns(Prism::NoKeywordsParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, operator_loc: self.operator_loc, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an implicit set of parameters through the use of numbered parameters within a block or lambda.
#
#     -> { _1 + _2 }
#     ^^^^^^^^^^^^^^
class Prism::NumberedParametersNode < Prism::Node
  sig { returns(Integer) }
  def maximum; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, maximum: Integer).void }
  def initialize(source, node_id, location, flags, maximum); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, maximum: Integer).returns(Prism::NumberedParametersNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, maximum: self.maximum); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents reading a numbered reference to a capture in the previous match.
#
#     $1
#     ^^
class Prism::NumberedReferenceReadNode < Prism::Node
  sig { returns(Integer) }
  def number; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, number: Integer).void }
  def initialize(source, node_id, location, flags, number); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, number: Integer).returns(Prism::NumberedReferenceReadNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, number: self.number); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an optional keyword parameter to a method, block, or lambda definition.
#
#     def a(b: 1)
#           ^^^^
#     end
class Prism::OptionalKeywordParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node).returns(Prism::OptionalKeywordParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an optional parameter to a method, block, or lambda definition.
#
#     def a(b = 1)
#           ^^^^^
#     end
class Prism::OptionalParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def value; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::OptionalParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc, value: self.value); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `||` operator or the `or` keyword.
#
#     left or right
#     ^^^^^^^^^^^^^
class Prism::OrNode < Prism::Node
  sig { returns(Prism::Node) }
  def left; end

  sig { returns(Prism::Node) }
  def right; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).returns(Prism::OrNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, left: self.left, right: self.right, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the list of parameters on a method, block, or lambda definition.
#
#     def a(b, c, d)
#           ^^^^^^^
#     end
class Prism::ParametersNode < Prism::Node
  sig { returns(T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)]) }
  def requireds; end

  sig { returns(T::Array[Prism::OptionalParameterNode]) }
  def optionals; end

  sig { returns(T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode))) }
  def rest; end

  sig { returns(T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)]) }
  def posts; end

  sig { returns(T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)]) }
  def keywords; end

  sig { returns(T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode))) }
  def keyword_rest; end

  sig { returns(T.nilable(Prism::BlockParameterNode)) }
  def block; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)], optionals: T::Array[Prism::OptionalParameterNode], rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)), posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)], keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)], keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)), block: T.nilable(Prism::BlockParameterNode)).void }
  def initialize(source, node_id, location, flags, requireds, optionals, rest, posts, keywords, keyword_rest, block); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)], optionals: T::Array[Prism::OptionalParameterNode], rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)), posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)], keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)], keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)), block: T.nilable(Prism::BlockParameterNode)).returns(Prism::ParametersNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, requireds: self.requireds, optionals: self.optionals, rest: self.rest, posts: self.posts, keywords: self.keywords, keyword_rest: self.keyword_rest, block: self.block); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a parenthesized expression
#
#     (10 + 34)
#     ^^^^^^^^^
class Prism::ParenthesesNode < Prism::Node
  sig { returns(T::Boolean) }
  def multiple_statements?; end

  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, body: T.nilable(Prism::Node), opening_loc: Prism::Location, closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, body, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, body: T.nilable(Prism::Node), opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::ParenthesesNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, body: self.body, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `^` operator for pinning an expression in a pattern matching expression.
#
#     foo in ^(bar)
#            ^^^^^^
class Prism::PinnedExpressionNode < Prism::Node
  sig { returns(Prism::Node) }
  def expression; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Location) }
  def lparen_loc; end

  sig { returns(Prism::Location) }
  def rparen_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, expression: Prism::Node, operator_loc: Prism::Location, lparen_loc: Prism::Location, rparen_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, expression, operator_loc, lparen_loc, rparen_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, expression: Prism::Node, operator_loc: Prism::Location, lparen_loc: Prism::Location, rparen_loc: Prism::Location).returns(Prism::PinnedExpressionNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, expression: self.expression, operator_loc: self.operator_loc, lparen_loc: self.lparen_loc, rparen_loc: self.rparen_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { returns(String) }
  def lparen; end

  sig { returns(String) }
  def rparen; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `^` operator for pinning a variable in a pattern matching expression.
#
#     foo in ^bar
#            ^^^^
class Prism::PinnedVariableNode < Prism::Node
  sig { returns(T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode)) }
  def variable; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, variable, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode), operator_loc: Prism::Location).returns(Prism::PinnedVariableNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, variable: self.variable, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `END` keyword.
#
#     END { foo }
#     ^^^^^^^^^^^
class Prism::PostExecutionNode < Prism::Node
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, statements: T.nilable(Prism::StatementsNode), keyword_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, statements: T.nilable(Prism::StatementsNode), keyword_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::PostExecutionNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, statements: self.statements, keyword_loc: self.keyword_loc, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `BEGIN` keyword.
#
#     BEGIN { foo }
#     ^^^^^^^^^^^^^
class Prism::PreExecutionNode < Prism::Node
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, statements: T.nilable(Prism::StatementsNode), keyword_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, statements: T.nilable(Prism::StatementsNode), keyword_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::PreExecutionNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, statements: self.statements, keyword_loc: self.keyword_loc, opening_loc: self.opening_loc, closing_loc: self.closing_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# The top level node of any parse tree.
class Prism::ProgramNode < Prism::Node
  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(Prism::StatementsNode) }
  def statements; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], statements: Prism::StatementsNode).void }
  def initialize(source, node_id, location, flags, locals, statements); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], statements: Prism::StatementsNode).returns(Prism::ProgramNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, locals: self.locals, statements: self.statements); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `..` or `...` operators.
#
#     1..2
#     ^^^^
#
#     c if a =~ /left/ ... b =~ /right/
#          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
class Prism::RangeNode < Prism::Node
  sig { returns(T::Boolean) }
  def exclude_end?; end

  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: T.nilable(Prism::Node), right: T.nilable(Prism::Node), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, left: T.nilable(Prism::Node), right: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::RangeNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, left: self.left, right: self.right, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a rational number literal.
#
#     1.0r
#     ^^^^
class Prism::RationalNode < Prism::Node
  sig { returns(T::Boolean) }
  def binary?; end

  sig { returns(T::Boolean) }
  def decimal?; end

  sig { returns(T::Boolean) }
  def octal?; end

  sig { returns(T::Boolean) }
  def hexadecimal?; end

  sig { returns(Integer) }
  def numerator; end

  sig { returns(Integer) }
  def denominator; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, numerator: Integer, denominator: Integer).void }
  def initialize(source, node_id, location, flags, numerator, denominator); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, numerator: Integer, denominator: Integer).returns(Prism::RationalNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, numerator: self.numerator, denominator: self.denominator); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `redo` keyword.
#
#     redo
#     ^^^^
class Prism::RedoNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RedoNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a regular expression literal with no interpolation.
#
#     /foo/i
#     ^^^^^^
class Prism::RegularExpressionNode < Prism::Node
  sig { returns(T::Boolean) }
  def ignore_case?; end

  sig { returns(T::Boolean) }
  def extended?; end

  sig { returns(T::Boolean) }
  def multi_line?; end

  sig { returns(T::Boolean) }
  def once?; end

  sig { returns(T::Boolean) }
  def euc_jp?; end

  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  sig { returns(T::Boolean) }
  def windows_31j?; end

  sig { returns(T::Boolean) }
  def utf_8?; end

  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def content_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(String) }
  def unescaped; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).void }
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).returns(Prism::RegularExpressionNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, content_loc: self.content_loc, closing_loc: self.closing_loc, unescaped: self.unescaped); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def content; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a required keyword parameter to a method, block, or lambda definition.
#
#     def a(b: )
#           ^^
#     end
class Prism::RequiredKeywordParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(Symbol) }
  def name; end

  sig { returns(Prism::Location) }
  def name_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location).returns(Prism::RequiredKeywordParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a required parameter to a method, block, or lambda definition.
#
#     def a(b)
#           ^
#     end
class Prism::RequiredParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(Symbol) }
  def name; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::RequiredParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an expression modified with a rescue.
#
#     foo rescue nil
#     ^^^^^^^^^^^^^^
class Prism::RescueModifierNode < Prism::Node
  sig { returns(Prism::Node) }
  def expression; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(Prism::Node) }
  def rescue_expression; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, expression: Prism::Node, keyword_loc: Prism::Location, rescue_expression: Prism::Node).void }
  def initialize(source, node_id, location, flags, expression, keyword_loc, rescue_expression); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, expression: Prism::Node, keyword_loc: Prism::Location, rescue_expression: Prism::Node).returns(Prism::RescueModifierNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, expression: self.expression, keyword_loc: self.keyword_loc, rescue_expression: self.rescue_expression); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a rescue statement.
#
#     begin
#     rescue Foo, *splat, Bar => ex
#       foo
#     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#     end
#
# `Foo, *splat, Bar` are in the `exceptions` field. `ex` is in the `reference` field.
class Prism::RescueNode < Prism::Node
  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T::Array[Prism::Node]) }
  def exceptions; end

  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  sig { returns(T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode))) }
  def reference; end

  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(T.nilable(Prism::RescueNode)) }
  def subsequent; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, exceptions: T::Array[Prism::Node], operator_loc: T.nilable(Prism::Location), reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)), then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), subsequent: T.nilable(Prism::RescueNode)).void }
  def initialize(source, node_id, location, flags, keyword_loc, exceptions, operator_loc, reference, then_keyword_loc, statements, subsequent); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, exceptions: T::Array[Prism::Node], operator_loc: T.nilable(Prism::Location), reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)), then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), subsequent: T.nilable(Prism::RescueNode)).returns(Prism::RescueNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, exceptions: self.exceptions, operator_loc: self.operator_loc, reference: self.reference, then_keyword_loc: self.then_keyword_loc, statements: self.statements, subsequent: self.subsequent); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def operator; end

  sig { returns(T.nilable(String)) }
  def then_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a rest parameter to a method, block, or lambda definition.
#
#     def a(*b)
#           ^^
#     end
class Prism::RestParameterNode < Prism::Node
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  sig { returns(T.nilable(Symbol)) }
  def name; end

  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).returns(Prism::RestParameterNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, name: self.name, name_loc: self.name_loc, operator_loc: self.operator_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `retry` keyword.
#
#     retry
#     ^^^^^
class Prism::RetryNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RetryNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `return` keyword.
#
#     return 1
#     ^^^^^^^^
class Prism::ReturnNode < Prism::Node
  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode)).void }
  def initialize(source, node_id, location, flags, keyword_loc, arguments); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode)).returns(Prism::ReturnNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, arguments: self.arguments); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the `self` keyword.
#
#     self
#     ^^^^
class Prism::SelfNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SelfNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# This node wraps a constant write to indicate that when the value is written, it should have its shareability state modified.
#
#     # shareable_constant_value: literal
#     C = { a: 1 }
#     ^^^^^^^^^^^^
class Prism::ShareableConstantNode < Prism::Node
  sig { returns(T::Boolean) }
  def literal?; end

  sig { returns(T::Boolean) }
  def experimental_everything?; end

  sig { returns(T::Boolean) }
  def experimental_copy?; end

  sig { returns(T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)) }
  def write; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)).void }
  def initialize(source, node_id, location, flags, write); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)).returns(Prism::ShareableConstantNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, write: self.write); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a singleton class declaration involving the `class` keyword.
#
#     class << self end
#     ^^^^^^^^^^^^^^^^^
class Prism::SingletonClassNode < Prism::Node
  sig { returns(T::Array[Symbol]) }
  def locals; end

  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(Prism::Node) }
  def expression; end

  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], class_keyword_loc: Prism::Location, operator_loc: Prism::Location, expression: Prism::Node, body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], class_keyword_loc: Prism::Location, operator_loc: Prism::Location, expression: Prism::Node, body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location).returns(Prism::SingletonClassNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, locals: self.locals, class_keyword_loc: self.class_keyword_loc, operator_loc: self.operator_loc, expression: self.expression, body: self.body, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def class_keyword; end

  sig { returns(String) }
  def operator; end

  sig { returns(String) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `__ENCODING__` keyword.
#
#     __ENCODING__
#     ^^^^^^^^^^^^
class Prism::SourceEncodingNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SourceEncodingNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `__FILE__` keyword.
#
#     __FILE__
#     ^^^^^^^^
class Prism::SourceFileNode < Prism::Node
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def frozen?; end

  sig { returns(T::Boolean) }
  def mutable?; end

  sig { returns(String) }
  def filepath; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, filepath: String).void }
  def initialize(source, node_id, location, flags, filepath); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, filepath: String).returns(Prism::SourceFileNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, filepath: self.filepath); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `__LINE__` keyword.
#
#     __LINE__
#     ^^^^^^^^
class Prism::SourceLineNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SourceLineNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the splat operator.
#
#     [*a]
#      ^^
class Prism::SplatNode < Prism::Node
  sig { returns(Prism::Location) }
  def operator_loc; end

  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, expression: T.nilable(Prism::Node)).void }
  def initialize(source, node_id, location, flags, operator_loc, expression); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, expression: T.nilable(Prism::Node)).returns(Prism::SplatNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, operator_loc: self.operator_loc, expression: self.expression); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def operator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a set of statements contained within some scope.
#
#     foo; bar; baz
#     ^^^^^^^^^^^^^
class Prism::StatementsNode < Prism::Node
  sig { returns(T::Array[Prism::Node]) }
  def body; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, body: T::Array[Prism::Node]).void }
  def initialize(source, node_id, location, flags, body); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, body: T::Array[Prism::Node]).returns(Prism::StatementsNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, body: self.body); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a string literal, a string contained within a `%w` list, or plain string content within an interpolated string.
#
#     "foo"
#     ^^^^^
#
#     %w[foo]
#        ^^^
#
#     "foo #{bar} baz"
#      ^^^^      ^^^^
class Prism::StringNode < Prism::Node
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def frozen?; end

  sig { returns(T::Boolean) }
  def mutable?; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def content_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { returns(String) }
  def unescaped; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), content_loc: Prism::Location, closing_loc: T.nilable(Prism::Location), unescaped: String).void }
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), content_loc: Prism::Location, closing_loc: T.nilable(Prism::Location), unescaped: String).returns(Prism::StringNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, content_loc: self.content_loc, closing_loc: self.closing_loc, unescaped: self.unescaped); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(String) }
  def content; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `super` keyword with parentheses or arguments.
#
#     super()
#     ^^^^^^^
#
#     super foo, bar
#     ^^^^^^^^^^^^^^
class Prism::SuperNode < Prism::Node
  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  sig { returns(T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))) }
  def block; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, lparen_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), rparen_loc: T.nilable(Prism::Location), block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))).void }
  def initialize(source, node_id, location, flags, keyword_loc, lparen_loc, arguments, rparen_loc, block); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, lparen_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), rparen_loc: T.nilable(Prism::Location), block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))).returns(Prism::SuperNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, lparen_loc: self.lparen_loc, arguments: self.arguments, rparen_loc: self.rparen_loc, block: self.block); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def lparen; end

  sig { returns(T.nilable(String)) }
  def rparen; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents a symbol literal or a symbol contained within a `%i` list.
#
#     :foo
#     ^^^^
#
#     %i[foo]
#        ^^^
class Prism::SymbolNode < Prism::Node
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def value_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { returns(String) }
  def unescaped; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), value_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), unescaped: String).void }
  def initialize(source, node_id, location, flags, opening_loc, value_loc, closing_loc, unescaped); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), value_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), unescaped: String).returns(Prism::SymbolNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, value_loc: self.value_loc, closing_loc: self.closing_loc, unescaped: self.unescaped); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(T.nilable(String)) }
  def opening; end

  sig { returns(T.nilable(String)) }
  def value; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the literal `true` keyword.
#
#     true
#     ^^^^
class Prism::TrueNode < Prism::Node
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::TrueNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `undef` keyword.
#
#     undef :foo, :bar, :baz
#     ^^^^^^^^^^^^^^^^^^^^^^
class Prism::UndefNode < Prism::Node
  sig { returns(T::Array[T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)]) }
  def names; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, names: T::Array[T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)], keyword_loc: Prism::Location).void }
  def initialize(source, node_id, location, flags, names, keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, names: T::Array[T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)], keyword_loc: Prism::Location).returns(Prism::UndefNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, names: self.names, keyword_loc: self.keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `unless` keyword, either in the block form or the modifier form.
#
#     bar unless foo
#     ^^^^^^^^^^^^^^
#
#     unless foo then bar end
#     ^^^^^^^^^^^^^^^^^^^^^^^
class Prism::UnlessNode < Prism::Node
  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(Prism::Node) }
  def predicate; end

  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, predicate: Prism::Node, then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), else_clause: T.nilable(Prism::ElseNode), end_keyword_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, keyword_loc, predicate, then_keyword_loc, statements, else_clause, end_keyword_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, predicate: Prism::Node, then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), else_clause: T.nilable(Prism::ElseNode), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::UnlessNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, predicate: self.predicate, then_keyword_loc: self.then_keyword_loc, statements: self.statements, else_clause: self.else_clause, end_keyword_loc: self.end_keyword_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def then_keyword; end

  sig { returns(T.nilable(String)) }
  def end_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `until` keyword, either in the block form or the modifier form.
#
#     bar until foo
#     ^^^^^^^^^^^^^
#
#     until foo do bar end
#     ^^^^^^^^^^^^^^^^^^^^
class Prism::UntilNode < Prism::Node
  sig { returns(T::Boolean) }
  def begin_modifier?; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def do_keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { returns(Prism::Node) }
  def predicate; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), predicate: Prism::Node, statements: T.nilable(Prism::StatementsNode)).void }
  def initialize(source, node_id, location, flags, keyword_loc, do_keyword_loc, closing_loc, predicate, statements); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), predicate: Prism::Node, statements: T.nilable(Prism::StatementsNode)).returns(Prism::UntilNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, do_keyword_loc: self.do_keyword_loc, closing_loc: self.closing_loc, predicate: self.predicate, statements: self.statements); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def do_keyword; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `when` keyword within a case statement.
#
#     case true
#     when true
#     ^^^^^^^^^
#     end
class Prism::WhenNode < Prism::Node
  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T::Array[Prism::Node]) }
  def conditions; end

  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, conditions: T::Array[Prism::Node], then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode)).void }
  def initialize(source, node_id, location, flags, keyword_loc, conditions, then_keyword_loc, statements); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, conditions: T::Array[Prism::Node], then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode)).returns(Prism::WhenNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, conditions: self.conditions, then_keyword_loc: self.then_keyword_loc, statements: self.statements); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def then_keyword; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `while` keyword, either in the block form or the modifier form.
#
#     bar while foo
#     ^^^^^^^^^^^^^
#
#     while foo do bar end
#     ^^^^^^^^^^^^^^^^^^^^
class Prism::WhileNode < Prism::Node
  sig { returns(T::Boolean) }
  def begin_modifier?; end

  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def do_keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  sig { returns(Prism::Node) }
  def predicate; end

  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), predicate: Prism::Node, statements: T.nilable(Prism::StatementsNode)).void }
  def initialize(source, node_id, location, flags, keyword_loc, do_keyword_loc, closing_loc, predicate, statements); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), predicate: Prism::Node, statements: T.nilable(Prism::StatementsNode)).returns(Prism::WhileNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, do_keyword_loc: self.do_keyword_loc, closing_loc: self.closing_loc, predicate: self.predicate, statements: self.statements); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def do_keyword; end

  sig { returns(T.nilable(String)) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents an xstring literal with no interpolation.
#
#     `foo`
#     ^^^^^
class Prism::XStringNode < Prism::Node
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Prism::Location) }
  def content_loc; end

  sig { returns(Prism::Location) }
  def closing_loc; end

  sig { returns(String) }
  def unescaped; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).void }
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).returns(Prism::XStringNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, opening_loc: self.opening_loc, content_loc: self.content_loc, closing_loc: self.closing_loc, unescaped: self.unescaped); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def opening; end

  sig { returns(String) }
  def content; end

  sig { returns(String) }
  def closing; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Represents the use of the `yield` keyword.
#
#     yield 1
#     ^^^^^^^
class Prism::YieldNode < Prism::Node
  sig { returns(Prism::Location) }
  def keyword_loc; end

  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, lparen_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), rparen_loc: T.nilable(Prism::Location)).void }
  def initialize(source, node_id, location, flags, keyword_loc, lparen_loc, arguments, rparen_loc); end

  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, lparen_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), rparen_loc: T.nilable(Prism::Location)).returns(Prism::YieldNode) }
  def copy(node_id: self.node_id, location: self.location, flags: self.flags, keyword_loc: self.keyword_loc, lparen_loc: self.lparen_loc, arguments: self.arguments, rparen_loc: self.rparen_loc); end

  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { returns(String) }
  def keyword; end

  sig { returns(T.nilable(String)) }
  def lparen; end

  sig { returns(T.nilable(String)) }
  def rparen; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { override.returns(String) }
  def inspect; end

  sig { override.returns(Symbol) }
  def type; end
end

# Flags for arguments nodes.
module Prism::ArgumentsNodeFlags
  # if the arguments contain forwarding
  CONTAINS_FORWARDING = T.let(1 << 2, Integer)
  # if the arguments contain keywords
  CONTAINS_KEYWORDS = T.let(1 << 3, Integer)
  # if the arguments contain a keyword splat
  CONTAINS_KEYWORD_SPLAT = T.let(1 << 4, Integer)
  # if the arguments contain a splat
  CONTAINS_SPLAT = T.let(1 << 5, Integer)
  # if the arguments contain multiple splats
  CONTAINS_MULTIPLE_SPLATS = T.let(1 << 6, Integer)
end

# Flags for array nodes.
module Prism::ArrayNodeFlags
  # if array contains splat nodes
  CONTAINS_SPLAT = T.let(1 << 2, Integer)
end

# Flags for call nodes.
module Prism::CallNodeFlags
  # &. operator
  SAFE_NAVIGATION = T.let(1 << 2, Integer)
  # a call that could have been a local variable
  VARIABLE_CALL = T.let(1 << 3, Integer)
  # a call that is an attribute write, so the value being written should be returned
  ATTRIBUTE_WRITE = T.let(1 << 4, Integer)
  # a call that ignores method visibility
  IGNORE_VISIBILITY = T.let(1 << 5, Integer)
end

# Flags for nodes that have unescaped content.
module Prism::EncodingFlags
  # internal bytes forced the encoding to UTF-8
  FORCED_UTF8_ENCODING = T.let(1 << 2, Integer)
  # internal bytes forced the encoding to binary
  FORCED_BINARY_ENCODING = T.let(1 << 3, Integer)
end

# Flags for integer nodes that correspond to the base of the integer.
module Prism::IntegerBaseFlags
  # 0b prefix
  BINARY = T.let(1 << 2, Integer)
  # 0d or no prefix
  DECIMAL = T.let(1 << 3, Integer)
  # 0o or 0 prefix
  OCTAL = T.let(1 << 4, Integer)
  # 0x prefix
  HEXADECIMAL = T.let(1 << 5, Integer)
end

# Flags for interpolated string nodes that indicated mutability if they are also marked as literals.
module Prism::InterpolatedStringNodeFlags
  # frozen by virtue of a `frozen_string_literal: true` comment or `--enable-frozen-string-literal`; only for adjacent string literals like `'a' 'b'`
  FROZEN = T.let(1 << 2, Integer)
  # mutable by virtue of a `frozen_string_literal: false` comment or `--disable-frozen-string-literal`; only for adjacent string literals like `'a' 'b'`
  MUTABLE = T.let(1 << 3, Integer)
end

# Flags for keyword hash nodes.
module Prism::KeywordHashNodeFlags
  # a keyword hash which only has `AssocNode` elements all with symbol keys, which means the elements can be treated as keyword arguments
  SYMBOL_KEYS = T.let(1 << 2, Integer)
end

# Flags for while and until loop nodes.
module Prism::LoopFlags
  # a loop after a begin statement, so the body is executed first before the condition
  BEGIN_MODIFIER = T.let(1 << 2, Integer)
end

# Flags for parameter nodes.
module Prism::ParameterFlags
  # a parameter name that has been repeated in the method signature
  REPEATED_PARAMETER = T.let(1 << 2, Integer)
end

# Flags for parentheses nodes.
module Prism::ParenthesesNodeFlags
  # parentheses that contain multiple potentially void statements
  MULTIPLE_STATEMENTS = T.let(1 << 2, Integer)
end

# Flags for range and flip-flop nodes.
module Prism::RangeFlags
  # ... operator
  EXCLUDE_END = T.let(1 << 2, Integer)
end

# Flags for regular expression and match last line nodes.
module Prism::RegularExpressionFlags
  # i - ignores the case of characters when matching
  IGNORE_CASE = T.let(1 << 2, Integer)
  # x - ignores whitespace and allows comments in regular expressions
  EXTENDED = T.let(1 << 3, Integer)
  # m - allows $ to match the end of lines within strings
  MULTI_LINE = T.let(1 << 4, Integer)
  # o - only interpolates values into the regular expression once
  ONCE = T.let(1 << 5, Integer)
  # e - forces the EUC-JP encoding
  EUC_JP = T.let(1 << 6, Integer)
  # n - forces the ASCII-8BIT encoding
  ASCII_8BIT = T.let(1 << 7, Integer)
  # s - forces the Windows-31J encoding
  WINDOWS_31J = T.let(1 << 8, Integer)
  # u - forces the UTF-8 encoding
  UTF_8 = T.let(1 << 9, Integer)
  # internal bytes forced the encoding to UTF-8
  FORCED_UTF8_ENCODING = T.let(1 << 10, Integer)
  # internal bytes forced the encoding to binary
  FORCED_BINARY_ENCODING = T.let(1 << 11, Integer)
  # internal bytes forced the encoding to US-ASCII
  FORCED_US_ASCII_ENCODING = T.let(1 << 12, Integer)
end

# Flags for shareable constant nodes.
module Prism::ShareableConstantNodeFlags
  # constant writes that should be modified with shareable constant value literal
  LITERAL = T.let(1 << 2, Integer)
  # constant writes that should be modified with shareable constant value experimental everything
  EXPERIMENTAL_EVERYTHING = T.let(1 << 3, Integer)
  # constant writes that should be modified with shareable constant value experimental copy
  EXPERIMENTAL_COPY = T.let(1 << 4, Integer)
end

# Flags for string nodes.
module Prism::StringFlags
  # internal bytes forced the encoding to UTF-8
  FORCED_UTF8_ENCODING = T.let(1 << 2, Integer)
  # internal bytes forced the encoding to binary
  FORCED_BINARY_ENCODING = T.let(1 << 3, Integer)
  # frozen by virtue of a `frozen_string_literal: true` comment or `--enable-frozen-string-literal`
  FROZEN = T.let(1 << 4, Integer)
  # mutable by virtue of a `frozen_string_literal: false` comment or `--disable-frozen-string-literal`
  MUTABLE = T.let(1 << 5, Integer)
end

# Flags for symbol nodes.
module Prism::SymbolFlags
  # internal bytes forced the encoding to UTF-8
  FORCED_UTF8_ENCODING = T.let(1 << 2, Integer)
  # internal bytes forced the encoding to binary
  FORCED_BINARY_ENCODING = T.let(1 << 3, Integer)
  # internal bytes forced the encoding to US-ASCII
  FORCED_US_ASCII_ENCODING = T.let(1 << 4, Integer)
end

# The flags that are common to all nodes.
module Prism::NodeFlags
  # A flag to indicate that the node is a candidate to emit a :line event
  # through tracepoint when compiled.
  NEWLINE = T.let(1, Integer)

  # A flag to indicate that the value that the node represents is a value that
  # can be determined at parse-time.
  STATIC_LITERAL = T.let(2, Integer)
end
