/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.internal.ConstructorCache;
import software.amazon.awssdk.checksums.internal.CrcCloneOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.CrcCombineOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.SdkCrc32CChecksum;

@SdkInternalApi
public final class CrcChecksumProvider {
    private static final String CRT_CRC32C_CLASS_PATH = "software.amazon.awssdk.crt.checksums.CRC32C";
    private static final String JAVA_CRC32C_CLASS_PATH = "java.util.zip.CRC32C";
    private static final ConstructorCache CONSTRUCTOR_CACHE = new ConstructorCache();
    private static final String CRT_CRC64NVME_PATH = "software.amazon.awssdk.crt.checksums.CRC64NVME";
    private static final String CRT_MODULE = "software.amazon.awssdk.crt:aws-crt";

    private CrcChecksumProvider() {
    }

    static SdkChecksum createSdkBasedCrc32C() {
        SdkCrc32CChecksum sdkChecksum = SdkCrc32CChecksum.create();
        return new CrcCloneOnMarkChecksum(sdkChecksum);
    }

    public static SdkChecksum crc32cImplementation() {
        SdkChecksum checksum = CrcChecksumProvider.createJavaCrc32C();
        if (checksum == null) {
            checksum = CrcChecksumProvider.createCrtCrc32C();
        }
        return checksum != null ? checksum : CrcChecksumProvider.createSdkBasedCrc32C();
    }

    static SdkChecksum createCrtCrc32C() {
        return CONSTRUCTOR_CACHE.getConstructor(CRT_CRC32C_CLASS_PATH).map(constructor -> {
            try {
                Checksum checksumInstance = (Checksum)constructor.newInstance(new Object[0]);
                return new CrcCloneOnMarkChecksum(checksumInstance);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate software.amazon.awssdk.crt.checksums.CRC32C", e);
            }
        }).orElse(null);
    }

    static SdkChecksum crc64NvmeCrtImplementation() {
        return CONSTRUCTOR_CACHE.getConstructor(CRT_CRC64NVME_PATH).map(constructor -> {
            try {
                Checksum checksumInstance = (Checksum)constructor.newInstance(new Object[0]);
                return new CrcCloneOnMarkChecksum(checksumInstance);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate software.amazon.awssdk.crt.checksums.CRC32C", e);
            }
        }).orElseThrow(() -> new RuntimeException("Could not load software.amazon.awssdk.crt.checksums.CRC64NVME. Add dependency on 'software.amazon.awssdk.crt:aws-crt' module to enable CRC64NVME feature."));
    }

    static SdkChecksum createJavaCrc32C() {
        return CONSTRUCTOR_CACHE.getConstructor(JAVA_CRC32C_CLASS_PATH).map(constructor -> {
            try {
                return new CrcCombineOnMarkChecksum((Checksum)constructor.newInstance(new Object[0]), SdkCrc32CChecksum::combine);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate java.util.zip.CRC32C", e);
            }
        }).orElse(null);
    }
}

