/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;

public final class AstTypeMatch
extends Pattern {
    private final TypeReference _type;

    public AstTypeMatch(TypeReference type) {
        this._type = VerifyArgument.notNull(type, "type");
    }

    @NotNull
    public final TypeReference getType() {
        return this._type;
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof AstType) {
            TypeReference otherType = ((AstType)other).getUserData(Keys.TYPE_REFERENCE);
            return otherType != null && this._type.isEquivalentTo(otherType);
        }
        return false;
    }
}

