/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.analysis.ja.util.CSVUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;

abstract class BinaryDictionaryWriter {
    private static final int ID_LIMIT = 8192;
    private final Class<? extends BinaryDictionary> implClazz;
    protected ByteBuffer buffer;
    private int targetMapEndOffset = 0;
    private int lastWordId = -1;
    private int lastSourceId = -1;
    private int[] targetMap = new int[8192];
    private int[] targetMapOffsets = new int[8192];
    private final ArrayList<String> posDict = new ArrayList();

    BinaryDictionaryWriter(Class<? extends BinaryDictionary> implClazz, int size) {
        this.implClazz = implClazz;
        this.buffer = ByteBuffer.allocateDirect(size);
    }

    public int put(String[] entry) {
        int i;
        short leftId = Short.parseShort(entry[1]);
        short rightId = Short.parseShort(entry[2]);
        short wordCost = Short.parseShort(entry[3]);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 4; i2 < 8; ++i2) {
            String part = entry[i2];
            assert (part.length() > 0);
            if ("*".equals(part)) continue;
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(part);
        }
        String posData = sb.toString();
        if (posData.isEmpty()) {
            throw new IllegalArgumentException("POS fields are empty");
        }
        sb.setLength(0);
        sb.append(CSVUtil.quoteEscape(posData));
        sb.append(',');
        if (!"*".equals(entry[8])) {
            sb.append(CSVUtil.quoteEscape(entry[8]));
        }
        sb.append(',');
        if (!"*".equals(entry[9])) {
            sb.append(CSVUtil.quoteEscape(entry[9]));
        }
        String fullPOSData = sb.toString();
        String baseForm = entry[10];
        String reading = entry[11];
        String pronunciation = entry[12];
        int left = this.buffer.remaining();
        int worstCase = 7 + 2 * (baseForm.length() + reading.length() + pronunciation.length());
        if (worstCase > left) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(ArrayUtil.oversize((int)(this.buffer.limit() + worstCase - left), (int)1));
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        int flags = 0;
        if (baseForm.isEmpty()) {
            throw new IllegalArgumentException("base form is empty");
        }
        if (!"*".equals(baseForm) && !baseForm.equals(entry[0])) {
            flags |= 1;
        }
        if (!reading.equals(this.toKatakana(entry[0]))) {
            flags |= 2;
        }
        if (!pronunciation.equals(reading)) {
            flags |= 4;
        }
        if (leftId != rightId) {
            throw new IllegalArgumentException("rightId != leftId: " + rightId + " " + leftId);
        }
        if (leftId >= 8192) {
            throw new IllegalArgumentException("leftId >= 8192: " + leftId);
        }
        int toFill = 1 + leftId - this.posDict.size();
        for (int i3 = 0; i3 < toFill; ++i3) {
            this.posDict.add(null);
        }
        String existing = this.posDict.get(leftId);
        if (existing != null && !existing.equals(fullPOSData)) {
            throw new IllegalArgumentException("Multiple entries found for leftID=" + leftId);
        }
        this.posDict.set(leftId, fullPOSData);
        this.buffer.putShort((short)(leftId << 3 | flags));
        this.buffer.putShort(wordCost);
        if ((flags & 1) != 0) {
            if (baseForm.length() >= 16) {
                throw new IllegalArgumentException("Length of base form " + baseForm + " is >= 16");
            }
            int shared = BinaryDictionaryWriter.sharedPrefix(entry[0], baseForm);
            int suffix = baseForm.length() - shared;
            this.buffer.put((byte)(shared << 4 | suffix));
            for (int i4 = shared; i4 < baseForm.length(); ++i4) {
                this.buffer.putChar(baseForm.charAt(i4));
            }
        }
        if ((flags & 2) != 0) {
            if (this.isKatakana(reading)) {
                this.buffer.put((byte)(reading.length() << 1 | 1));
                this.writeKatakana(reading);
            } else {
                this.buffer.put((byte)(reading.length() << 1));
                for (i = 0; i < reading.length(); ++i) {
                    this.buffer.putChar(reading.charAt(i));
                }
            }
        }
        if ((flags & 4) != 0) {
            if (this.isKatakana(pronunciation)) {
                this.buffer.put((byte)(pronunciation.length() << 1 | 1));
                this.writeKatakana(pronunciation);
            } else {
                this.buffer.put((byte)(pronunciation.length() << 1));
                for (i = 0; i < pronunciation.length(); ++i) {
                    this.buffer.putChar(pronunciation.charAt(i));
                }
            }
        }
        return this.buffer.position();
    }

    private boolean isKatakana(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '\u30a0' && ch <= '\u30ff') continue;
            return false;
        }
        return true;
    }

    private void writeKatakana(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.buffer.put((byte)(s.charAt(i) - 12448));
        }
    }

    private String toKatakana(String s) {
        char[] text = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            text[i] = ch > '\u3040' && ch < '\u3097' ? (char)(ch + 96) : ch;
        }
        return new String(text);
    }

    private static int sharedPrefix(String left, String right) {
        int len = left.length() < right.length() ? left.length() : right.length();
        for (int i = 0; i < len; ++i) {
            if (left.charAt(i) == right.charAt(i)) continue;
            return i;
        }
        return len;
    }

    void addMapping(int sourceId, int wordId) {
        if (wordId <= this.lastWordId) {
            throw new IllegalStateException("words out of order: " + wordId + " vs lastID: " + this.lastWordId);
        }
        if (sourceId > this.lastSourceId) {
            this.targetMapOffsets = ArrayUtil.grow((int[])this.targetMapOffsets, (int)(sourceId + 1));
            for (int i = this.lastSourceId + 1; i <= sourceId; ++i) {
                this.targetMapOffsets[i] = this.targetMapEndOffset;
            }
        } else if (sourceId != this.lastSourceId) {
            throw new IllegalStateException("source ids not in increasing order: lastSourceId=" + this.lastSourceId + " vs sourceId=" + sourceId);
        }
        this.targetMap = ArrayUtil.grow((int[])this.targetMap, (int)(this.targetMapEndOffset + 1));
        this.targetMap[this.targetMapEndOffset] = wordId;
        ++this.targetMapEndOffset;
        this.lastSourceId = sourceId;
        this.lastWordId = wordId;
    }

    final String getBaseFileName() {
        return this.implClazz.getName().replace('.', '/');
    }

    public void write(Path baseDir) throws IOException {
        String baseName = this.getBaseFileName();
        this.writeDictionary(baseDir.resolve(baseName + "$buffer.dat"));
        this.writeTargetMap(baseDir.resolve(baseName + "$targetMap.dat"));
        this.writePosDict(baseDir.resolve(baseName + "$posDict.dat"));
    }

    private void writeTargetMap(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)bos);
            CodecUtil.writeHeader((DataOutput)out, (String)"kuromoji_dict_map", (int)1);
            int numSourceIds = this.lastSourceId + 1;
            out.writeVInt(this.targetMapEndOffset);
            out.writeVInt(numSourceIds + 1);
            int prev = 0;
            int sourceId = 0;
            for (int ofs = 0; ofs < this.targetMapEndOffset; ++ofs) {
                int val = this.targetMap[ofs];
                int delta = val - prev;
                assert (delta >= 0);
                if (ofs == this.targetMapOffsets[sourceId]) {
                    out.writeVInt(delta << 1 | 1);
                    ++sourceId;
                } else {
                    out.writeVInt(delta << 1);
                }
                prev += delta;
            }
            if (sourceId != numSourceIds) {
                throw new IllegalStateException("sourceId:" + sourceId + " != numSourceIds:" + numSourceIds);
            }
        }
    }

    private void writePosDict(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)bos);
            CodecUtil.writeHeader((DataOutput)out, (String)"kuromoji_dict_pos", (int)1);
            out.writeVInt(this.posDict.size());
            for (String s : this.posDict) {
                if (s == null) {
                    out.writeByte((byte)0);
                    out.writeByte((byte)0);
                    out.writeByte((byte)0);
                    continue;
                }
                String[] data = CSVUtil.parse(s);
                if (data.length != 3) {
                    throw new IllegalArgumentException("Malformed pos/inflection: " + s + "; expected 3 characters");
                }
                out.writeString(data[0]);
                out.writeString(data[1]);
                out.writeString(data[2]);
            }
        }
    }

    private void writeDictionary(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)bos);
            CodecUtil.writeHeader((DataOutput)out, (String)"kuromoji_dict", (int)1);
            out.writeVInt(this.buffer.position());
            WritableByteChannel channel = Channels.newChannel(bos);
            this.buffer.flip();
            channel.write(this.buffer);
            assert ((long)this.buffer.remaining() == 0L);
        }
    }
}

