/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.AttributeFetcher;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.DeleteCollectionRequest;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementModificationException;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.ReplicaMetric;
import org.apache.solr.cluster.placement.ShardMetrics;
import org.apache.solr.cluster.placement.impl.NodeMetricImpl;
import org.apache.solr.cluster.placement.impl.ReplicaMetricImpl;
import org.apache.solr.cluster.placement.plugins.AffinityPlacementConfig;
import org.apache.solr.cluster.placement.plugins.OrderedNodePlacementPlugin;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityPlacementFactory
implements PlacementPluginFactory<AffinityPlacementConfig> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    AffinityPlacementConfig config = AffinityPlacementConfig.DEFAULT;

    @Override
    public PlacementPlugin createPluginInstance() {
        this.config.validate();
        return new AffinityPlacementPlugin(this.config.minimalFreeDiskGB, this.config.prioritizedFreeDiskGB, this.config.withCollection, this.config.withCollectionShards, this.config.collectionNodeType, this.config.spreadAcrossDomains);
    }

    @Override
    public void configure(AffinityPlacementConfig cfg) {
        Objects.requireNonNull(cfg, "configuration must never be null");
        cfg.validate();
        this.config = cfg;
    }

    @Override
    public AffinityPlacementConfig getConfig() {
        return this.config;
    }

    static class AffinityPlacementPlugin
    extends OrderedNodePlacementPlugin {
        private final long minimalFreeDiskGB;
        private final long prioritizedFreeDiskGB;
        private final Map<String, String> withCollections;
        private final Map<String, String> withCollectionShards;
        private final Map<String, Set<String>> collocatedWith;
        private final Map<String, Set<String>> nodeTypes;
        private final boolean spreadAcrossDomains;

        AffinityPlacementPlugin(long minimalFreeDiskGB, long prioritizedFreeDiskGB, Map<String, String> withCollections, Map<String, String> withCollectionShards, Map<String, String> collectionNodeTypes, boolean spreadAcrossDomains) {
            this.minimalFreeDiskGB = minimalFreeDiskGB;
            this.prioritizedFreeDiskGB = prioritizedFreeDiskGB;
            Objects.requireNonNull(withCollections, "withCollections must not be null");
            Objects.requireNonNull(collectionNodeTypes, "collectionNodeTypes must not be null");
            Objects.requireNonNull(withCollectionShards, "withCollectionShards must not be null");
            this.spreadAcrossDomains = spreadAcrossDomains;
            this.withCollections = withCollections;
            this.withCollectionShards = withCollectionShards;
            HashMap collocated = new HashMap();
            List.of(this.withCollections, this.withCollectionShards).forEach(direct -> direct.forEach((primary, secondary) -> collocated.computeIfAbsent(secondary, s -> new HashSet()).add(primary)));
            this.collocatedWith = Collections.unmodifiableMap(collocated);
            if (collectionNodeTypes.isEmpty()) {
                this.nodeTypes = Map.of();
            } else {
                this.nodeTypes = new HashMap<String, Set<String>>();
                collectionNodeTypes.forEach((coll, typesString) -> {
                    List types = StrUtils.splitSmart((String)typesString, (char)',', (boolean)true);
                    if (!types.isEmpty()) {
                        this.nodeTypes.put((String)coll, new HashSet(types));
                    }
                });
            }
        }

        @Override
        protected void verifyDeleteCollection(DeleteCollectionRequest deleteCollectionRequest, PlacementContext placementContext) throws PlacementModificationException {
            Cluster cluster = placementContext.getCluster();
            Set collocatedCollections = this.collocatedWith.getOrDefault(deleteCollectionRequest.getCollection().getName(), Set.of());
            for (String primaryName : collocatedCollections) {
                try {
                    if (cluster.getCollection(primaryName) == null) continue;
                    throw new PlacementModificationException("collocated collection " + primaryName + " of " + deleteCollectionRequest.getCollection().getName() + " still present");
                }
                catch (IOException e) {
                    throw new PlacementModificationException("failed to retrieve collocated collection information", e);
                }
            }
        }

        @Override
        protected Map<Node, OrderedNodePlacementPlugin.WeightedNode> getBaseWeightedNodes(PlacementContext placementContext, Set<Node> nodes, Iterable<SolrCollection> relevantCollections, boolean skipNodesWithErrors) throws PlacementException {
            AttributeFetcher attributeFetcher = placementContext.getAttributeFetcher();
            attributeFetcher.requestNodeSystemProperty("availability_zone").requestNodeSystemProperty("node_type").requestNodeSystemProperty("replica_type").requestNodeSystemProperty("spread_domain");
            attributeFetcher.requestNodeMetric(NodeMetricImpl.NUM_CORES).requestNodeMetric(NodeMetricImpl.FREE_DISK_GB);
            Set<ReplicaMetric<?>> replicaMetrics = Set.of(ReplicaMetricImpl.INDEX_SIZE_GB);
            HashSet<String> requestedCollections = new HashSet<String>();
            for (SolrCollection collection : relevantCollections) {
                if (!requestedCollections.add(collection.getName())) continue;
                attributeFetcher.requestCollectionMetrics(collection, replicaMetrics);
            }
            attributeFetcher.fetchFrom(nodes);
            AttributeValues attrValues = attributeFetcher.fetchAttributes();
            AffinityPlacementContext affinityPlacementContext = new AffinityPlacementContext();
            affinityPlacementContext.doSpreadAcrossDomains = this.spreadAcrossDomains;
            HashMap affinityNodeMap = CollectionUtil.newHashMap((int)nodes.size());
            for (Node node : nodes) {
                AffinityNode affinityNode = this.newNodeFromMetrics(node, attrValues, affinityPlacementContext, skipNodesWithErrors);
                if (affinityNode == null) continue;
                affinityNodeMap.put(node, affinityNode);
            }
            if (affinityPlacementContext.allSpreadDomains.size() < 2) {
                affinityPlacementContext.doSpreadAcrossDomains = false;
            }
            return affinityNodeMap;
        }

        AffinityNode newNodeFromMetrics(Node node, AttributeValues attrValues, AffinityPlacementContext affinityPlacementContext, boolean skipNodesWithErrors) throws PlacementException {
            String spreadDomain;
            Optional<String> nodePropOpt;
            Set<Object> supportedReplicaTypes = attrValues.getSystemProperty(node, "replica_type").stream().flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).map(s -> s.toUpperCase(Locale.ROOT)).map(s -> {
                try {
                    return Replica.ReplicaType.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Node {} has an invalid value for the {} systemProperty: {}", new Object[]{node.getName(), "replica_type", s});
                    return null;
                }
            }).collect(Collectors.toSet());
            if (supportedReplicaTypes.isEmpty()) {
                supportedReplicaTypes = Set.of(Replica.ReplicaType.values());
            }
            Set<String> nodeType = (nodePropOpt = attrValues.getSystemProperty(node, "node_type")).isEmpty() ? Collections.emptySet() : new HashSet(StrUtils.splitSmart((String)nodePropOpt.get(), (char)','));
            Optional<Double> nodeFreeDiskGB = attrValues.getNodeMetric(node, NodeMetricImpl.FREE_DISK_GB);
            Optional<Integer> nodeNumCores = attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES);
            String az = attrValues.getSystemProperty(node, "availability_zone").orElse("uNd3f1NeD");
            affinityPlacementContext.allAvailabilityZones.add(az);
            if (affinityPlacementContext.doSpreadAcrossDomains) {
                spreadDomain = attrValues.getSystemProperty(node, "spread_domain").orElse(null);
                if (spreadDomain == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("AffinityPlacementPlugin configured to spread across domains, but node {} does not have the {} system property. Ignoring spreadAcrossDomains.", (Object)node.getName(), (Object)"spread_domain");
                    }
                    affinityPlacementContext.doSpreadAcrossDomains = false;
                    affinityPlacementContext.allSpreadDomains.clear();
                } else {
                    affinityPlacementContext.allSpreadDomains.add(spreadDomain);
                }
            } else {
                spreadDomain = null;
            }
            if (nodeFreeDiskGB.isEmpty() && skipNodesWithErrors) {
                if (log.isWarnEnabled()) {
                    log.warn("Unknown free disk on node {}, excluding it from placement decisions.", (Object)node.getName());
                }
                return null;
            }
            if (nodeNumCores.isEmpty() && skipNodesWithErrors) {
                if (log.isWarnEnabled()) {
                    log.warn("Unknown number of cores on node {}, excluding it from placement decisions.", (Object)node.getName());
                }
                return null;
            }
            return new AffinityNode(node, attrValues, affinityPlacementContext, supportedReplicaTypes, nodeType, nodeNumCores.orElse(0), nodeFreeDiskGB.orElse(0.0), az, spreadDomain);
        }

        private static class ReplicaSpread {
            private final Set<String> allKeys;
            private final Map<String, Integer> spread;
            private int minReplicasLocated;

            private ReplicaSpread(Set<String> allKeys) {
                this.allKeys = allKeys;
                this.spread = new HashMap<String, Integer>();
                this.minReplicasLocated = 0;
            }

            int overMinimum(String key) {
                return this.spread.getOrDefault(key, 0) - this.minReplicasLocated;
            }

            int projectOverMinimum(String key, int replicaDelta) {
                int overMinimum = this.overMinimum(key);
                if (overMinimum == 0 && replicaDelta > 0) {
                    this.addReplica(key);
                    int projected = this.overMinimum(key);
                    this.removeReplica(key);
                    return projected;
                }
                return Integer.max(0, overMinimum + replicaDelta);
            }

            boolean addReplica(String key) {
                int previous = this.spread.getOrDefault(key, 0);
                this.spread.put(key, previous + 1);
                if (this.allKeys.size() > 0 && this.spread.size() == this.allKeys.size() && previous == this.minReplicasLocated) {
                    this.minReplicasLocated = this.spread.values().stream().mapToInt(Integer::intValue).min().orElse(0);
                    return true;
                }
                return false;
            }

            void removeReplica(String key) {
                Integer replicasLocated = this.spread.computeIfPresent(key, (k, v) -> v - 1 == 0 ? null : Integer.valueOf(v - 1));
                if (replicasLocated == null) {
                    replicasLocated = 0;
                }
                if (replicasLocated < this.minReplicasLocated) {
                    this.minReplicasLocated = replicasLocated;
                }
            }
        }

        private class AffinityNode
        extends OrderedNodePlacementPlugin.WeightedNode {
            private final AttributeValues attrValues;
            private final AffinityPlacementContext affinityPlacementContext;
            private final Set<Replica.ReplicaType> supportedReplicaTypes;
            private final Set<String> nodeType;
            private int coresOnNode;
            private double nodeFreeDiskGB;
            private final String availabilityZone;
            private final String spreadDomain;

            AffinityNode(Node node, AttributeValues attrValues, AffinityPlacementContext affinityPlacementContext, Set<Replica.ReplicaType> supportedReplicaTypes, Set<String> nodeType, int coresOnNode, double nodeFreeDiskGB, String az, String spreadDomain) {
                super(node);
                this.attrValues = attrValues;
                this.affinityPlacementContext = affinityPlacementContext;
                this.supportedReplicaTypes = supportedReplicaTypes;
                this.nodeType = nodeType;
                this.coresOnNode = coresOnNode;
                this.nodeFreeDiskGB = nodeFreeDiskGB;
                this.availabilityZone = az;
                this.spreadDomain = spreadDomain;
            }

            @Override
            public int calcWeight() {
                return this.coresOnNode + 100 * (AffinityPlacementPlugin.this.prioritizedFreeDiskGB > 0L && this.nodeFreeDiskGB < (double)AffinityPlacementPlugin.this.prioritizedFreeDiskGB ? 1 : 0) + 10000 * this.getSpreadDomainWeight() + 1000000 * this.getAZWeight();
            }

            @Override
            public int calcRelevantWeightWithReplica(Replica replica) {
                return this.coresOnNode + 100 * (AffinityPlacementPlugin.this.prioritizedFreeDiskGB > 0L && this.nodeFreeDiskGB - this.getProjectedSizeOfReplica(replica) < (double)AffinityPlacementPlugin.this.prioritizedFreeDiskGB ? 1 : 0) + 10000 * this.projectReplicaSpreadWeight(replica) + 1000000 * this.projectAZWeight(replica);
            }

            @Override
            public boolean canAddReplica(Replica replica) {
                String collection = replica.getShard().getCollection().getName();
                return super.canAddReplica(replica) && this.supportedReplicaTypes.contains((Object)replica.getType()) && Optional.ofNullable(AffinityPlacementPlugin.this.nodeTypes.get(collection)).map(s -> s.stream().anyMatch(this.nodeType::contains)).orElse(true) != false && Optional.ofNullable(AffinityPlacementPlugin.this.withCollections.get(collection)).map(this::hasCollectionOnNode).orElse(true) != false && Optional.ofNullable(AffinityPlacementPlugin.this.withCollectionShards.get(collection)).map(shardWiseOf -> this.getShardsOnNode((String)shardWiseOf).contains(replica.getShard().getShardName())).orElse(true) != false && (AffinityPlacementPlugin.this.minimalFreeDiskGB <= 0L || this.nodeFreeDiskGB - this.getProjectedSizeOfReplica(replica) > (double)AffinityPlacementPlugin.this.minimalFreeDiskGB);
            }

            @Override
            public Map<Replica, String> canRemoveReplicas(Collection<Replica> replicas) {
                HashMap<Replica, String> replicaRemovalExceptions = new HashMap<Replica, String>();
                HashMap<String, Map> removals = new HashMap<String, Map>();
                for (Replica replica : replicas) {
                    SolrCollection collection = replica.getShard().getCollection();
                    HashSet collocatedCollections = new HashSet();
                    Optional.ofNullable(AffinityPlacementPlugin.this.collocatedWith.get(collection.getName())).ifPresent(collocatedCollections::addAll);
                    collocatedCollections.retainAll(this.getCollectionsOnNode());
                    if (collocatedCollections.isEmpty()) continue;
                    Stream<String> shardWiseCollocations = collocatedCollections.stream().filter(priColl -> collection.getName().equals(AffinityPlacementPlugin.this.withCollectionShards.get(priColl)));
                    Set mandatoryShardsOrAll = shardWiseCollocations.flatMap(priColl -> this.getShardsOnNode((String)priColl).stream()).collect(Collectors.toSet());
                    Set replicasRemovedForShard = removals.computeIfAbsent(replica.getShard().getCollection().getName(), k -> new HashMap()).computeIfAbsent(replica.getShard().getShardName(), k -> new HashSet());
                    replicasRemovedForShard.add(replica);
                    boolean shardWise = false;
                    if (!mandatoryShardsOrAll.isEmpty() && !(shardWise = mandatoryShardsOrAll.contains(replica.getShard().getShardName())) || replicasRemovedForShard.size() < this.getReplicasForShardOnNode(replica.getShard()).size()) continue;
                    replicaRemovalExceptions.put(replica, "co-located with replicas of " + (String)(shardWise ? replica.getShard().getShardName() + " of " : "") + collocatedCollections);
                }
                return replicaRemovalExceptions;
            }

            @Override
            protected boolean addProjectedReplicaWeights(Replica replica) {
                this.nodeFreeDiskGB -= this.getProjectedSizeOfReplica(replica);
                ++this.coresOnNode;
                return this.addReplicaToAzAndSpread(replica);
            }

            @Override
            protected void initReplicaWeights(Replica replica) {
                this.addReplicaToAzAndSpread(replica);
            }

            private boolean addReplicaToAzAndSpread(Replica replica) {
                boolean needsResort = false;
                if (this.affinityPlacementContext.allAvailabilityZones.size() > 1) {
                    needsResort |= this.affinityPlacementContext.availabilityZoneUsage.computeIfAbsent(replica.getShard().getCollection().getName(), k -> new HashMap()).computeIfAbsent(replica.getShard().getShardName(), k -> new HashMap()).computeIfAbsent(replica.getType(), k -> new ReplicaSpread(this.affinityPlacementContext.allAvailabilityZones)).addReplica(this.availabilityZone);
                }
                if (this.affinityPlacementContext.doSpreadAcrossDomains) {
                    needsResort |= this.affinityPlacementContext.spreadDomainUsage.computeIfAbsent(replica.getShard().getCollection().getName(), k -> new HashMap()).computeIfAbsent(replica.getShard().getShardName(), k -> new ReplicaSpread(this.affinityPlacementContext.allSpreadDomains)).addReplica(this.spreadDomain);
                }
                return needsResort;
            }

            @Override
            protected void removeProjectedReplicaWeights(Replica replica) {
                this.nodeFreeDiskGB += this.getProjectedSizeOfReplica(replica);
                --this.coresOnNode;
                if (this.affinityPlacementContext.allAvailabilityZones.size() > 1) {
                    Optional.ofNullable(this.affinityPlacementContext.availabilityZoneUsage.get(replica.getShard().getCollection().getName())).map(m -> (Map)m.get(replica.getShard().getShardName())).map(m -> (ReplicaSpread)m.get((Object)replica.getType())).ifPresent(m -> m.removeReplica(this.availabilityZone));
                }
                if (this.affinityPlacementContext.doSpreadAcrossDomains) {
                    Optional.ofNullable(this.affinityPlacementContext.spreadDomainUsage.get(replica.getShard().getCollection().getName())).map(m -> (ReplicaSpread)m.get(replica.getShard().getShardName())).ifPresent(m -> m.removeReplica(this.spreadDomain));
                }
            }

            private double getProjectedSizeOfReplica(Replica replica) {
                return this.attrValues.getCollectionMetrics(replica.getShard().getCollection().getName()).flatMap(colMetrics -> colMetrics.getShardMetrics(replica.getShard().getShardName())).flatMap(ShardMetrics::getLeaderMetrics).flatMap(lrm -> lrm.getReplicaMetric(ReplicaMetricImpl.INDEX_SIZE_GB)).orElse(0.0);
            }

            private int getSpreadDomainWeight() {
                if (this.affinityPlacementContext.doSpreadAcrossDomains) {
                    return this.affinityPlacementContext.spreadDomainUsage.values().stream().flatMap(m -> m.values().stream()).mapToInt(rs -> rs.overMinimum(this.spreadDomain)).map(i -> i * i).sum();
                }
                return 0;
            }

            private int projectReplicaSpreadWeight(Replica replica) {
                if (replica != null && this.affinityPlacementContext.doSpreadAcrossDomains) {
                    return Optional.ofNullable(this.affinityPlacementContext.spreadDomainUsage.get(replica.getShard().getCollection().getName())).map(m -> (ReplicaSpread)m.get(replica.getShard().getShardName())).map(rs -> rs.projectOverMinimum(this.spreadDomain, 1)).orElse(0);
                }
                return 0;
            }

            private int getAZWeight() {
                if (this.affinityPlacementContext.allAvailabilityZones.size() < 2) {
                    return 0;
                }
                return this.affinityPlacementContext.availabilityZoneUsage.values().stream().flatMap(m -> m.values().stream()).flatMap(m -> m.values().stream()).mapToInt(rs -> rs.overMinimum(this.availabilityZone)).map(i -> i * i).sum();
            }

            private int projectAZWeight(Replica replica) {
                if (replica == null || this.affinityPlacementContext.allAvailabilityZones.size() < 2) {
                    return 0;
                }
                return Optional.ofNullable(this.affinityPlacementContext.availabilityZoneUsage.get(replica.getShard().getCollection().getName())).map(m -> (Map)m.get(replica.getShard().getShardName())).map(m -> (ReplicaSpread)m.get((Object)replica.getType())).map(rs -> rs.projectOverMinimum(this.availabilityZone, 1)).orElse(0);
            }
        }

        private static final class AffinityPlacementContext {
            private final Set<String> allSpreadDomains = new HashSet<String>();
            private final Map<String, Map<String, ReplicaSpread>> spreadDomainUsage = new HashMap<String, Map<String, ReplicaSpread>>();
            private final Set<String> allAvailabilityZones = new HashSet<String>();
            private final Map<String, Map<String, Map<Replica.ReplicaType, ReplicaSpread>>> availabilityZoneUsage = new HashMap<String, Map<String, Map<Replica.ReplicaType, ReplicaSpread>>>();
            private boolean doSpreadAcrossDomains;

            private AffinityPlacementContext() {
            }
        }
    }
}

