/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.solr.cloud.ZkConfigSetService;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.FileSystemConfigSetService;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigSetService {
    public static final String UPLOAD_FILENAME_EXCLUDE_REGEX = "^\\..*$";
    public static final Pattern UPLOAD_FILENAME_EXCLUDE_PATTERN = Pattern.compile("^\\..*$");
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrResourceLoader parentLoader;
    private final Cache<String, IndexSchema> schemaCache;

    public static ConfigSetService createConfigSetService(CoreContainer coreContainer) {
        ConfigSetService configSetService = ConfigSetService.instantiate(coreContainer);
        if (coreContainer.getZkController() != null) {
            configSetService.bootstrapConfigSet(coreContainer);
        }
        return configSetService;
    }

    private static ConfigSetService instantiate(CoreContainer coreContainer) {
        NodeConfig nodeConfig = coreContainer.getConfig();
        SolrResourceLoader loader = coreContainer.getResourceLoader();
        ZkController zkController = coreContainer.getZkController();
        String configSetServiceClass = nodeConfig.getConfigSetServiceClass();
        if (configSetServiceClass != null) {
            try {
                Class<ConfigSetService> clazz = loader.findClass(configSetServiceClass, ConfigSetService.class);
                Constructor<ConfigSetService> constructor = clazz.getConstructor(CoreContainer.class);
                return constructor.newInstance(coreContainer);
            }
            catch (Exception e) {
                throw new RuntimeException("create configSetService instance failed, configSetServiceClass:" + configSetServiceClass, e);
            }
        }
        if (zkController == null) {
            return new FileSystemConfigSetService(coreContainer);
        }
        return new ZkConfigSetService(coreContainer);
    }

    private void bootstrapConfigSet(CoreContainer coreContainer) {
        try {
            boolean boostrapConf;
            this.bootstrapDefaultConf();
            String confDir = System.getProperty("bootstrap_confdir");
            if (confDir != null) {
                this.bootstrapConfDir(confDir);
            }
            if (boostrapConf = Boolean.getBoolean("bootstrap_conf")) {
                ConfigSetService.bootstrapConf(coreContainer);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Config couldn't be uploaded ", (Throwable)e);
        }
    }

    private void bootstrapDefaultConf() throws IOException {
        if (!this.checkConfigExists("_default")) {
            Path configDirPath = ConfigSetService.getDefaultConfigDirPath();
            if (configDirPath == null) {
                log.warn("The _default configset could not be uploaded. Please provide 'solr.default.confdir' parameter that points to a configset {} {}", (Object)"intended to be the default. Current 'solr.default.confdir' value:", (Object)System.getProperty("solr.default.confdir"));
            } else {
                this.uploadConfig("_default", configDirPath);
            }
        }
    }

    private void bootstrapConfDir(String confDir) throws IOException {
        Path configPath = Path.of(confDir, new String[0]);
        if (!Files.isDirectory(configPath, new LinkOption[0])) {
            throw new IllegalArgumentException("bootstrap_confdir must be a directory of configuration files, configPath: " + configPath);
        }
        String confName = System.getProperty("collection.configName", "configuration1");
        this.uploadConfig(confName, configPath);
    }

    public static Path getDefaultConfigDirPath() {
        Path path;
        String confDir = System.getProperty("solr.default.confdir");
        if (confDir != null && Files.exists(path = Path.of(confDir, new String[0]), new LinkOption[0])) {
            return path;
        }
        String installDir = System.getProperty("solr.install.dir");
        if (installDir != null) {
            Path subPath = Path.of("server", "solr", "configsets", "_default", "conf");
            Path path2 = Path.of(installDir, new String[0]).resolve(subPath);
            if (Files.exists(path2, new LinkOption[0])) {
                return path2;
            }
        }
        return null;
    }

    public static Path getConfigsetPath(String confDir, String configSetDir) {
        Path ret = Path.of(confDir, "solrconfig.xml").normalize();
        if (Files.exists(ret, new LinkOption[0])) {
            return Path.of(confDir, new String[0]).normalize();
        }
        ret = Path.of(confDir, "conf", "solrconfig.xml").normalize();
        if (Files.exists(ret, new LinkOption[0])) {
            return Path.of(confDir, "conf").normalize();
        }
        ret = Path.of(configSetDir, confDir, "conf", "solrconfig.xml").normalize();
        if (Files.exists(ret, new LinkOption[0])) {
            return Path.of(configSetDir, confDir, "conf").normalize();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find solrconfig.xml at %s, %s or %s", Path.of(confDir, "solrconfig.xml").normalize().toAbsolutePath(), Path.of(confDir, "conf", "solrconfig.xml").normalize().toAbsolutePath(), Path.of(configSetDir, confDir, "conf", "solrconfig.xml").normalize().toAbsolutePath()));
    }

    public static void bootstrapConf(CoreContainer cc) throws IOException {
        List<CoreDescriptor> cds = cc.getCoresLocator().discover(cc);
        if (log.isInfoEnabled()) {
            log.info("bootstrapping config for {} cores into ZooKeeper using solr.xml from {}", (Object)cds.size(), (Object)cc.getSolrHome());
        }
        for (CoreDescriptor cd : cds) {
            String coreName = cd.getName();
            String confName = cd.getCollectionName();
            if (StrUtils.isNullOrEmpty((String)confName)) {
                confName = coreName;
            }
            Path udir = cd.getInstanceDir().resolve("conf");
            log.info("Uploading directory {} with name {} for solrCore {}", new Object[]{udir, confName, coreName});
            cc.getConfigSetService().uploadConfig(confName, udir);
        }
    }

    public boolean isConfigSetTrusted(String name) throws IOException {
        Map<String, Object> contentMap = this.getConfigMetadata(name);
        return (Boolean)contentMap.getOrDefault("trusted", true);
    }

    public boolean isConfigSetTrusted(SolrResourceLoader coreLoader) throws IOException {
        NamedList<Object> flags = this.loadConfigSetFlags(coreLoader);
        return flags == null || flags.get("trusted") == null || flags.getBooleanArg("trusted") != false;
    }

    public final ConfigSet loadConfigSet(CoreDescriptor dcore) {
        SolrResourceLoader coreLoader = this.createCoreResourceLoader(dcore);
        try {
            NamedList<Object> properties = this.loadConfigSetProperties(dcore, coreLoader);
            boolean trusted = this.isConfigSetTrusted(coreLoader);
            SolrConfig solrConfig = this.createSolrConfig(dcore, coreLoader, trusted);
            return new ConfigSet(this.configSetName(dcore), solrConfig, force -> {
                try {
                    return this.createIndexSchema(dcore, solrConfig, force);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
                }
            }, properties, trusted);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load conf for core " + dcore.getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public ConfigSetService(SolrResourceLoader loader, boolean shareSchema) {
        this.parentLoader = loader;
        this.schemaCache = shareSchema ? Caffeine.newBuilder().weakValues().build() : null;
    }

    protected SolrConfig createSolrConfig(CoreDescriptor cd, SolrResourceLoader loader, boolean isTrusted) throws IOException {
        return SolrConfig.readFromResourceLoader(loader, cd.getConfigName(), isTrusted, cd.getSubstitutableProperties());
    }

    protected IndexSchema createIndexSchema(CoreDescriptor cd, SolrConfig solrConfig, boolean forceFetch) throws IOException {
        String cdSchemaName = cd.getSchemaName();
        IndexSchemaFactory indexSchemaFactory = IndexSchemaFactory.newIndexSchemaFactory(solrConfig);
        String configSet = cd.getConfigSet();
        if (configSet != null && this.schemaCache != null) {
            String guessSchemaName = indexSchemaFactory.getSchemaResourceName(cdSchemaName);
            Long modVersion = this.getCurrentSchemaModificationVersion(configSet, solrConfig, guessSchemaName);
            if (modVersion != null) {
                String cacheKey = configSet + "/" + guessSchemaName + "/" + modVersion + "/" + solrConfig.luceneMatchVersion;
                return (IndexSchema)this.schemaCache.get((Object)cacheKey, key -> indexSchemaFactory.create(cdSchemaName, solrConfig, this));
            }
            log.warn("Unable to get schema modification version, configSet={} schema={}", (Object)configSet, (Object)guessSchemaName);
        }
        return indexSchemaFactory.create(cdSchemaName, solrConfig, this);
    }

    protected abstract Long getCurrentSchemaModificationVersion(String var1, SolrConfig var2, String var3) throws IOException;

    protected NamedList<Object> loadConfigSetProperties(CoreDescriptor cd, SolrResourceLoader loader) throws IOException {
        return ConfigSetProperties.readFromResourceLoader(loader, cd.getConfigSetPropertiesName());
    }

    protected NamedList<Object> loadConfigSetFlags(SolrResourceLoader loader) throws IOException {
        return null;
    }

    protected abstract SolrResourceLoader createCoreResourceLoader(CoreDescriptor var1);

    public abstract String configSetName(CoreDescriptor var1);

    public abstract void uploadConfig(String var1, Path var2) throws IOException;

    public abstract void uploadFileToConfig(String var1, String var2, byte[] var3, boolean var4) throws IOException;

    public abstract void downloadConfig(String var1, Path var2) throws IOException;

    public abstract byte[] downloadFileFromConfig(String var1, String var2) throws IOException;

    public abstract void copyConfig(String var1, String var2) throws IOException;

    public abstract boolean checkConfigExists(String var1) throws IOException;

    public abstract void deleteConfig(String var1) throws IOException;

    public abstract void deleteFilesFromConfig(String var1, List<String> var2) throws IOException;

    public abstract void setConfigMetadata(String var1, Map<String, Object> var2) throws IOException;

    public abstract Map<String, Object> getConfigMetadata(String var1) throws IOException;

    public abstract List<String> listConfigs() throws IOException;

    public abstract List<String> getAllConfigFiles(String var1) throws IOException;

    public static interface ConfigResource {
        public ConfigNode get() throws Exception;
    }
}

