/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.RestoreCoreAPI;
import org.apache.solr.handler.api.V2ApiUtils;

class RestoreCoreOp
implements CoreAdminHandler.CoreAdminOp {
    RestoreCoreOp() {
    }

    @Override
    public boolean isExpensive() {
        return true;
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        RestoreCoreAPI.RestoreCoreRequestBody requestBody = new RestoreCoreAPI.RestoreCoreRequestBody();
        requestBody.name = params.get("name");
        requestBody.shardBackupId = params.get("shardBackupId");
        requestBody.location = params.get("location");
        requestBody.backupRepository = params.get("repository");
        requestBody.validate();
        CoreContainer coreContainer = it.handler.getCoreContainer();
        RestoreCoreAPI api = new RestoreCoreAPI(coreContainer, it.req, it.rsp, it.handler.getCoreAdminAsyncTracker());
        SolrJerseyResponse response = api.restoreCore(cname, requestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    }

    public static RestoreCoreAPI.RestoreCoreRequestBody createRequestFromV1Params(SolrParams params) {
        RestoreCoreAPI.RestoreCoreRequestBody requestBody = new RestoreCoreAPI.RestoreCoreRequestBody();
        requestBody.name = params.get("name");
        requestBody.shardBackupId = params.get("shardBackupId");
        requestBody.location = params.get("location");
        requestBody.backupRepository = params.get("repository");
        return requestBody;
    }
}

