/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collectionName}/balance-shard-unique")
public class BalanceShardUniqueAPI
extends AdminAPIBase {
    @Inject
    public BalanceShardUniqueAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse balanceShardUnique(@PathParam(value="collectionName") String collectionName, BalanceShardUniqueRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("property", requestBody.property);
        this.validatePropertyToBalance(requestBody.property, Boolean.TRUE.equals(requestBody.shardUnique));
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        BalanceShardUniqueAPI.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = BalanceShardUniqueAPI.createRemoteMessage(collectionName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.BALANCESHARDUNIQUE, remoteMessage, requestBody.asyncId);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, BalanceShardUniqueRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("property", requestBody.property);
        BalanceShardUniqueAPI.insertIfNotNull(remoteMessage, "onlyactivenodes", requestBody.onlyActiveNodes);
        BalanceShardUniqueAPI.insertIfNotNull(remoteMessage, "shardUnique", requestBody.shardUnique);
        BalanceShardUniqueAPI.insertIfNotNull(remoteMessage, "async", requestBody.asyncId);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        BalanceShardUniqueAPI api = new BalanceShardUniqueAPI(coreContainer, solrQueryRequest, solrQueryResponse);
        SolrParams params = solrQueryRequest.getParams();
        params.required().check(new String[]{"collection", "property"});
        String collection = params.get("collection");
        BalanceShardUniqueRequestBody requestBody = new BalanceShardUniqueRequestBody();
        requestBody.property = params.get("property");
        requestBody.onlyActiveNodes = params.getBool("onlyactivenodes");
        requestBody.shardUnique = params.getBool("shardUnique");
        requestBody.asyncId = params.get("async");
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, api.balanceShardUnique(collection, requestBody));
    }

    private void validatePropertyToBalance(String prop, boolean shardUnique) {
        if (!((String)(prop = ((String)prop).toLowerCase(Locale.ROOT))).startsWith("property.")) {
            prop = "property." + (String)prop;
        }
        if (!shardUnique && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + (String)prop + " shardUnique: " + shardUnique);
        }
    }

    public static class BalanceShardUniqueRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(required=true)
        public String property;
        @JsonProperty(value="onlyactivenodes")
        public Boolean onlyActiveNodes;
        @JsonProperty
        public Boolean shardUnique;
        @JsonProperty(value="async")
        public String asyncId;
    }
}

