/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/{a:cores|collections}/{collectionName}/schema")
public class GetSchemaAPI
extends JerseyResource {
    protected final IndexSchema indexSchema;

    @Inject
    public GetSchemaAPI(IndexSchema indexSchema) {
        this.indexSchema = indexSchema;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaInfoResponse getSchemaInfo() {
        SchemaInfoResponse response = this.instantiateJerseyResponse(SchemaInfoResponse.class);
        response.schema = this.indexSchema.getNamedPropertyValues();
        return response;
    }

    @GET
    @Path(value="/name")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaNameResponse getSchemaName() throws Exception {
        SchemaNameResponse response = this.instantiateJerseyResponse(SchemaNameResponse.class);
        if (null == this.indexSchema.getSchemaName()) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Schema has no name");
        }
        response.name = this.indexSchema.getSchemaName();
        return response;
    }

    @GET
    @Path(value="/similarity")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaSimilarityResponse getSchemaSimilarity() {
        SchemaSimilarityResponse response = this.instantiateJerseyResponse(SchemaSimilarityResponse.class);
        response.similarity = this.indexSchema.getSimilarityFactory().getNamedPropertyValues();
        return response;
    }

    @GET
    @Path(value="/uniquekey")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaUniqueKeyResponse getSchemaUniqueKey() {
        SchemaUniqueKeyResponse response = this.instantiateJerseyResponse(SchemaUniqueKeyResponse.class);
        response.uniqueKey = this.indexSchema.getUniqueKeyField().getName();
        return response;
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaVersionResponse getSchemaVersion() {
        SchemaVersionResponse response = this.instantiateJerseyResponse(SchemaVersionResponse.class);
        response.version = this.indexSchema.getVersion();
        return response;
    }

    public static class SchemaVersionResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="version")
        public float version;
    }

    public static class SchemaUniqueKeyResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="uniqueKey")
        public String uniqueKey;
    }

    public static class SchemaSimilarityResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="similarity")
        public SimpleOrderedMap<Object> similarity;
    }

    public static class SchemaNameResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="name")
        public String name;
    }

    public static class SchemaInfoResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="schema")
        public Map<String, Object> schema;
    }
}

